/*
 * Decompiled with CFR 0.152.
 */
package com.inet.plugin.help;

import com.inet.annotations.InternalApi;
import com.inet.lib.json.Json;
import com.inet.plugin.help.ConfigViewConfig;
import com.inet.plugin.help.HelpPage;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public interface HelpProvider
extends Comparable<HelpProvider> {
    @Nonnull
    public String getHelpSetPath();

    @Nullable
    public URL getHelpSet();

    @Nonnull
    public String getHelpPackage();

    public int getPriority();

    public boolean isVisible(@Nonnull HelpPage var1);

    public static final class ConfigMode
    extends Enum<ConfigMode> {
        public static final /* enum */ ConfigMode NoConfig = new ConfigMode();
        public static final /* enum */ ConfigMode Normal = new ConfigMode();
        public static final /* enum */ ConfigMode Advanced = new ConfigMode();
        private static final /* synthetic */ ConfigMode[] a;

        public static ConfigMode[] values() {
            return (ConfigMode[])a.clone();
        }

        public static ConfigMode valueOf(String name) {
            return Enum.valueOf(ConfigMode.class, name);
        }

        public static ConfigMode getCurrent() {
            UserAccount userAccount = UserManager.getInstance().getCurrentUserAccount();
            if (userAccount == null) {
                return NoConfig;
            }
            String string = userAccount.getValue(UsersAndGroups.USERFIELD_CONFIG_VIEWCONFIG);
            if (string == null) {
                return Normal;
            }
            boolean bl = ((ConfigViewConfig)new Json().fromJson(string, (Type)((Object)ConfigViewConfig.class), (Map<Object, Map<String, String>>)new HashMap<Object, Map<String, String>>())).isAdvanced();
            return bl ? Advanced : Normal;
        }

        private static /* synthetic */ ConfigMode[] a() {
            return new ConfigMode[]{NoConfig, Normal, Advanced};
        }

        static {
            a = ConfigMode.a();
        }
    }
}

