/*
 * Decompiled with CFR 0.152.
 */
package com.inet.persistence.file;

import com.inet.error.ErrorCode;
import com.inet.lib.io.FastBufferedInputStream;
import com.inet.lib.util.IOFunctions;
import com.inet.persistence.PersistenceEntry;
import com.inet.persistence.RandomAccessRead;
import com.inet.persistence.StorageEntry;
import com.inet.persistence.file.FileRandomAccessRead;
import com.inet.persistence.spi.PersistenceHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.AccessController;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.SuppressFBWarnings;

class b
extends PersistenceEntry {
    private final File a;
    private final File b;
    private final String c;
    private static final String DATA = "!data";

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="path is checked")
    b(File file, String string) {
        Objects.requireNonNull(file);
        this.a = file;
        this.c = PersistenceHelper.checkName(string);
        this.b = new File(file, this.c.substring(1));
    }

    @Override
    @Nonnull
    public String getPath() {
        return this.c;
    }

    @Nonnull
    public b a(@Nonnull String string) {
        String string2 = PersistenceHelper.resolve(this.c, string);
        return new b(this.a, string2);
    }

    public b a() {
        String string = PersistenceHelper.getParentPath(this.c);
        if (string == null) {
            return null;
        }
        return new b(this.a, string);
    }

    @Override
    public boolean exists() {
        return AccessController.doPrivileged(() -> this.b.exists());
    }

    @Override
    @Nonnull
    public @Nonnull List<@Nonnull PersistenceEntry> getChildren() {
        ArrayList<@Nonnull PersistenceEntry> arrayList = new ArrayList<PersistenceEntry>();
        File[] fileArray = this.b.listFiles();
        if (fileArray != null) {
            String string = this.getPath();
            for (File file : fileArray) {
                try {
                    String string2 = PersistenceHelper.resolve(string, file.getName());
                    arrayList.add(new b(this.a, string2));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return arrayList;
    }

    @Override
    @Nonnull
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Caller must check it")
    public Iterable<PersistenceEntry> search(@Nonnull String pattern) {
        String string = PersistenceHelper.searchPatternToRegex(new File(this.b, pattern).toString());
        final Pattern pattern2 = Pattern.compile(string);
        final int n2 = this.a.toString().length();
        return () -> new Iterator<PersistenceEntry>(){
            private ArrayDeque<ArrayDeque<File>> d = new ArrayDeque();
            private b e;
            {
                File[] fileArray = b.this.b.listFiles();
                if (fileArray != null) {
                    this.d.add(new ArrayDeque<File>(Arrays.asList(fileArray)));
                }
            }

            @Override
            public boolean hasNext() {
                if (this.e == null) {
                    while (true) {
                        String string;
                        ArrayDeque<File> arrayDeque;
                        if ((arrayDeque = this.d.peekLast()) == null) {
                            return false;
                        }
                        File file = arrayDeque.pollLast();
                        if (file == null) {
                            this.d.removeLast();
                            continue;
                        }
                        File[] fileArray = file.listFiles();
                        if (fileArray != null) {
                            this.d.add(new ArrayDeque<File>(Arrays.asList(fileArray)));
                        }
                        if (!pattern2.matcher((string = file.getAbsolutePath()).toString()).matches()) continue;
                        string = string.substring(n2);
                        try {
                            this.e = new b(b.this.a, string);
                        }
                        catch (Exception exception) {
                            continue;
                        }
                        break;
                    }
                }
                return this.e != null;
            }

            public PersistenceEntry a() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                b b2 = this.e;
                this.e = null;
                return b2;
            }

            @Override
            public /* synthetic */ Object next() {
                return this.a();
            }
        };
    }

    File b() {
        return this.b.isDirectory() ? new File(this.b, DATA) : this.b;
    }

    @Override
    public String getString() {
        try {
            return IOFunctions.readString(this.b(), StandardCharsets.UTF_8);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public byte[] getBytes() {
        try {
            return IOFunctions.readBytes(this.b());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public InputStream getInputStream() {
        try {
            return new FastBufferedInputStream(new FileInputStream(this.b()));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public RandomAccessRead getRandomAccessRead() {
        try {
            return new FileRandomAccessRead(this.b());
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    @Override
    public void setString(@Nonnull String value) {
        this.setBytes(value.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public void setBytes(byte @Nonnull [] value) {
        try (FileOutputStream fileOutputStream = this.c();){
            fileOutputStream.write(value);
        }
        catch (IOException iOException) {
            ErrorCode.throwAny(iOException);
        }
    }

    @Override
    public void setInputStream(@Nonnull InputStream value) {
        try (FileOutputStream fileOutputStream = this.c();){
            IOFunctions.copyData(value, fileOutputStream);
        }
        catch (IOException iOException) {
            ErrorCode.throwAny(iOException);
        }
    }

    @Nonnull
    public FileOutputStream c() {
        this.d();
        try {
            return new FileOutputStream(this.b);
        }
        catch (IOException iOException) {
            if (this.b.isDirectory()) {
                try {
                    File file = new File(this.b, DATA);
                    return new FileOutputStream(file);
                }
                catch (IOException iOException2) {
                    ErrorCode.throwAny(iOException);
                }
            }
            if (!this.b.getParentFile().isDirectory()) {
                this.d();
                if (this.b.getParentFile().isDirectory()) {
                    return this.c();
                }
            }
            throw (RuntimeException)ErrorCode.throwAny(iOException);
        }
    }

    private void d() {
        File file;
        File file2 = file = this.b.getParentFile();
        while (!file.isDirectory()) {
            if (file.isFile()) {
                File file3 = new File(file.getParentFile(), "!data_");
                file.renameTo(file3);
                file.mkdir();
                file3.renameTo(new File(file, DATA));
                break;
            }
            file = file.getParentFile();
        }
        if (file != file2) {
            file2.mkdirs();
        }
    }

    @Override
    public long size() {
        if (this.b.isDirectory()) {
            return new File(this.b, DATA).length();
        }
        return this.b.length();
    }

    @Override
    public void deleteTree() {
        if (IOFunctions.deleteDir(this.b)) {
            this.e();
        } else if (this.b.exists()) {
            try {
                IOFunctions.deleteDir(this.b.toPath());
            }
            catch (IOException iOException) {
                ErrorCode.throwAny(iOException);
            }
            if (this.b.exists()) {
                ErrorCode.throwAny(new IOException("Persistence entry was not deleted: " + this.getPath()));
            }
            this.e();
        }
    }

    @Override
    public void deleteValue() {
        if (this.b.isDirectory()) {
            File file = new File(this.b, DATA);
            file.delete();
        }
        if (this.b.delete()) {
            this.e();
        }
    }

    private void e() {
        b b2 = this;
        b b3;
        while ((b3 = b2.a()) != null) {
            if (!b3.b.delete()) {
                return;
            }
            b2 = b3;
        }
        return;
    }

    @Override
    public long lastModified() {
        return this.b.lastModified();
    }

    @Override
    public void moveTo(@Nonnull String newPath) throws IllegalStateException, IllegalArgumentException {
        if (this.c.length() <= 1) {
            throw new IllegalStateException("Persistence root can't moved");
        }
        if ((newPath = PersistenceHelper.checkName(PersistenceHelper.resolve(this.c, newPath))).length() <= 1) {
            throw new IllegalArgumentException("can not moved to the root");
        }
        b b2 = this.a(newPath);
        if (b2.exists()) {
            throw new IllegalStateException("target already exists");
        }
        if (newPath.startsWith(this.c + "/")) {
            throw new IllegalArgumentException("You can't move to a sub folder");
        }
        Path path = this.b.toPath();
        Path path2 = b2.b.toPath();
        try {
            b2.b.getParentFile().mkdirs();
            Files.move(path, path2, new CopyOption[0]);
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    @Override
    @Nonnull
    public /* synthetic */ OutputStream getOutputStream() {
        return this.c();
    }

    @Override
    public /* synthetic */ PersistenceEntry getParent() {
        return this.a();
    }

    @Override
    @Nonnull
    public /* synthetic */ PersistenceEntry resolve(@Nonnull String string) throws NullPointerException, IllegalArgumentException {
        return this.a(string);
    }

    @Override
    public /* synthetic */ StorageEntry getParent() {
        return this.a();
    }
}

