/*
 * Decompiled with CFR 0.152.
 */
package com.inet.persistence;

import com.inet.annotations.InternalApi;
import com.inet.persistence.file.FileRandomAccessRead;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

@InternalApi
public abstract class RandomAccessRead
implements Closeable {
    public abstract long length() throws IOException;

    public int read(byte[] b2) throws IOException {
        return this.read(b2, 0, b2.length);
    }

    public int readCompletely(byte[] b2) throws IOException {
        return this.readCompletely(b2, 0, b2.length);
    }

    public abstract int read(byte[] var1, int var2, int var3) throws IOException;

    public int readCompletely(byte[] b2, int off, int len) throws IOException {
        int n2;
        int n3;
        for (n2 = 0; n2 < len; n2 += n3) {
            n3 = this.read(b2, off + n2, len - n2);
            if (n3 >= 0) continue;
            return n2 == 0 ? -1 : n2;
        }
        return n2;
    }

    public char readChar() throws IOException {
        int n2;
        int n3 = this.read();
        if ((n3 | (n2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)((n3 << 8) + (n2 << 0));
    }

    public abstract int read() throws IOException;

    public abstract void seek(long var1) throws IOException;

    public static RandomAccessRead wrap(byte[] content) {
        return new a(content);
    }

    public static RandomAccessRead wrap(File file) {
        try {
            return new FileRandomAccessRead(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IllegalArgumentException(fileNotFoundException);
        }
    }

    private static class a
    extends RandomAccessRead {
        private byte[] a;
        private int b;

        public a(byte[] byArray) {
            this.a = byArray;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public long length() throws IOException {
            return this.a.length;
        }

        @Override
        public int read(byte[] b2, int off, int len) throws IOException {
            if (this.b >= this.a.length) {
                return -1;
            }
            len = Math.min(len, this.a.length - this.b);
            System.arraycopy(this.a, this.b, b2, off, len);
            this.b += len;
            return len;
        }

        @Override
        public int read() throws IOException {
            if (this.b >= this.a.length) {
                return -1;
            }
            return this.a[this.b++];
        }

        @Override
        public void seek(long pos) throws IOException {
            this.b = (int)pos;
        }
    }
}

