/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.util;

import com.inet.annotations.InternalApi;
import com.inet.error.ErrorCode;
import com.inet.lib.io.FastByteArrayInputStream;
import com.inet.lib.io.FastByteArrayOutputStream;
import com.inet.lib.json.Json;
import com.inet.logging.LogManager;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.SuppressFBWarnings;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

@InternalApi
public class PasswordHashing {
    private static final String DEFAULT_ALGORITHM = "PBKDF2WithHmacSHA256";

    public static String hash(char @Nonnull [] password) {
        Base64.Encoder encoder = Base64.getEncoder().withoutPadding();
        byte[] byArray = new byte[16];
        new SecureRandom().nextBytes(byArray);
        String string = DEFAULT_ALGORITHM;
        int n2 = 65536;
        int n3 = 128;
        try {
            PBEKeySpec pBEKeySpec = new PBEKeySpec(password, byArray, n2, n3);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(string);
            byte[] byArray2 = secretKeyFactory.generateSecret(pBEKeySpec).getEncoded();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("algo", string);
            hashMap.put("salt", encoder.encodeToString(byArray));
            hashMap.put("hash", encoder.encodeToString(byArray2));
            hashMap.put("count", n2);
            hashMap.put("size", n3);
            FastByteArrayOutputStream fastByteArrayOutputStream = new FastByteArrayOutputStream();
            new Json().toJson(hashMap, fastByteArrayOutputStream);
            return encoder.encodeToString(fastByteArrayOutputStream.toByteArray());
        }
        catch (Exception exception) {
            ErrorCode.throwAny(exception);
            return null;
        }
    }

    @SuppressFBWarnings(value={"WEAK_MESSAGE_DIGEST_MD5", "UNSAFE_HASH_EQUALS"}, justification="MD5 only used for decoding old data. The hash has ever the same length.")
    public static boolean isMatching(String token, char[] password) {
        if (token == null || password == null) {
            return false;
        }
        Base64.Decoder decoder = Base64.getDecoder();
        byte[] byArray = decoder.decode(token);
        if (byArray.length <= 0) {
            return false;
        }
        try {
            if (byArray[0] == 123 && byArray[byArray.length - 1] == 125) {
                HashMap hashMap = new Json().fromJson(new FastByteArrayInputStream(byArray), HashMap.class);
                String string = (String)hashMap.get("algo");
                byte[] byArray2 = decoder.decode((String)hashMap.get("salt"));
                byte[] byArray3 = decoder.decode((String)hashMap.get("hash"));
                int n2 = (Integer)hashMap.get("count");
                int n3 = (Integer)hashMap.get("size");
                PBEKeySpec pBEKeySpec = new PBEKeySpec(password, byArray2, n2, n3);
                SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(string);
                byte[] byArray4 = secretKeyFactory.generateSecret(pBEKeySpec).getEncoded();
                return Arrays.equals(byArray3, byArray4);
            }
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(new String(password).getBytes(StandardCharsets.UTF_8));
            return Arrays.equals(byArray, messageDigest.digest());
        }
        catch (Exception exception) {
            LogManager.getApplicationLogger().error(exception);
            return false;
        }
    }
}

