/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.json;

import com.inet.lib.io.UTF8StreamWriter;
import com.inet.lib.json.ClassWrapper;
import com.inet.lib.json.DeclaredField;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonException;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class c {
    static final int TOKEN_NULL = 33;
    static final int TOKEN_FALSE = 34;
    static final int TOKEN_TRUE = 35;
    static final int TOKEN_POS_INT = 36;
    static final int TOKEN_NEG_INT = 37;
    static final int TOKEN_FLOAT = 38;
    static final byte TOKEN_DOUBLE = 39;
    static final int TOKEN_START_ARRAY = 40;
    static final int TOKEN_START_OBJECT = 41;
    static final int TOKEN_START_MAP = 42;
    static final int TOKEN_END = 43;
    static final int TOKEN_STRING = 44;
    static final int TOKEN_BYTES = 45;
    static final int TOKEN_ARRAY_LENGTH = 46;
    static final int TOKEN_SMALL_STRING_PREFIX = 64;
    static final int TOKEN_SMALL_POS_INT_PREFIX = 128;
    static final int TOKEN_SMALL_NEG_INT_PREFIX = 160;
    private final OutputStream a;
    private final HashMap<String, Integer> b = new HashMap();

    c(@Nonnull OutputStream outputStream) throws IOException {
        this.a = outputStream;
        outputStream.write(66);
        outputStream.write(79);
        outputStream.write(78);
        outputStream.write(0);
    }

    void a(@Nullable Object object) throws IOException {
        if (object == null) {
            this.a.write(33);
        } else {
            ClassWrapper classWrapper = ClassWrapper.getWrapper(object.getClass(), null);
            int n2 = classWrapper.getJsonType();
            switch (n2) {
                case 8: {
                    this.a(((Date)object).getTime());
                    return;
                }
                case 9: {
                    this.a.write((Boolean)object != false ? 35 : 34);
                    return;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    this.a(((Number)object).longValue());
                    return;
                }
                case 16: {
                    this.a(((Character)object).charValue());
                    return;
                }
                case 14: {
                    this.a(((Float)object).floatValue());
                    return;
                }
                case 15: {
                    this.a((Double)object);
                    return;
                }
                case 2: {
                    this.a(object.toString());
                    return;
                }
                case 3: {
                    this.a((Collection)object);
                    break;
                }
                case 4: {
                    this.a((Map)object);
                    break;
                }
                case 5: {
                    this.b(object);
                    return;
                }
                case 17: {
                    this.a((byte[])object);
                    return;
                }
                case 6: {
                    this.a(((Enum)object).name());
                    return;
                }
                case 7: {
                    this.a(object, classWrapper);
                    return;
                }
                default: {
                    throw new JsonException("Unknown json type: " + n2);
                }
            }
        }
    }

    private void a(@Nonnull String string) throws IOException {
        int n2 = string.length();
        if (n2 <= 31) {
            this.a.write(64 + n2);
        } else {
            this.a.write(44);
            this.b(n2);
        }
        UTF8StreamWriter uTF8StreamWriter = new UTF8StreamWriter(this.a);
        uTF8StreamWriter.write(string);
        uTF8StreamWriter.flushSurrogate();
    }

    private void a(byte @Nonnull [] byArray) throws IOException {
        this.a.write(45);
        this.b(byArray.length);
        this.a.write(byArray);
    }

    private void b(@Nonnull Object object) throws IOException {
        Class<?> clazz = object.getClass().getComponentType();
        if (clazz != null && clazz.isPrimitive()) {
            ClassWrapper classWrapper = ClassWrapper.getWrapper(clazz, null);
            switch (classWrapper.getJsonType()) {
                case 9: {
                    this.a((boolean[])object);
                    return;
                }
                case 11: {
                    this.a((short[])object);
                    return;
                }
                case 12: {
                    this.a((int[])object);
                    return;
                }
                case 13: {
                    this.a((long[])object);
                    return;
                }
                case 14: {
                    this.a((float[])object);
                    return;
                }
                case 15: {
                    this.a((double[])object);
                    return;
                }
                case 16: {
                    this.a((char[])object);
                    return;
                }
            }
        }
        this.a((Object[])object);
    }

    private void a(boolean @Nonnull [] blArray) throws IOException {
        this.a.write(46);
        int n2 = blArray.length;
        this.b(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.a.write(blArray[i2] ? 35 : 34);
        }
    }

    private void a(short @Nonnull [] sArray) throws IOException {
        this.a.write(46);
        int n2 = sArray.length;
        this.b(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.a(sArray[i2]);
        }
    }

    private void a(int @Nonnull [] nArray) throws IOException {
        this.a.write(46);
        int n2 = nArray.length;
        this.b(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.a(nArray[i2]);
        }
    }

    private void a(long @Nonnull [] lArray) throws IOException {
        this.a.write(46);
        int n2 = lArray.length;
        this.b(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.a(lArray[i2]);
        }
    }

    private void a(float @Nonnull [] fArray) throws IOException {
        this.a.write(46);
        int n2 = fArray.length;
        this.b(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.a(fArray[i2]);
        }
    }

    private void a(double @Nonnull [] dArray) throws IOException {
        this.a.write(46);
        int n2 = dArray.length;
        this.b(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.a(dArray[i2]);
        }
    }

    private void a(char @Nonnull [] cArray) throws IOException {
        this.a.write(46);
        int n2 = cArray.length;
        this.b(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.a(Character.valueOf(cArray[i2]));
        }
    }

    private void a(Object @Nonnull [] objectArray) throws IOException {
        this.a.write(46);
        int n2 = objectArray.length;
        this.b(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.a(objectArray[i2]);
        }
    }

    private void a(@Nonnull Collection<?> collection) throws IOException {
        this.a.write(46);
        int n2 = collection.size();
        int n3 = 0;
        this.b(n2);
        for (Object obj : collection) {
            this.a(obj);
            ++n3;
        }
        if (n2 != n3) {
            throw new JsonException("Size of collection has changed on serializing from " + n2 + " to " + n3 + " of " + collection.getClass().getName());
        }
    }

    private void a(Map<?, ?> map) throws IOException {
        this.a.write(42);
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            this.a(entry.getKey());
            this.a(entry.getValue());
        }
        this.a.write(43);
    }

    private void a(@Nonnull Object object, @Nonnull ClassWrapper classWrapper) throws IOException {
        this.a.write(41);
        DeclaredField[] declaredFieldArray = classWrapper.getDeclaredFields();
        for (int i2 = 0; i2 < declaredFieldArray.length; ++i2) {
            Object object2;
            Object object3;
            try {
                DeclaredField declaredField = declaredFieldArray[i2];
                object3 = declaredField.getField();
                object2 = ((Field)object3).get(object);
                if (object2 == null && declaredField.isExcludeNull()) continue;
                String string = declaredField.getName();
                Integer n2 = this.b.get(string);
                if (n2 == null) {
                    this.a(string);
                    this.b.put(string, this.b.size());
                } else {
                    this.a(n2.intValue());
                }
                this.a(object2);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace(Json.getErrorStream());
                continue;
            }
            catch (StackOverflowError stackOverflowError) {
                object3 = new JsonException(String.valueOf(object));
                ((Throwable)object3).setStackTrace(new StackTraceElement[0]);
                stackOverflowError.addSuppressed((Throwable)object3);
                if (stackOverflowError.getSuppressed().length == 0) {
                    object2 = new StackOverflowError(stackOverflowError.getMessage());
                    ((Throwable)object2).addSuppressed((Throwable)object3);
                    if (((Throwable)object2).getSuppressed().length > 0) {
                        ((Throwable)object2).setStackTrace(stackOverflowError.getStackTrace());
                        throw object2;
                    }
                }
                throw stackOverflowError;
            }
        }
        this.a.write(43);
    }

    private void a(float f2) throws IOException {
        int n2 = (int)f2;
        if ((float)n2 == f2 && n2 < 0x200000 && n2 >= -2097152) {
            this.a(n2);
            return;
        }
        int n3 = Float.floatToIntBits(f2);
        this.a.write(38);
        this.a.write(n3 >> 24);
        this.a.write(n3 >> 16);
        this.a.write(n3 >> 8);
        this.a.write(n3);
    }

    private void a(double d2) throws IOException {
        long l2 = (long)d2;
        if ((double)l2 == d2 && l2 < 0x200000L && l2 >= -2097152L) {
            this.a(l2);
            return;
        }
        long l3 = Double.doubleToLongBits(d2);
        this.a.write(39);
        this.a.write((int)(l3 >> 56));
        this.a.write((int)(l3 >> 48));
        this.a.write((int)(l3 >> 40));
        this.a.write((int)(l3 >> 32));
        this.a.write((int)(l3 >> 24));
        this.a.write((int)(l3 >> 16));
        this.a.write((int)(l3 >> 8));
        this.a.write((int)l3);
    }

    private void a(long l2) throws IOException {
        if (l2 >= 0L) {
            if (l2 <= 31L) {
                this.a.write(128 + (int)l2);
                return;
            }
            this.a.write(36);
        } else {
            if ((l2 ^= 0xFFFFFFFFFFFFFFFFL) <= 31L) {
                this.a.write(160 + (int)l2);
                return;
            }
            this.a.write(37);
        }
        this.b(l2);
    }

    private void b(long l2) throws IOException {
        this.c(l2 >>> 7);
        this.a.write((byte)(128L + (l2 & 0x7FL)));
    }

    private void c(long l2) throws IOException {
        if (l2 == 0L) {
            return;
        }
        this.c(l2 >>> 7);
        this.a.write((byte)(l2 & 0x7FL));
    }
}

