/*
 * Decompiled with CFR 0.152.
 */
package com.inet.graphics.buffered;

import com.inet.annotations.InternalApi;
import com.inet.graphics.GraphicsBase;
import com.inet.graphics.buffered.BGClip;
import com.inet.graphics.buffered.BufferedGraphicsCommand;
import com.inet.graphics.buffered.BufferedGraphicsProvider;
import com.inet.graphics.buffered.FontMetricsProvider;
import com.inet.graphics.buffered.GraphicsFilter;
import com.inet.graphics.buffered.GraphicsObjectID;
import com.inet.logging.LogManager;
import com.inet.shared.utils.BlendComposite;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.PrintStream;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@InternalApi
public class BufferedGraphics2D
extends GraphicsBase
implements Externalizable {
    private BufferedGraphicsProvider a;
    private int b = 0;
    private final FontMetricsProvider c;
    private Integer d = null;
    private AffineTransform e = null;
    private boolean f = false;

    public BufferedGraphics2D() {
        this((FontMetricsProvider)null);
    }

    public BufferedGraphics2D(FontMetricsProvider capabilities) {
        this.a = new BufferedGraphicsProvider();
        this.c = capabilities;
    }

    public BufferedGraphics2D(BufferedGraphicsProvider graphicsProvider) {
        this.c = new FontMetricsProvider(){

            @Override
            public FontMetrics getFontMetrics(Font font) {
                return Toolkit.getDefaultToolkit().getFontMetrics(font);
            }
        };
        this.a = graphicsProvider;
    }

    public BufferedGraphicsProvider getGraphicsProvider() {
        return this.a;
    }

    @Override
    public void addRenderingHints(Map hints) {
        if (hints == null) {
            throw new IllegalArgumentException("Map ist null");
        }
        this.a.add(this.getId(), BufferedGraphicsCommand.MethodNames.ADD_RENDERING_HINTS, hints);
    }

    @Override
    public void clip(Shape s) {
        if (!this.f) {
            super.clip(s);
        }
        this.d = null;
        this.e = null;
        if (s == null) {
            throw new IllegalArgumentException("Shape ist null");
        }
        this.a.add(this.getId(), BufferedGraphicsCommand.MethodNames.CLIP, this.a(s));
    }

    @Override
    public void draw(Shape s) {
        if (s == null) {
            throw new IllegalArgumentException("Shape ist null");
        }
        this.a.add(this.getId(), BufferedGraphicsCommand.MethodNames.DRAW, this.a(s));
    }

    @Override
    public void drawGlyphVector(GlyphVector g2, float x, float y) {
        if (g2 == null) {
            throw new IllegalArgumentException("GlyphVector ist null");
        }
        this.fill(g2.getOutline(x, y));
    }

    @Override
    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        if (xform == null) {
            throw new IllegalArgumentException("AffineTransform ist null");
        }
        this.a.add(this.getId(), BufferedGraphicsCommand.MethodNames.DRAW_IMAGE_WITH_XFORM, img, xform, obs);
        return true;
    }

    @Override
    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        this.a.add(this.getId(), BufferedGraphicsCommand.MethodNames.DRAW_IMAGE_WITH_BUFF_IMG, img, op, x, y);
    }

    @Override
    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        if (xform == null) {
            throw new IllegalArgumentException("AffineTransform ist null");
        }
        this.a.add(this.getId(), BufferedGraphicsCommand.MethodNames.DRAW_RENDERABLE_IMAGE, img, xform);
    }

    @Override
    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        if (xform == null) {
            throw new IllegalArgumentException("AffineTransform ist null");
        }
        this.a.add(this.getId(), BufferedGraphicsCommand.MethodNames.DRAW_RENDERED_IMAGE, img, xform);
    }

    @Override
    public void drawString(String str, int x, int y) {
        if (str == null) {
            throw new IllegalArgumentException("String ist null");
        }
        this.a.add(this.getId(), BufferedGraphicsCommand.MethodNames.DRAW_STRING_WITH_INT, str, x, y);
    }

    @Override
    public void drawString(String s, float x, float y) {
        if (s == null) {
            throw new IllegalArgumentException("String ist null");
        }
        this.a.add(this.getId(), BufferedGraphicsCommand.MethodNames.DRAW_STRING_WITH_FLOAT, s, Float.valueOf(x), Float.valueOf(y));
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        BufferedGraphics2D.notSupported("drawString with AttributedCharacterIterator");
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        BufferedGraphics2D.notSupported("drawString with AttributedCharacterIterator");
    }

    @Override
    public void fill(Shape s) {
        if (s == null) {
            throw new IllegalArgumentException("Shape ist null");
        }
        this.a.add(this.getId(), BufferedGraphicsCommand.MethodNames.FILL, this.a(s));
    }

    @Override
    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        if (rect == null || s == null) {
            throw new IllegalArgumentException("null");
        }
        this.a.add(this.getId(), BufferedGraphicsCommand.MethodNames.HIT, rect, s, onStroke);
        return true;
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        this.a.add(this.getId(), BufferedGraphicsCommand.MethodNames.SET_BACKGROUND, color);
    }

    @Override
    public void setComposite(Composite comp) {
        if (comp instanceof AlphaComposite || comp instanceof BlendComposite) {
            if (comp != this.getComposite() || this.f) {
                super.setComposite(comp);
                this.a.add(this.getId(), BufferedGraphicsCommand.MethodNames.SET_COMPOSITE, comp);
            }
        } else {
            BufferedGraphics2D.notSupported("Composite class:" + comp.getClass().getName());
        }
    }

    @Override
    public void setPaint(Paint paint) {
        if (paint != null) {
            if (this.f) {
                this.a(paint);
                return;
            }
            if (Objects.equals(paint, this.getPaint())) {
                return;
            }
        } else {
            throw new IllegalArgumentException("Paint ist null");
        }
        super.setPaint(paint);
        this.a(paint);
    }

    private void a(Paint paint) {
        if (paint instanceof GradientPaint) {
            this.a.add(this.getId(), BufferedGraphicsCommand.MethodNames.SET_GRADIENT_PAINT, paint);
        } else if (paint instanceof RadialGradientPaint) {
            this.a.add(this.getId(), BufferedGraphicsCommand.MethodNames.SET_RADIAL_GRADIENT_PAINT, paint);
        } else if (paint instanceof LinearGradientPaint) {
            this.a.add(this.getId(), BufferedGraphicsCommand.MethodNames.SET_LINEAR_GRADIENT_PAINT, paint);
        } else if (paint instanceof TexturePaint) {
            this.a.add(this.getId(), BufferedGraphicsCommand.MethodNames.SET_TEXTURE_PAINT, paint);
        } else if (paint instanceof Color) {
            this.a.add(this.getId(), BufferedGraphicsCommand.MethodNames.SETPAINT, paint);
        } else if (paint instanceof Serializable) {
            this.a.add(this.getId(), BufferedGraphicsCommand.MethodNames.SET_PAINT_CUSTOM, paint);
        } else if (paint.getClass().getName().equalsIgnoreCase("com.github.weisj.jsvg.renderer.jdk.SVGRadialGradientPaint")) {
            this.a.add(this.getId(), BufferedGraphicsCommand.MethodNames.SET_RADIAL_GRADIENT_PAINT, paint);
        } else {
            BufferedGraphics2D.notSupported("setPaint(" + paint.getClass().getName() + ")");
        }
    }

    @Override
    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        if (hintKey != null && hintKey.isCompatibleValue(hintValue)) {
            if (!this.f) {
                if (this.getRenderingHint(hintKey) == hintValue) {
                    return;
                }
                super.setRenderingHint(hintKey, hintValue);
            }
        } else {
            throw new IllegalArgumentException("Value is not compatible, Key: " + String.valueOf(hintKey) + " Value: " + String.valueOf(hintValue));
        }
        this.a.add(this.getId(), BufferedGraphicsCommand.MethodNames.SET_RENDERING_HINT, hintKey, hintValue);
    }

    @Override
    public void setRenderingHints(Map<?, ?> hints) {
        super.setRenderingHints(hints);
        if (hints == null) {
            throw new IllegalArgumentException("Map ist null");
        }
        this.a.add(this.getId(), BufferedGraphicsCommand.MethodNames.SET_RENDERING_HINTS, hints);
    }

    @Override
    public void setStroke(Stroke s) {
        if (s != null) {
            super.setStroke(s);
            if (s instanceof BasicStroke) {
                this.a.add(this.getId(), BufferedGraphicsCommand.MethodNames.SET_STROKE, s);
            } else {
                BufferedGraphics2D.notSupported("setStroke(" + s.getClass().getName() + ")");
            }
        } else {
            throw new IllegalArgumentException("Stroke ist null");
        }
    }

    @Override
    public void setTransformImpl(AffineTransform tx) {
        GraphicsObjectID graphicsObjectID;
        if (tx != null) {
            List<BufferedGraphicsCommand> list;
            graphicsObjectID = this.a.getFromTransformMap(tx);
            if (graphicsObjectID == null) {
                throw new IllegalArgumentException("Only transformation matrices are accepted which were returned by getTransform()");
            }
            if (!this.f && !(list = this.a.getList()).isEmpty()) {
                block3: for (int i2 = list.size() - 1; i2 >= 0; --i2) {
                    BufferedGraphicsCommand.MethodNames methodNames = list.get(i2).getName();
                    switch (methodNames) {
                        case TRANSFORM: 
                        case SET_TRANSFORM: 
                        case SCALE: 
                        case SHEAR: 
                        case TRANSLATE_WITH_DOUBLE: 
                        case TRANSLATE_WITH_INT: {
                            list.remove(i2);
                            continue block3;
                        }
                        default: {
                            break block3;
                        }
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("AffineTransform ist null");
        }
        graphicsObjectID.a();
        this.a.add(this.getId(), BufferedGraphicsCommand.MethodNames.SET_TRANSFORM, graphicsObjectID);
    }

    @Override
    public AffineTransform getTransform() {
        AffineTransform affineTransform = super.getTransform();
        GraphicsObjectID graphicsObjectID = this.a.getFromTransformMap(affineTransform);
        if (graphicsObjectID != null) {
            return affineTransform;
        }
        graphicsObjectID = this.a.addToTransformMap(affineTransform);
        this.a.add(this.getId(), BufferedGraphicsCommand.MethodNames.GET_TRANSFORM, graphicsObjectID);
        return new AffineTransform(affineTransform);
    }

    @Override
    public void transformImpl(AffineTransform Tx) {
        if (Tx != null) {
            if (Tx.isIdentity()) {
                return;
            }
        } else {
            throw new IllegalArgumentException("AffineTransform ist null");
        }
        Tx = (AffineTransform)Tx.clone();
        this.a.add(this.getId(), BufferedGraphicsCommand.MethodNames.TRANSFORM, Tx);
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        this.a.add(this.getId(), BufferedGraphicsCommand.MethodNames.CLEAR_RECT, x, y, width, height);
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
        super.clipRect(x, y, width, height);
        this.d = null;
        this.e = null;
        this.a.add(this.getId(), BufferedGraphicsCommand.MethodNames.CLIP_RECT, x, y, width, height);
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        this.a.add(this.getId(), BufferedGraphicsCommand.MethodNames.COPY_AREA, x, y, width, height, dx, dy);
    }

    @Override
    public Graphics create() {
        try {
            this.d = null;
            this.e = null;
            BufferedGraphics2D bufferedGraphics2D = (BufferedGraphics2D)this.clone();
            bufferedGraphics2D.a(this.a.getNextGraphicsId());
            this.a.add(this.getId(), BufferedGraphicsCommand.MethodNames.CREATE, new Object[0]);
            return bufferedGraphics2D;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    @Override
    public void dispose() {
        this.a.add(this.getId(), BufferedGraphicsCommand.MethodNames.DISPOSE, new Object[0]);
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.a.add(this.getId(), BufferedGraphicsCommand.MethodNames.DRAW_ARC, x, y, width, height, startAngle, arcAngle);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        this.a.add(this.getId(), BufferedGraphicsCommand.MethodNames.DRAW_IMAGE_WITH_OBS, img, x, y, observer);
        return true;
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        if (bgcolor == null) {
            throw new IllegalArgumentException("Color ist null");
        }
        this.a.add(this.getId(), BufferedGraphicsCommand.MethodNames.DRAW_IMAGE_WITH_BG, img, x, y, bgcolor, observer);
        return true;
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        this.a.add(this.getId(), BufferedGraphicsCommand.MethodNames.DRAW_IMAGE_WITH_SIZE, img, x, y, width, height, observer);
        return true;
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        if (bgcolor == null) {
            throw new IllegalArgumentException("Color ist null");
        }
        this.a.add(this.getId(), BufferedGraphicsCommand.MethodNames.DRAW_IMAGE_WITH_SIZE_AND_BG, img, x, y, width, height, bgcolor, observer);
        return true;
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        this.a.add(this.getId(), BufferedGraphicsCommand.MethodNames.DRAW_IMAGE_WITH_CORNER, img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
        return true;
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        if (bgcolor == null) {
            throw new IllegalArgumentException("Color ist null");
        }
        this.a.add(this.getId(), BufferedGraphicsCommand.MethodNames.DRAW_IMAGE_WITH_CORNER_AND_BG, img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, bgcolor, observer);
        return true;
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.a.add(this.getId(), BufferedGraphicsCommand.MethodNames.DRAW_LINE, x1, y1, x2, y2);
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        this.a.add(this.getId(), BufferedGraphicsCommand.MethodNames.DRAW_OVAL, x, y, width, height);
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.a.add(this.getId(), BufferedGraphicsCommand.MethodNames.DRAW_POLYGON, xPoints, yPoints, nPoints);
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        this.a.add(this.getId(), BufferedGraphicsCommand.MethodNames.DRAW_POLYLINE, xPoints, yPoints, nPoints);
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.a.add(this.getId(), BufferedGraphicsCommand.MethodNames.DRAW_ROUND_RECT, x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.a.add(this.getId(), BufferedGraphicsCommand.MethodNames.FILL_ARC, x, y, width, height, startAngle, arcAngle);
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        this.a.add(this.getId(), BufferedGraphicsCommand.MethodNames.FILL_OVAL, x, y, width, height);
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.a.add(this.getId(), BufferedGraphicsCommand.MethodNames.FILL_POLYGON, xPoints, yPoints, nPoints);
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        this.a.add(this.getId(), BufferedGraphicsCommand.MethodNames.FILL_RECT, x, y, width, height);
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.a.add(this.getId(), BufferedGraphicsCommand.MethodNames.FILL_ROUND_RECT, x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public BGClip getClip() {
        if (this.f) {
            throw new IllegalStateException("The method getClip() must only be used while drawing to a BufferedGrephics");
        }
        if (this.d != null && Objects.equals(this.getInternalTransform(), this.e) && this.a.hasClipInMap(this.d)) {
            BGClip bGClip = this.a.getClipFromMap(this.d);
            if (bGClip instanceof BGClip) {
                return bGClip;
            }
            return new BGClip(bGClip, this.d);
        }
        Shape shape = super.getClip();
        if (shape instanceof BGClip) {
            return (BGClip)shape;
        }
        this.d = this.a.addToClipMap(shape);
        this.e = this.getTransform();
        this.a.add(this.getId(), BufferedGraphicsCommand.MethodNames.GET_CLIP, this.d);
        return new BGClip(shape, this.d);
    }

    @Override
    public void setClip(Shape clip) {
        if (this.f) {
            Integer n2 = null;
            if (clip instanceof BGClip) {
                n2 = ((BGClip)clip).getId();
                this.a.add(this.getId(), BufferedGraphicsCommand.MethodNames.SET_CLIP_WITH_SHAPE, Boolean.TRUE, n2);
            } else {
                this.a.add(this.getId(), BufferedGraphicsCommand.MethodNames.SET_CLIP_WITH_SHAPE, Boolean.FALSE, this.a(clip));
            }
            return;
        }
        if (clip instanceof BGClip) {
            Integer n3 = ((BGClip)clip).getId();
            if (Objects.equals(n3, this.d) && Objects.equals(this.getInternalTransform(), this.e)) {
                return;
            }
            if (((BGClip)clip).isNullShape()) {
                clip = null;
            }
            this.e = this.getTransform();
            this.d = n3;
        } else {
            this.d = null;
        }
        super.setClip(clip);
        if (this.d != null) {
            this.a.add(this.getId(), BufferedGraphicsCommand.MethodNames.SET_CLIP_WITH_SHAPE, Boolean.TRUE, this.d);
        } else {
            this.a.add(this.getId(), BufferedGraphicsCommand.MethodNames.SET_CLIP_WITH_SHAPE, Boolean.FALSE, this.a(clip));
        }
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        super.setClip(x, y, width, height);
        this.d = null;
        this.e = null;
        this.a.add(this.getId(), BufferedGraphicsCommand.MethodNames.SET_CLIP, x, y, width, height);
    }

    @Override
    public void setColor(Color c2) {
        super.setColor(c2);
        this.a.add(this.getId(), BufferedGraphicsCommand.MethodNames.SET_COLOR, c2);
    }

    @Override
    public void setFont(Font font) {
        if (font != null) {
            if (Objects.equals(font, this.getFont())) {
                return;
            }
        } else {
            throw new IllegalArgumentException("Font ist null");
        }
        super.setFont(font);
        this.a.add(this.getId(), BufferedGraphicsCommand.MethodNames.SET_FONT, font);
    }

    @Override
    public void setPaintMode() {
        this.a.add(this.getId(), BufferedGraphicsCommand.MethodNames.SET_PAINT_MODE, new Object[0]);
    }

    @Override
    public void setXORMode(Color c1) {
        if (c1 == null) {
            throw new IllegalArgumentException("Color ist null");
        }
        this.a.add(this.getId(), BufferedGraphicsCommand.MethodNames.SET_XOR_MODE, c1);
    }

    @Override
    public void setInitialInformation(Rectangle2D imgBound, AffineTransform initialTransformation) {
        if (imgBound == null || initialTransformation == null) {
            throw new IllegalArgumentException("imgBound is null or initialTransformation is null");
        }
        this.a.add(this.getId(), BufferedGraphicsCommand.MethodNames.INITIALIZE, imgBound, initialTransformation);
    }

    @Override
    public void addLayer(boolean knockout, boolean isolate, BlendComposite composite) {
        GraphicsObjectID graphicsObjectID;
        AffineTransform affineTransform;
        if (composite != null) {
            super.addLayer(knockout, isolate, composite);
            this.a.add(this.getId(), BufferedGraphicsCommand.MethodNames.ADDLAYER, knockout, isolate, composite);
            affineTransform = new AffineTransform();
            graphicsObjectID = this.a.getFromTransformMap(affineTransform);
            if (graphicsObjectID != null) {
                return;
            }
        } else {
            throw new IllegalArgumentException("composite is null");
        }
        graphicsObjectID = this.a.addToTransformMap(affineTransform);
        this.a.add(this.getId(), BufferedGraphicsCommand.MethodNames.GET_TRANSFORM, graphicsObjectID);
    }

    @Override
    public void paintLastLayer() throws IllegalStateException {
        super.paintLastLayer();
        this.a.add(this.getId(), BufferedGraphicsCommand.MethodNames.DRAWLAYER, new Object[0]);
    }

    public void drawTo(Graphics2D graphics) {
        this.drawTo(graphics, null);
    }

    public void drawTo(Graphics2D graphics, GraphicsFilter filter) {
        if (graphics == null) {
            throw new IllegalArgumentException("graphics == null");
        }
        if (this.b != 0) {
            throw new IllegalStateException();
        }
        this.a.drawTo(graphics, filter);
    }

    public void writeTo(DataOutput stream) throws IOException {
        if (this.b != 0) {
            throw new IllegalStateException();
        }
        this.a.writeTo(stream);
    }

    public void readFrom(DataInput stream) {
        this.a.readFrom(stream, this);
    }

    @Override
    public void writeExternal(ObjectOutput oos) throws IOException {
        this.writeTo(oos);
    }

    @Override
    public void readExternal(ObjectInput ois) throws IOException {
        try {
            this.readFrom(new DataInputStream((ObjectInputStream)ois));
        }
        catch (RuntimeException runtimeException) {
            LogManager.getApplicationLogger().error(runtimeException);
            throw runtimeException;
        }
    }

    private void a(int n2) {
        this.b = n2;
    }

    public int getId() {
        return this.b;
    }

    @Override
    public boolean isSupportLocalCoordinates() {
        return true;
    }

    @Override
    public FontMetrics getFontMetrics(Font f2) {
        FontMetrics fontMetrics = this.c.getFontMetrics(f2);
        if (fontMetrics != null) {
            return fontMetrics;
        }
        return super.getFontMetrics(f2);
    }

    private Shape a(Shape shape) {
        if (shape == null) {
            return null;
        }
        if (shape instanceof Line2D) {
            return (Line2D)((Line2D)shape).clone();
        }
        if (shape instanceof RectangularShape) {
            return (RectangularShape)((RectangularShape)shape).clone();
        }
        if (shape instanceof GeneralPath) {
            return (GeneralPath)((GeneralPath)shape).clone();
        }
        return new Path2D.Double(shape);
    }

    public void dump(PrintStream stream) {
        this.a.dump(stream);
    }

    void a(boolean bl) {
        this.f = bl;
    }
}

