/*
 * Decompiled with CFR 0.152.
 */
package com.inet.graphics;

import com.inet.annotations.InternalApi;
import java.awt.BasicStroke;

@InternalApi
public final class BasicStrokeStyle
extends Enum<BasicStrokeStyle> {
    public static final /* enum */ BasicStrokeStyle LINE_STYLE_NONE = new BasicStrokeStyle(0);
    public static final /* enum */ BasicStrokeStyle LINE_STYLE_SINGLE = new BasicStrokeStyle(1);
    public static final /* enum */ BasicStrokeStyle LINE_STYLE_DASHED = new BasicStrokeStyle(3);
    public static final /* enum */ BasicStrokeStyle LINE_STYLE_DOTTED = new BasicStrokeStyle(4);
    public static final /* enum */ BasicStrokeStyle LINE_STYLE_DOTTED_SQUARE = new BasicStrokeStyle(5);
    public static final /* enum */ BasicStrokeStyle LINE_STYLE_DASHEDPOINT = new BasicStrokeStyle(6);
    public static final /* enum */ BasicStrokeStyle LINE_STYLE_LONGDASHED = new BasicStrokeStyle(7);
    public static final /* enum */ BasicStrokeStyle LINE_STYLE_LONGDASHEDPOINT = new BasicStrokeStyle(8);
    public static final /* enum */ BasicStrokeStyle LINE_STYLE_LONGDASHEDPOINTPOINT = new BasicStrokeStyle(9);
    private byte a;
    private static final /* synthetic */ BasicStrokeStyle[] b;

    public static BasicStrokeStyle[] values() {
        return (BasicStrokeStyle[])b.clone();
    }

    public static BasicStrokeStyle valueOf(String name) {
        return Enum.valueOf(BasicStrokeStyle.class, name);
    }

    public byte getId() {
        return this.a;
    }

    private BasicStrokeStyle(byte style) {
        this.a = style;
    }

    public static BasicStroke getBasicStrokeFromStyle(BasicStrokeStyle strokeStyle) {
        return BasicStrokeStyle.getBasicStrokeFromStyle(strokeStyle, 1.0f);
    }

    public static BasicStroke getBasicStrokeFromStyle(BasicStrokeStyle strokeStyle, float width) {
        switch (strokeStyle) {
            case LINE_STYLE_NONE: {
                return null;
            }
            case LINE_STYLE_SINGLE: {
                return new BasicStroke(width, 0, 0);
            }
            case LINE_STYLE_DOTTED: {
                return new BasicStroke(width, 0, 1, 1.0f, new float[]{width * 1.0f, width * 1.0f}, 0.0f);
            }
            case LINE_STYLE_DOTTED_SQUARE: {
                return new BasicStroke(width, 0, 0, 1.0f, new float[]{width * 3.0f, width * 1.0f}, 0.0f);
            }
            case LINE_STYLE_DASHED: {
                return new BasicStroke(width, 0, 0, 1.0f, new float[]{width * 4.0f, width * 2.0f}, 0.0f);
            }
            case LINE_STYLE_DASHEDPOINT: {
                return new BasicStroke(width, 0, 0, 1.0f, new float[]{width * 4.0f, width * 2.0f, width * 1.0f, width * 2.0f}, 0.0f);
            }
            case LINE_STYLE_LONGDASHED: {
                return new BasicStroke(width, 0, 0, 1.0f, new float[]{width * 6.0f, width * 2.0f}, 0.0f);
            }
            case LINE_STYLE_LONGDASHEDPOINT: {
                return new BasicStroke(width, 0, 0, 1.0f, new float[]{width * 6.0f, width * 2.0f, width * 1.0f, width * 2.0f}, 0.0f);
            }
            case LINE_STYLE_LONGDASHEDPOINTPOINT: {
                return new BasicStroke(width, 0, 0, 1.0f, new float[]{width * 6.0f, width * 2.0f, width * 1.0f, width * 2.0f, width * 1.0f, width * 2.0f}, 0.0f);
            }
        }
        return new BasicStroke();
    }

    public static byte getLineStyleFromStroke(BasicStroke bs) {
        if (bs == null) {
            return LINE_STYLE_NONE.getId();
        }
        float[] fArray = bs.getDashArray();
        if (fArray == null || fArray.length <= 1) {
            return LINE_STYLE_SINGLE.getId();
        }
        if (fArray.length == 2) {
            if (fArray[0] <= bs.getLineWidth() * 1.2f) {
                return LINE_STYLE_DOTTED.getId();
            }
            if (fArray[0] <= bs.getLineWidth() * 3.501f) {
                return LINE_STYLE_DOTTED_SQUARE.getId();
            }
            if (fArray[0] <= bs.getLineWidth() * 5.501f) {
                return LINE_STYLE_DASHED.getId();
            }
            return LINE_STYLE_LONGDASHED.getId();
        }
        if (fArray.length == 4) {
            return fArray[0] <= bs.getLineWidth() * 5.501f ? LINE_STYLE_DASHEDPOINT.getId() : LINE_STYLE_LONGDASHEDPOINT.getId();
        }
        if (fArray.length >= 6) {
            return LINE_STYLE_LONGDASHEDPOINTPOINT.getId();
        }
        return LINE_STYLE_SINGLE.getId();
    }

    private static /* synthetic */ BasicStrokeStyle[] a() {
        return new BasicStrokeStyle[]{LINE_STYLE_NONE, LINE_STYLE_SINGLE, LINE_STYLE_DASHED, LINE_STYLE_DOTTED, LINE_STYLE_DOTTED_SQUARE, LINE_STYLE_DASHEDPOINT, LINE_STYLE_LONGDASHED, LINE_STYLE_LONGDASHEDPOINT, LINE_STYLE_LONGDASHEDPOINTPOINT};
    }

    static {
        b = BasicStrokeStyle.a();
    }
}

