/*
 * Decompiled with CFR 0.152.
 */
package com.inet.globalbanner;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.globalbanner.GlobalBanner;
import com.inet.http.websocket.WebSocketConnectionListener;
import com.inet.http.websocket.WebSocketEventData;
import com.inet.http.websocket.WebSocketEventHandler;
import com.inet.http.websocket.WebsocketConnection;
import com.inet.id.GUID;
import com.inet.plugin.DynamicExtension;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class GlobalBannerManager {
    private static GlobalBannerManager a;
    private static DynamicExtension<GlobalBanner> b;

    private GlobalBannerManager() {
        WebSocketEventHandler.getInstance().addConnectionListener(new WebSocketConnectionListener(){

            @Override
            public void connectionOpened(String pollingID) {
                GlobalBannerManager.this.a(pollingID);
            }

            @Override
            public void connectionClosed(String pollingID) {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nonnull
    public static GlobalBannerManager getInstance() {
        GlobalBannerManager globalBannerManager = a;
        if (globalBannerManager != null) return globalBannerManager;
        Class<GlobalBannerManager> clazz = GlobalBannerManager.class;
        synchronized (GlobalBannerManager.class) {
            if (a != null) return a;
            a = new GlobalBannerManager();
            return a;
        }
    }

    public void registerGlobalBanner(@Nonnull GlobalBanner banner) {
        DynamicExtensionManager.getInstance().register(GlobalBanner.class, banner);
    }

    public void unregisterGlobalBanner(@Nonnull String id) {
        try {
            DynamicExtensionManager.getInstance().unregister(GlobalBanner.class, DynamicExtensionManager.getInstance().getSingleInstanceByName(GlobalBanner.class, id, false));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void a() {
        List<WebsocketConnection> list = WebSocketEventHandler.getInstance().getAllConnections();
        list.forEach(websocketConnection -> this.a(websocketConnection.getPollingID()));
    }

    private void a(String string) {
        WebsocketConnection websocketConnection = WebSocketEventHandler.getInstance().getConnection(string);
        if (websocketConnection != null) {
            WebSocketEventHandler.getInstance().sendEvent(string, () -> {
                GUID gUID = UserManager.getInstance().getCurrentUserAccountID();
                String string2 = string.startsWith("inet-") ? "" : "/" + string.substring(0, string.indexOf(45));
                return new WebSocketEventData("globalbanners", this.getBanners(gUID, string2));
            });
        }
    }

    public List<GlobalBannerDescription> getBanners(@Nullable GUID userId, @Nonnull String appPath) {
        ArrayList<GlobalBannerDescription> arrayList = new ArrayList<GlobalBannerDescription>();
        List<GlobalBanner> list = b.get();
        list.forEach(globalBanner -> {
            if (!globalBanner.isAvailableForUser(userId)) {
                return;
            }
            if (!globalBanner.isVisibleInApp(appPath)) {
                return;
            }
            arrayList.add(new GlobalBannerDescription(globalBanner.getExtensionName(), globalBanner.getBannerType(), globalBanner.getText(), globalBanner.getLink()));
        });
        arrayList.sort((globalBannerDescription, globalBannerDescription2) -> {
            int n2 = globalBannerDescription2.type.compareTo(globalBannerDescription.type);
            if (n2 != 0) {
                return n2;
            }
            n2 = globalBannerDescription.id.compareToIgnoreCase(globalBannerDescription2.id);
            if (n2 != 0) {
                return n2;
            }
            return globalBannerDescription.text.compareToIgnoreCase(globalBannerDescription2.text);
        });
        return arrayList;
    }

    static {
        b = new DynamicExtension<GlobalBanner>(GlobalBanner.class){

            @Override
            public void valuesChanged(@Nonnull List<GlobalBanner> values) {
                super.valuesChanged(values);
                GlobalBannerManager.getInstance().a();
            }
        };
    }

    @JsonData
    public static final class GlobalBannerDescription {
        private String id;
        private GlobalBanner.BannerType type;
        private String text;
        private String linkHref;
        private String linkText;

        public GlobalBannerDescription(String id, GlobalBanner.BannerType type, String text, GlobalBanner.BannerLink bannerLink) {
            this.id = id;
            this.type = type;
            this.text = text;
            this.linkHref = bannerLink == null ? null : bannerLink.getHref();
            this.linkText = bannerLink == null ? null : bannerLink.getLinkText();
        }
    }
}

