/*
 * Decompiled with CFR 0.152.
 */
package com.inet.file;

import com.inet.annotations.InternalApi;
import com.inet.classloader.I18nMessages;
import com.inet.file.CombinedFileDescription;
import com.inet.http.servlet.ClientLocale;
import com.inet.lib.io.FastByteArrayInputStream;
import com.inet.lib.io.FastByteArrayOutputStream;
import com.inet.lib.io.UTF8StreamWriter;
import com.inet.lib.json.Json;
import com.inet.lib.util.DebugUtils;
import com.inet.lib.util.IOFunctions;
import com.inet.logging.LogManager;
import com.inet.plugin.ServerPluginManager;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.SuppressFBWarnings;

@InternalApi
public class FileCombiner {
    private HashMap<String, CombinedFile> a = new HashMap();

    public FileCombiner(String appKey) {
        this(appKey, ServerPluginManager.getInstance().get(CombinedFileDescription.class));
    }

    public FileCombiner(String appKey, List<? extends CombinedFileDescription> combinedFileDescriptions) {
        Collections.sort(combinedFileDescriptions, new Comparator<CombinedFileDescription>(){

            public int a(CombinedFileDescription combinedFileDescription, CombinedFileDescription combinedFileDescription2) {
                return combinedFileDescription.getPrio() - combinedFileDescription2.getPrio();
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((CombinedFileDescription)object, (CombinedFileDescription)object2);
            }
        });
        for (CombinedFileDescription combinedFileDescription : combinedFileDescriptions) {
            if (!appKey.equals(combinedFileDescription.getAppKey())) continue;
            String string = combinedFileDescription.getResourceName();
            CombinedFile combinedFile = this.a.get(string);
            if (combinedFile != null) {
                Object object;
                Object object2;
                combinedFile.addAll(combinedFileDescription.getCombinedFile());
                ArrayList<I18nMessages> arrayList = combinedFileDescription.getCombinedFile().getMessages();
                if (arrayList != null) {
                    object2 = arrayList.iterator();
                    while (object2.hasNext()) {
                        object = (I18nMessages)object2.next();
                        combinedFile.addMessages((I18nMessages)object);
                    }
                }
                if ((object2 = combinedFileDescription.getCombinedFile().getRuntimeDatas()) == null) continue;
                object = ((ArrayList)object2).iterator();
                while (object.hasNext()) {
                    RuntimeData runtimeData = (RuntimeData)object.next();
                    combinedFile.addRuntimeData(runtimeData);
                }
                continue;
            }
            this.a.put(string, new CombinedFile(combinedFileDescription.getCombinedFile()));
        }
    }

    public CombinedFile getCombinedFile(String name) {
        return this.a.get(name);
    }

    @InternalApi
    public static class CombinedFile
    extends ArrayList<URL> {
        private long a = -1L;
        private String b;
        private ArrayList<I18nMessages> c;
        private ArrayList<RuntimeData> d;

        public CombinedFile(String mimetype, URL ... fileUrls) {
            this.b = mimetype;
            for (URL uRL : fileUrls) {
                this.add(uRL);
            }
        }

        private CombinedFile(@Nonnull CombinedFile orig) {
            super(orig);
            this.b = orig.b;
            if (orig.c != null) {
                this.c = new ArrayList<I18nMessages>(orig.c);
            }
            if (orig.d != null) {
                this.d = new ArrayList<RuntimeData>(orig.d);
            }
        }

        @Override
        @Deprecated
        public boolean add(URL url) {
            if (url == null) {
                throw new NullPointerException("URL is NULL");
            }
            return super.add(url);
        }

        public URL add(@Nonnull Class<?> clazz, @Nonnull String resource) {
            URL uRL = clazz.getResource(resource);
            if (uRL == null) {
                throw new NullPointerException("URL is NULL for resource: " + resource + " on class loader: " + String.valueOf(clazz.getClassLoader()));
            }
            super.add(uRL);
            return uRL;
        }

        @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="Caller must check that add only save URLs")
        public long getLastModified() {
            if (DebugUtils.DEBUG || this.a < 0L) {
                long l2 = 1L;
                for (URL uRL : this) {
                    try {
                        URLConnection uRLConnection = uRL.openConnection();
                        l2 = Math.max(l2, uRLConnection.getLastModified());
                        uRLConnection.getInputStream().close();
                    }
                    catch (IOException iOException) {
                        LogManager.getConfigLogger().error(iOException);
                    }
                }
                this.a = l2 < 0L ? System.currentTimeMillis() : l2;
            }
            return this.a;
        }

        public InputStream getStream(Locale locale) throws IOException {
            return new FastByteArrayInputStream(this.getData(locale));
        }

        public InputStream getStream() throws IOException {
            return new FastByteArrayInputStream(this.getData());
        }

        public void addMessages(I18nMessages msg) {
            if (this.c == null) {
                this.c = new ArrayList();
            }
            this.c.add(msg);
        }

        public ArrayList<I18nMessages> getMessages() {
            return this.c;
        }

        public void addRuntimeData(RuntimeData runtimeData) {
            if (this.d == null) {
                this.d = new ArrayList();
            }
            this.d.add(runtimeData);
        }

        public ArrayList<RuntimeData> getRuntimeDatas() {
            return this.d;
        }

        public byte[] getData() throws IOException {
            return this.getData(ClientLocale.getThreadLocale());
        }

        @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="Caller must check that add only save URLs")
        public byte[] getData(Locale locale) throws IOException {
            Object object;
            FastByteArrayOutputStream fastByteArrayOutputStream = new FastByteArrayOutputStream();
            ArrayList<RuntimeData> arrayList = this.d;
            if (arrayList != null) {
                for (RuntimeData hashMap : arrayList) {
                    object = hashMap.getDataStream();
                    try {
                        if (object == null) continue;
                        IOFunctions.copyData((InputStream)object, fastByteArrayOutputStream);
                        fastByteArrayOutputStream.write(10);
                    }
                    finally {
                        if (object != null) {
                            ((InputStream)object).close();
                        }
                    }
                }
            }
            for (URL uRL : this) {
                object = uRL.openStream();
                try {
                    IOFunctions.copyData((InputStream)object, fastByteArrayOutputStream);
                    fastByteArrayOutputStream.write(10);
                }
                finally {
                    if (object == null) continue;
                    ((InputStream)object).close();
                }
            }
            ArrayList<I18nMessages> arrayList2 = this.c;
            if (arrayList2 != null) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                for (I18nMessages i18nMessages : arrayList2) {
                    ResourceBundle resourceBundle = locale != null ? i18nMessages.getBundle(locale) : i18nMessages.getBundle();
                    Enumeration<String> enumeration = resourceBundle.getKeys();
                    while (enumeration.hasMoreElements()) {
                        String string = enumeration.nextElement();
                        hashMap.put(string, resourceBundle.getString(string));
                    }
                }
                object = new UTF8StreamWriter(fastByteArrayOutputStream);
                ((UTF8StreamWriter)object).append("addI18n(");
                new Json().toJson(hashMap, (Appendable)object);
                ((UTF8StreamWriter)object).append(");\n");
            }
            return fastByteArrayOutputStream.toByteArray();
        }

        public String getMimeType() {
            return this.b;
        }

        public boolean isCachingAllowed() {
            return true;
        }
    }

    @InternalApi
    public static interface RuntimeData {
        public InputStream getDataStream();
    }
}

