/*
 * Decompiled with CFR 0.152.
 */
package com.inet.config.structure.model;

import com.inet.annotations.JsonData;
import com.inet.config.structure.model.ConfigProperty;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
public class SliderConfigProperty
extends ConfigProperty {
    @Nonnull
    private SliderBound lowerBound;
    @Nonnull
    private SliderBound upperBound;
    private boolean showValue = true;
    @Nullable
    private String unit;

    public SliderConfigProperty(int sortid, @Nonnull String key, String label, String value, String tooltip, @Nonnull SliderBound lowerBound, @Nonnull SliderBound upperBound, boolean showValue) {
        super(sortid, key, "SimpleSlider", label, value, tooltip, null);
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.showValue = showValue;
    }

    public SliderConfigProperty(int sortid, @Nonnull String key, String label, String firstvalue, String secondvalue, String tooltip, @Nonnull SliderBound lowerBound, @Nonnull SliderBound upperBound, boolean showValue) {
        super(sortid, key, "RangeSlider", label, new RangeValue(firstvalue, secondvalue), tooltip, null);
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.showValue = showValue;
    }

    public SliderConfigProperty setUnit(String unit) {
        this.unit = unit;
        return this;
    }

    public SliderBound getLowerBound() {
        return this.lowerBound;
    }

    public SliderBound getUpperBound() {
        return this.upperBound;
    }

    public boolean isShowValue() {
        return this.showValue;
    }

    @JsonData
    public static class SliderBound {
        private final Number value;
        private final String label;

        public SliderBound(Number value, String label) {
            this.value = value;
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }

        public Number getValue() {
            return this.value;
        }

        public String toString() {
            return this.label;
        }
    }

    @JsonData
    public static class RangeValue {
        private final String firstValue;
        private final String secondValue;

        public RangeValue(String firstValue, String secondValue) {
            this.firstValue = firstValue;
            this.secondValue = secondValue;
        }

        public String getFirstValue() {
            return this.firstValue;
        }

        public String getSecondValue() {
            return this.secondValue;
        }
    }
}

