/*
 * Decompiled with CFR 0.152.
 */
package com.inet.config;

import com.inet.config.ConfigurationManager;
import com.inet.config.PreferencesProvider;
import com.inet.lib.util.PreferencesUtils;
import com.inet.logging.LogManager;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class PreferencesProviderImpl
implements PreferencesProvider {
    private final String a;

    public PreferencesProviderImpl(String prefNodePath) {
        this.a = prefNodePath;
    }

    @Override
    public Preferences getRootForScope(int scope) throws SecurityException {
        if (scope == 1) {
            if (this.isReadable(scope)) {
                try {
                    Preferences preferences = PreferencesUtils.systemRoot();
                    if (preferences.nodeExists(this.a)) {
                        return preferences.node(this.a);
                    }
                    if (this.isWriteable(scope)) {
                        LogManager.getConfigLogger().info("Preferences node created: " + this.a);
                        return preferences.node(this.a);
                    }
                }
                catch (BackingStoreException backingStoreException) {
                    LogManager.getConfigLogger().error(backingStoreException);
                }
            }
            throw new SecurityException("cannot read from system prefs");
        }
        if (scope != 2) {
            throw new IllegalArgumentException("trying to sync to non-persistent scope " + scope);
        }
        Preferences preferences = PreferencesUtils.userRoot().node(this.a);
        return preferences;
    }

    @Override
    public boolean isReadable(int scope) {
        return ConfigurationManager.isReadable(scope);
    }

    @Override
    public boolean isWriteable(int scope) {
        return ConfigurationManager.isWriteable(scope);
    }
}

