/*
 * Decompiled with CFR 0.152.
 */
package com.inet.classloader.translations;

import com.inet.classloader.translations.TranslationKey;
import java.util.Objects;
import javax.annotation.Nonnull;

public class BundleKey {
    @Nonnull
    public final String pluginId;
    @Nonnull
    public final String bundleName;
    @Nonnull
    public final String language;

    public BundleKey(@Nonnull String pluginId, @Nonnull String bundleName, @Nonnull String language) {
        this.pluginId = Objects.requireNonNull(pluginId);
        this.bundleName = Objects.requireNonNull(bundleName);
        this.language = Objects.requireNonNull(language);
    }

    public BundleKey(@Nonnull TranslationKey translationKey) {
        this(translationKey.pluginId, translationKey.bundleName, translationKey.language);
    }

    @Nonnull
    public String getResourceFilename() {
        String string = "en".equals(this.language) ? "" : "_" + this.language;
        return this.bundleName.replace('.', '/') + string + ".properties";
    }

    public int hashCode() {
        int n2 = this.bundleName.hashCode();
        n2 = 31 * n2 + this.language.hashCode();
        n2 = 31 * n2 + this.pluginId.hashCode();
        return n2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsOrSub((BundleKey)obj);
    }

    public boolean equalsOrSub(BundleKey other) {
        return Objects.equals(this.bundleName, other.bundleName) && Objects.equals(this.language, other.language) && Objects.equals(this.pluginId, other.pluginId);
    }
}

