/*
 * Decompiled with CFR 0.152.
 */
package com.inet.cache;

import com.inet.cache.CacheStrategy;
import com.inet.cache.InetSerializable;
import com.inet.cache.PersistenceKey;
import com.inet.cache.internal.AbstractMap;
import com.inet.cache.internal.ExternalDataWriterFactory;
import com.inet.cache.internal.FilePersistenceExternalDataWriterFactory;
import com.inet.cache.internal.PersistenceExternalDataWriterFactory;
import com.inet.persistence.Persistence;
import com.inet.persistence.file.FilePersistence;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;

public class PersistenceStoreMap
extends AbstractMap<PersistenceKey, InetSerializable> {
    public PersistenceStoreMap(String path) throws IOException {
        this(PersistenceStoreMap.a(path));
    }

    private PersistenceStoreMap(ExternalDataWriterFactory<PersistenceKey, InetSerializable> writerFactory) throws IOException {
        super(writerFactory, CacheStrategy.Normal);
    }

    private static ExternalDataWriterFactory<PersistenceKey, InetSerializable> a(String string) throws IOException {
        Persistence persistence = Persistence.getInstance();
        if (persistence instanceof FilePersistence) {
            Path path = ((FilePersistence)persistence).getPersistenceFolder();
            string = persistence.resolve(string).getPath().substring(1);
            File file = path.resolve(string).toFile();
            file.mkdirs();
            return new FilePersistenceExternalDataWriterFactory(file, "persistence");
        }
        return new PersistenceExternalDataWriterFactory(persistence.resolve(string));
    }

    @Override
    protected void finalize() throws Throwable {
        this.swapAll();
    }

    public void compact() {
        ExternalDataWriterFactory externalDataWriterFactory = this.getWriterFactory();
        if (externalDataWriterFactory instanceof FilePersistenceExternalDataWriterFactory) {
            ((FilePersistenceExternalDataWriterFactory)externalDataWriterFactory).compact();
        }
    }
}

