/*
 * Decompiled with CFR 0.152.
 */
package com.inet.cache;

import com.inet.annotations.InternalApi;
import com.inet.cache.MemoryListener;
import com.inet.cache.internal.HardDiskExternalDataWriterFactory;
import com.inet.cache.internal.MemoryObserver;
import com.inet.id.GUID;
import com.inet.notification.Notification;
import com.inet.notification.NotificationManager;
import com.inet.notification.PermissionNotificationGenerator;
import com.inet.plugin.ServerPluginManager;
import com.inet.shared.utils.Version;
import java.io.File;
import javax.annotation.Nullable;

@InternalApi
public class CacheManager {
    private static final int MB = 0x100000;
    private static final int GUID_SIZE = Version.getJavaVersion().getMajor() <= 8 ? 112 : 88;
    private static final GUID a = GUID.valueOf("ef156vkvawtxp2dflfvlspp1u");
    private static final int DISKSPACE_NOTIFICATION_LIMIT = Math.max(256, (int)(Runtime.getRuntime().maxMemory() / 0x100000L));

    private CacheManager() {
    }

    public static boolean checkMemory() {
        return MemoryObserver.checkMemory();
    }

    public static void checkHardDiskSpace(long sizeNeeded) throws IllegalStateException {
        CacheManager.checkHardDiskSpace(sizeNeeded, null);
    }

    public static void checkHardDiskSpace(long sizeNeeded, @Nullable File directory) throws IllegalStateException {
        if (directory == null) {
            directory = HardDiskExternalDataWriterFactory.getDefaultDir();
        }
        int n2 = (int)((sizeNeeded + 50000000L) / 1024L / 1024L);
        CacheManager.checkHardDiskSpace(directory, n2, "disk cache");
    }

    public static void checkHardDiskSpace(File directory, int neededMB, String component) throws IllegalStateException {
        long l2 = HardDiskExternalDataWriterFactory.freeSpace(directory);
        if (l2 <= 0L) {
            return;
        }
        final long l3 = (l2 + 0x100000L - 1L) / 0x100000L;
        if (ServerPluginManager.getInstance().getCorePluginId() != null) {
            NotificationManager notificationManager = NotificationManager.getInstance();
            if (l3 < (long)DISKSPACE_NOTIFICATION_LIMIT) {
                notificationManager.registerGenerator(new PermissionNotificationGenerator(){

                    @Override
                    public String getPeriodKey() {
                        return null;
                    }

                    @Override
                    public GUID getId() {
                        return a;
                    }

                    @Override
                    public Notification createNotification() {
                        return new Notification(NotificationManager.I18N.getMsg("msg.diskspace.title", new Object[0]), NotificationManager.I18N.getMsg("msg.diskspace", l3));
                    }
                });
            } else {
                notificationManager.unregisterGenerator(a);
                notificationManager.clearGeneratorState(a);
            }
        }
        if (l3 < (long)neededMB) {
            throw new IllegalStateException("Not enough free disk space. " + neededMB + " MB is minimum for " + component + ". Current free space is: " + l3 + " MB Location: " + String.valueOf(directory));
        }
    }

    public static void stopMemoryObserver() {
        MemoryObserver.stopMemoryObserver();
    }

    public static void addMemoryListener(MemoryListener listener) {
        MemoryObserver.addMemoryListener(listener);
    }

    public static long getMemorySize() {
        return MemoryObserver.getMemorySize() + (long)(GUID.getPoolCount() * GUID_SIZE);
    }
}

