/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.elements.presentation.table;

import java.awt.Graphics2D;
import java.util.List;
import java.util.Vector;
import net.sourceforge.jeuclid.MathBase;
import net.sourceforge.jeuclid.elements.AbstractInvisibleJEuclidElement;
import net.sourceforge.jeuclid.elements.JEuclidElement;
import net.sourceforge.jeuclid.elements.generic.MathImpl;
import net.sourceforge.jeuclid.elements.presentation.general.Mrow;
import net.sourceforge.jeuclid.elements.presentation.table.Malignmark;
import net.sourceforge.jeuclid.elements.presentation.table.Mtr;
import org.w3c.dom.mathml.MathMLAlignGroupElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Maligngroup
extends AbstractInvisibleJEuclidElement
implements MathMLAlignGroupElement {
    public static final String ELEMENT = "maligngroup";
    public static final String ATTR_GROUPALIGN = "groupalign";
    protected float width;
    private Malignmark mathAlignMark;

    public Maligngroup(MathBase base) {
        super(base);
    }

    public float getWidth() {
        return this.width;
    }

    @Override
    public float calculateWidth(Graphics2D g) {
        return this.width;
    }

    protected void setMark(Malignmark mark) {
        if (this.mathAlignMark == null) {
            this.mathAlignMark = mark;
        }
    }

    protected Malignmark getMark() {
        return this.mathAlignMark;
    }

    protected static float getElementsWholeWidth(Graphics2D g, List<JEuclidElement> elements) {
        float result = 0.0f;
        if (elements == null || elements.size() == 0) {
            return result;
        }
        for (int i = 0; i < elements.size(); ++i) {
            if (elements.get(i) == null) continue;
            result += elements.get(i).getWidth(g);
        }
        return result;
    }

    protected static List<JEuclidElement> getElementsOfAlignGroup(JEuclidElement alignGroupElement) {
        Vector<JEuclidElement> result = new Vector<JEuclidElement>();
        JEuclidElement parent = alignGroupElement.getParent();
        int index = parent.getIndexOfMathElement(alignGroupElement) + 1;
        JEuclidElement current = parent.getMathElement(index);
        boolean searching = true;
        while (true) {
            if (parent.getMathElementCount() == index) {
                if (parent instanceof Mtr || parent instanceof MathImpl) break;
                index = parent.getParent().getIndexOfMathElement(parent) + 1;
                parent = parent.getParent();
                current = parent.getMathElement(index);
                continue;
            }
            if (current instanceof Mrow) {
                parent = current;
                current = parent.getMathElement(0);
                index = 0;
                continue;
            }
            if (current instanceof Maligngroup) break;
            result.add(current);
            current = parent.getMathElement(index + 1);
            ++index;
        }
        return result;
    }

    @Override
    public String getTagName() {
        return ELEMENT;
    }

    @Override
    public String getGroupalign() {
        return this.getMathAttribute(ATTR_GROUPALIGN);
    }

    @Override
    public void setGroupalign(String groupalign) {
        this.setAttribute(ATTR_GROUPALIGN, groupalign);
    }
}

