/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.elements.presentation.general;

import java.util.List;
import net.sourceforge.jeuclid.MathBase;
import net.sourceforge.jeuclid.elements.JEuclidElement;
import net.sourceforge.jeuclid.elements.presentation.general.AbstractRoot;
import net.sourceforge.jeuclid.elements.presentation.general.Mrow;
import net.sourceforge.jeuclid.elements.presentation.token.Mspace;
import net.sourceforge.jeuclid.elements.support.ElementListSupport;
import org.w3c.dom.mathml.MathMLElement;
import org.w3c.dom.mathml.MathMLRadicalElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Msqrt
extends AbstractRoot
implements MathMLRadicalElement {
    public static final String ELEMENT = "msqrt";

    public Msqrt(MathBase base) {
        super(base, '\u221a');
    }

    @Override
    public String getTagName() {
        return ELEMENT;
    }

    @Override
    protected List<JEuclidElement> getContent() {
        return ElementListSupport.createListOfChildren(this);
    }

    @Override
    protected JEuclidElement getActualIndex() {
        return new Mspace(this.getMathBase());
    }

    @Override
    public MathMLElement getIndex() {
        return null;
    }

    @Override
    public MathMLElement getRadicand() {
        JEuclidElement retVal;
        if (this.getMathElementCount() == 1) {
            retVal = this.getMathElement(0);
        } else {
            retVal = new Mrow(this.getMathBase());
            retVal.setFakeParent(this);
            for (int i = 0; i < this.getMathElementCount(); ++i) {
                retVal.appendChild(this.getMathElement(i));
            }
        }
        return retVal;
    }

    @Override
    public void setIndex(MathMLElement index) {
    }

    @Override
    public void setRadicand(MathMLElement radicand) {
        while (this.getMathElementCount() > 0) {
            this.removeChild(this.getMathElement(0));
        }
        this.setMathElement(0, radicand);
    }
}

