/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.elements;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sourceforge.jeuclid.MathBase;
import net.sourceforge.jeuclid.ParameterKey;
import net.sourceforge.jeuclid.dom.AbstractChangeTrackingElement;
import net.sourceforge.jeuclid.dom.PartialTextImpl;
import net.sourceforge.jeuclid.elements.JEuclidElement;
import net.sourceforge.jeuclid.elements.JEuclidNode;
import net.sourceforge.jeuclid.elements.generic.MathImpl;
import net.sourceforge.jeuclid.elements.presentation.general.Mrow;
import net.sourceforge.jeuclid.elements.presentation.table.Mtable;
import net.sourceforge.jeuclid.elements.presentation.table.Mtr;
import net.sourceforge.jeuclid.elements.presentation.token.Mtext;
import net.sourceforge.jeuclid.elements.support.attributes.AttributeMap;
import net.sourceforge.jeuclid.elements.support.attributes.AttributesHelper;
import net.sourceforge.jeuclid.elements.support.attributes.MathVariant;
import net.sourceforge.jeuclid.elements.support.text.CharConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.mathml.MathMLElement;
import org.w3c.dom.mathml.MathMLMathElement;
import org.w3c.dom.mathml.MathMLNodeList;

public abstract class AbstractJEuclidElement
extends AbstractChangeTrackingElement
implements JEuclidElement {
    public static final String ATTR_MATHVARIANT = "mathvariant";
    public static final String ATTR_MATHCOLOR = "mathcolor";
    public static final String ATTR_MATHSIZE = "mathsize";
    public static final String ATTR_DEPRECATED_FONTFAMILY = "fontfamily";
    public static final String ATTR_DEPRECATED_FONTSTYLE = "fontstyle";
    public static final String ATTR_DEPRECATED_FONTWEIGHT = "fontweight";
    public static final String ATTR_DEPRECATED_FONTSIZE = "fontsize";
    public static final String ATTR_DEPRECATED_COLOR = "color";
    public static final String ATTR_DEPRECATED_BACKGROUND = "background";
    public static final String ATTR_CLASS = "class";
    public static final String ATTR_STYLE = "style";
    public static final String ATTR_ID = "id";
    public static final String ATTR_HREF = "xlink:href";
    public static final String ATTR_XREF = "xref";
    public static final String ATTR_MATHBACKGROUND = "mathbackground";
    public static final String ALIGN_TOP = "top";
    public static final String ALIGN_BOTTOM = "bottom";
    public static final String ALIGN_CENTER = "center";
    public static final String ALIGN_BASELINE = "baseline";
    public static final String ALIGN_AXIS = "axis";
    public static final String ALIGN_LEFT = "left";
    public static final String ALIGN_RIGHT = "right";
    public static final int TRIVIAL_SPACE_MAX = 32;
    public static final String URI = "http://www.w3.org/1998/Math/MathML";
    private static final float MIDDLE_SHIFT = 0.38f;
    private static final float DEFAULT_SCIPTSIZEMULTIPLIER = 0.71f;
    private static final Log LOGGER = LogFactory.getLog(AbstractJEuclidElement.class);
    private static final Set<String> DEPRECATED_ATTRIBUTES = new HashSet<String>();
    private MathBase mbase;
    private boolean calculatingSize;
    private float calculatedHeight = -1.0f;
    private float calculatedWidth = -1.0f;
    private float calculatedAscentHeight = -1.0f;
    private float calculatedDescentHeight = -1.0f;
    private float calculatedStretchHeight = -1.0f;
    private float calculatedStretchAscentHeight = -1.0f;
    private float calculatedStretchDescentHeight = -1.0f;
    private float lastPaintedX = -1.0f;
    private float lastPaintedY = -1.0f;
    private JEuclidElement fakeParent;
    private final Map<String, String> defaultMathAttributes = new HashMap<String, String>();
    private float mscriptsizemultiplier = 0.71f;
    private float globalLineCorrecter;

    public AbstractJEuclidElement(MathBase base) {
        DEPRECATED_ATTRIBUTES.add(ATTR_DEPRECATED_COLOR);
        DEPRECATED_ATTRIBUTES.add(ATTR_DEPRECATED_BACKGROUND);
        DEPRECATED_ATTRIBUTES.add(ATTR_DEPRECATED_FONTSIZE);
        DEPRECATED_ATTRIBUTES.add(ATTR_DEPRECATED_FONTWEIGHT);
        DEPRECATED_ATTRIBUTES.add(ATTR_DEPRECATED_FONTSTYLE);
        DEPRECATED_ATTRIBUTES.add(ATTR_DEPRECATED_FONTFAMILY);
        DEPRECATED_ATTRIBUTES.add("moveablelimits");
        this.setMathBase(base);
    }

    protected void recalculateSize() {
        this.calculatedHeight = -1.0f;
        this.calculatedAscentHeight = -1.0f;
        this.calculatedDescentHeight = -1.0f;
        this.calculatedStretchHeight = -1.0f;
        this.calculatedStretchAscentHeight = -1.0f;
        this.calculatedStretchDescentHeight = -1.0f;
        this.calculatedWidth = -1.0f;
    }

    protected void changeHook() {
        super.changeHook();
        this.recalculateSize();
    }

    public float getFontsizeInPoint() {
        float minSize;
        float scriptMultiplier = (float)Math.pow(this.getScriptSizeMultiplier(), this.getAbsoluteScriptLevel());
        float size = this.getMathsizeInPoint() * scriptMultiplier;
        if (size < (minSize = this.mbase.getFontSize() * 0.66f)) {
            size = minSize;
        }
        return size;
    }

    public Font getFont() {
        String content = this.getText();
        char aChar = content.length() > 0 ? (char)content.charAt(0) : (char)'A';
        return this.getMathvariantAsVariant().createFont(this.getFontsizeInPoint(), aChar, this.mbase);
    }

    public MathVariant getMathvariantAsVariant() {
        String mv = this.getMathvariant();
        MathVariant variant = null;
        if (mv != null) {
            variant = MathVariant.stringToMathVariant(mv);
        }
        if (variant == null) {
            JEuclidElement parent = this.getParent();
            variant = parent != null ? parent.getMathvariantAsVariant() : MathVariant.NORMAL;
        }
        return variant;
    }

    protected int getAbsoluteScriptLevel() {
        return this.getInheritedScriptlevel();
    }

    protected int getInheritedScriptlevel() {
        JEuclidElement parent = this.getParent();
        if (parent == null) {
            return 0;
        }
        return parent.getScriptlevelForChild(this);
    }

    public int getScriptlevelForChild(JEuclidElement child) {
        return this.getAbsoluteScriptLevel();
    }

    public final void addMathElement(MathMLElement child) {
        if (child != null) {
            this.appendChild(child);
            if (child instanceof AbstractJEuclidElement) {
                ((AbstractJEuclidElement)child).setMathBase(this.getMathBase());
            }
        }
    }

    public JEuclidElement getMathElement(int index) {
        if (index >= 0 && index < this.getMathElementCount()) {
            NodeList childList = this.getChildNodes();
            int elementIndex = 0;
            for (int i = 0; i < childList.getLength(); ++i) {
                Node child = childList.item(i);
                if (!(child instanceof JEuclidElement)) continue;
                if (elementIndex == index) {
                    return (JEuclidElement)child;
                }
                ++elementIndex;
            }
        }
        return null;
    }

    public void setMathElement(int index, MathMLElement newElement) {
        NodeList childList = this.getChildNodes();
        while (childList.getLength() < index) {
            this.addMathElement(new Mtext(this.mbase));
        }
        if (childList.getLength() == index) {
            this.addMathElement(newElement);
        } else {
            this.replaceChild(newElement, childList.item(index));
        }
    }

    public int getIndexOfMathElement(JEuclidElement element) {
        NodeList childList = this.getChildNodes();
        for (int i = 0; i < childList.getLength(); ++i) {
            if (!childList.item(i).equals(element)) continue;
            return i;
        }
        return -1;
    }

    public int getMathElementCount() {
        NodeList childList = this.getChildNodes();
        int elementIndex = 0;
        for (int i = 0; i < childList.getLength(); ++i) {
            Node child = childList.item(i);
            if (!(child instanceof JEuclidElement)) continue;
            ++elementIndex;
        }
        return elementIndex;
    }

    public void addText(String text) {
        Node textNode = this.getLastChild();
        if (!(textNode instanceof Text)) {
            textNode = new PartialTextImpl("");
            this.appendChild(textNode);
        }
        StringBuilder newText = new StringBuilder();
        if (this.getTextContent() != null) {
            newText.append(textNode.getTextContent());
        }
        if (text != null) {
            newText.append(text.trim());
        }
        for (int i = 0; i < newText.length() - 1; ++i) {
            if (newText.charAt(i) > ' ' || newText.charAt(i + 1) > ' ') continue;
            newText.deleteCharAt(i);
            --i;
        }
        String toSet = CharConverter.convertEarly(newText.toString());
        if (toSet.length() > 0) {
            textNode.setTextContent(toSet);
        } else {
            this.removeChild(textNode);
        }
    }

    public String getText() {
        String theText = this.getTextContent();
        if (theText == null) {
            return "";
        }
        return theText;
    }

    public void setMathBase(MathBase base) {
        this.mbase = base;
        NodeList childList = this.getChildNodes();
        for (int i = 0; i < childList.getLength(); ++i) {
            Node node = childList.item(i);
            if (!(node instanceof AbstractJEuclidElement)) continue;
            ((AbstractJEuclidElement)node).setMathBase(base);
        }
    }

    public MathBase getMathBase() {
        return this.mbase;
    }

    public void setFakeParent(JEuclidElement parent) {
        this.fakeParent = parent;
    }

    public JEuclidElement getParent() {
        Node parentNode = this.getParentNode();
        JEuclidElement theParent = null;
        if (parentNode instanceof JEuclidElement) {
            theParent = (JEuclidElement)this.getParentNode();
        }
        if (theParent == null) {
            return this.fakeParent;
        }
        return theParent;
    }

    public void setMathvariant(String mathvariant) {
        this.setAttribute(ATTR_MATHVARIANT, mathvariant);
    }

    public String getMathvariant() {
        return this.getMathAttribute(ATTR_MATHVARIANT);
    }

    public float getScriptSizeMultiplier() {
        return this.mscriptsizemultiplier;
    }

    public void setScriptSizeMultiplier(float scriptsizemultiplier) {
        this.mscriptsizemultiplier = scriptsizemultiplier;
    }

    public FontMetrics getFontMetrics(Graphics2D g) {
        return g.getFontMetrics(this.getFont());
    }

    public void setMathcolor(String mathcolor) {
        this.setAttribute(ATTR_MATHCOLOR, mathcolor);
    }

    public String getMathcolor() {
        String color = this.getMathAttribute(ATTR_MATHCOLOR);
        if (color == null) {
            color = this.getMathAttribute(ATTR_DEPRECATED_COLOR);
        }
        return color;
    }

    public String getMathsize() {
        String size = this.getMathAttribute(ATTR_MATHSIZE);
        if (size == null) {
            size = this.getMathAttribute(ATTR_DEPRECATED_FONTSIZE);
        }
        return size;
    }

    public void setMathsize(String mathsize) {
        this.setAttribute(ATTR_MATHSIZE, mathsize);
    }

    public float getMathsizeInPoint() {
        String msize = this.getMathsize();
        JEuclidNode relativeToElement = null;
        relativeToElement = this.getParent() != null ? this.getParent() : this.mbase.getRootElement();
        if (msize == null) {
            return relativeToElement.getMathsizeInPoint();
        }
        return AttributesHelper.convertSizeToPt(msize, relativeToElement, "pt");
    }

    protected void setDefaultMathAttribute(String key, String value) {
        this.defaultMathAttributes.put(key, value);
    }

    protected String getMathAttribute(String attrName) {
        String attrValue = this.getAttributeNS(URI, attrName);
        if (attrValue == null) {
            attrValue = this.getAttribute(attrName);
        }
        if (attrValue == null) {
            attrValue = this.defaultMathAttributes.get(attrName);
        }
        return attrValue;
    }

    public String getMathbackground() {
        String color = this.getMathAttribute(ATTR_MATHBACKGROUND);
        if (color == null) {
            color = this.getMathAttribute(ATTR_DEPRECATED_BACKGROUND);
        }
        return color;
    }

    public void setMathbackground(String mathbackground) {
        this.setAttribute(ATTR_MATHBACKGROUND, mathbackground);
    }

    public Color getForegroundColor() {
        String colorString = this.getMathcolor();
        Color theColor = colorString == null ? (this.getParent() != null ? this.getParent().getForegroundColor() : AttributesHelper.stringToColor(this.mbase.getParams().get((Object)ParameterKey.ForegroundColor), Color.BLACK)) : AttributesHelper.stringToColor(colorString, Color.BLACK);
        return theColor;
    }

    public Color getBackgroundColor() {
        String colorString = this.getMathbackground();
        Object theColor = colorString == null ? (this.getParent() != null ? null : AttributesHelper.stringToColor(this.mbase.getParams().get((Object)ParameterKey.BackgroundColor), null)) : AttributesHelper.stringToColor(colorString, null);
        return theColor;
    }

    public void debug(Graphics2D g, float posX, float posY) {
        g.setColor(Color.blue);
        g.draw(new Line2D.Float(posX, posY - this.getAscentHeight(g), posX + this.getWidth(g), posY - this.getAscentHeight(g)));
        g.draw(new Line2D.Float(posX + this.getWidth(g), posY - this.getAscentHeight(g), posX + this.getWidth(g), posY + this.getDescentHeight(g)));
        g.draw(new Line2D.Float(posX, posY + this.getDescentHeight(g), posX + this.getWidth(g), posY + this.getDescentHeight(g)));
        g.draw(new Line2D.Float(posX, posY - this.getAscentHeight(g), posX, posY + this.getDescentHeight(g)));
        g.setColor(Color.red);
        g.draw(new Line2D.Float(posX, posY, posX + this.getWidth(g), posY));
        g.setColor(Color.black);
    }

    public void setGlobalLineCorrector(float corrector) {
        if (this.getParent() == null) {
            return;
        }
        if (this instanceof Mtr || this instanceof Mrow && this.getParent() instanceof Mtable || this.getParent() instanceof MathImpl) {
            if (this.globalLineCorrecter < corrector) {
                this.globalLineCorrecter = corrector;
            }
        } else {
            this.getParent().setGlobalLineCorrector(corrector);
        }
    }

    public float getGlobalLineCorrector() {
        float retVal = this.getParent() == null ? 0.0f : (this instanceof Mtr || this instanceof Mrow && this.getParent() instanceof Mtable || this.getParent() instanceof MathImpl ? this.globalLineCorrecter : this.getParent().getGlobalLineCorrector());
        return retVal;
    }

    public float getWidth(Graphics2D g) {
        if (this.calculatedWidth < 0.0f) {
            this.calculatedWidth = this.calculateWidth(g);
        }
        return this.calculatedWidth;
    }

    public abstract float calculateWidth(Graphics2D var1);

    public float getHeight(Graphics2D g) {
        if (this.calculatingSize || this.getParent() != null && this.getParent().isCalculatingSize()) {
            if (this.calculatedStretchHeight < 0.0f) {
                this.calculatedStretchHeight = this.calculateHeight(g);
            }
            return this.calculatedStretchHeight;
        }
        if (this.calculatedHeight < 0.0f) {
            this.calculatedHeight = this.calculateHeight(g);
        }
        return this.calculatedHeight;
    }

    public float calculateHeight(Graphics2D g) {
        return this.getAscentHeight(g) + this.getDescentHeight(g);
    }

    public float getAscentHeight(Graphics2D g) {
        if (this.calculatingSize || this.getParent() != null && this.getParent().isCalculatingSize()) {
            if (this.calculatedStretchAscentHeight < 0.0f) {
                this.calculatedStretchAscentHeight = this.calculateAscentHeight(g);
            }
            return this.calculatedStretchAscentHeight;
        }
        if (this.calculatedAscentHeight < 0.0f) {
            this.calculatedAscentHeight = this.calculateAscentHeight(g);
        }
        return this.calculatedAscentHeight;
    }

    public abstract float calculateAscentHeight(Graphics2D var1);

    public float getDescentHeight(Graphics2D g) {
        if (this.calculatingSize || this.getParent() != null && this.getParent().isCalculatingSize()) {
            if (this.calculatedStretchDescentHeight < 0.0f) {
                this.calculatedStretchDescentHeight = this.calculateDescentHeight(g);
            }
            return this.calculatedStretchDescentHeight;
        }
        if (this.calculatedDescentHeight < 0.0f) {
            this.calculatedDescentHeight = this.calculateDescentHeight(g);
        }
        return this.calculatedDescentHeight;
    }

    public abstract float calculateDescentHeight(Graphics2D var1);

    public float getMiddleShift(Graphics2D g) {
        return (float)this.getFontMetrics(g).getAscent() * 0.38f;
    }

    public void setMathAttributes(AttributeMap attributes) {
        Map<String, String> attrsAsMap = attributes.getAsMap();
        for (Map.Entry<String, String> e : attrsAsMap.entrySet()) {
            String attrName = e.getKey();
            if (DEPRECATED_ATTRIBUTES.contains(attrName)) {
                LOGGER.warn((Object)("Deprecated attribute for " + this.getTagName() + ": " + attrName));
            }
            this.setAttribute(attrName, e.getValue());
        }
        this.recalculateSize();
    }

    public boolean isCalculatingSize() {
        return this.calculatingSize;
    }

    public void setCalculatingSize(boolean ncalculatingSize) {
        this.calculatingSize = ncalculatingSize;
    }

    public String getClassName() {
        return this.getAttribute(ATTR_CLASS);
    }

    public void setClassName(String className) {
        this.setAttribute(ATTR_CLASS, className);
    }

    public String getMathElementStyle() {
        return this.getAttribute(ATTR_STYLE);
    }

    public void setMathElementStyle(String mathElementStyle) {
        this.setAttribute(ATTR_STYLE, mathElementStyle);
    }

    public String getId() {
        return this.getAttribute(ATTR_ID);
    }

    public void setId(String id) {
        this.setAttribute(ATTR_ID, id);
    }

    public String getXref() {
        return this.getAttribute(ATTR_XREF);
    }

    public void setXref(String xref) {
        this.setAttribute(ATTR_XREF, xref);
    }

    public String getHref() {
        return this.getAttribute(ATTR_HREF);
    }

    public void setHref(String href) {
        this.setAttribute(ATTR_HREF, href);
    }

    public MathMLMathElement getOwnerMathElement() {
        for (JEuclidElement node = this.getParent(); node != null; node = node.getParent()) {
            if (!(node instanceof MathMLMathElement)) continue;
            return (MathMLMathElement)((Object)node);
        }
        return null;
    }

    public boolean isChildBlock(JEuclidElement child) {
        JEuclidElement parent = this.getParent();
        if (parent != null) {
            return parent.isChildBlock(this);
        }
        return true;
    }

    public boolean hasChildPrescripts(JEuclidElement child) {
        return false;
    }

    public boolean hasChildPostscripts(JEuclidElement child) {
        return false;
    }

    public void paint(Graphics2D g, float posX, float posY) {
        this.lastPaintedX = posX;
        this.lastPaintedY = posY;
        if (this.getBackgroundColor() != null) {
            g.setColor(this.getBackgroundColor());
            float ascent = (float)Math.ceil(this.getAscentHeight(g));
            float descent = (float)Math.ceil(this.getDescentHeight(g));
            g.fill(new Rectangle2D.Float(posX, posY - ascent, (float)Math.ceil(this.getWidth(g)), ascent + descent));
        }
        if (this.getMathBase().isDebug()) {
            this.debug(g, posX, posY);
        }
        g.setColor(this.getForegroundColor());
        g.setFont(this.getFont());
    }

    public float getPaintedPosX() {
        return this.lastPaintedX;
    }

    public float getPaintedPosY() {
        return this.lastPaintedY;
    }

    public MathMLNodeList getContents() {
        return (MathMLNodeList)this.getChildNodes();
    }

    public float getXCenter(Graphics2D g) {
        return this.getWidth(g) / 2.0f;
    }
}

