/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.dom;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sourceforge.jeuclid.dom.AbstractPartialNodeImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;

public abstract class AbstractPartialElementImpl
extends AbstractPartialNodeImpl
implements Element {
    private final Map<String, String> attributes = new HashMap<String, String>();

    public final String getAttribute(String name) {
        return this.attributes.get(name);
    }

    public final String getAttributeNS(String namespaceURI, String localName) {
        return this.attributes.get(localName);
    }

    public void setAttribute(String name, String value) {
        this.attributes.put(name, value);
    }

    public final Attr getAttributeNode(String name) {
        throw new UnsupportedOperationException("getAttributeNode");
    }

    public final Attr getAttributeNodeNS(String namespaceURI, String localName) {
        throw new UnsupportedOperationException("getAttributeNodeNS");
    }

    public final NodeList getElementsByTagName(String name) {
        throw new UnsupportedOperationException("getElementsByTagName");
    }

    public final NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        throw new UnsupportedOperationException("getElementsByTagNameNS");
    }

    public final TypeInfo getSchemaTypeInfo() {
        throw new UnsupportedOperationException("getSchemaTypeInfo");
    }

    public final boolean hasAttribute(String name) {
        throw new UnsupportedOperationException("hasAttribute");
    }

    public final boolean hasAttributeNS(String namespaceURI, String localName) {
        throw new UnsupportedOperationException("hasAttributeNS");
    }

    public final void removeAttribute(String name) {
        throw new UnsupportedOperationException("removeAttribute");
    }

    public final void removeAttributeNS(String namespaceURI, String localName) {
        throw new UnsupportedOperationException("removeAttributeNS");
    }

    public final Attr removeAttributeNode(Attr oldAttr) {
        throw new UnsupportedOperationException("removeAttributeNode");
    }

    public final void setAttributeNS(String namespaceURI, String qualifiedName, String value) {
        throw new UnsupportedOperationException("setAttributeNS");
    }

    public final Attr setAttributeNode(Attr newAttr) {
        throw new UnsupportedOperationException("setAttributeNode");
    }

    public final Attr setAttributeNodeNS(Attr newAttr) {
        throw new UnsupportedOperationException("setAttributeNodeNS");
    }

    public final void setIdAttribute(String name, boolean isId) {
        throw new UnsupportedOperationException("setIdAttribute");
    }

    public final void setIdAttributeNS(String namespaceURI, String localName, boolean isId) {
        throw new UnsupportedOperationException("setIdAttributeNS");
    }

    public final void setIdAttributeNode(Attr idAttr, boolean isId) {
        throw new UnsupportedOperationException("setIdAttributeNode");
    }

    public final String getNodeName() {
        return this.getTagName();
    }

    public NamedNodeMap getAttributes() {
        return new AttributeNodeMap(this.attributes, this);
    }

    public final String getLocalName() {
        return this.getTagName();
    }

    public final short getNodeType() {
        return 1;
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder(this.getTagName());
        for (Map.Entry<String, String> attrs : this.attributes.entrySet()) {
            builder.append(" " + attrs.getKey() + "='" + attrs.getValue() + "'");
        }
        return builder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AttributeNodeMap
    implements NamedNodeMap {
        private final Map<String, String> attributes;
        private final Element owner;

        protected AttributeNodeMap(Map<String, String> attrs, Element parent) {
            this.attributes = attrs;
            this.owner = parent;
        }

        @Override
        public int getLength() {
            return this.attributes.size();
        }

        @Override
        public Node getNamedItem(String name) {
            String value = this.attributes.get(name);
            if (value == null) {
                return null;
            }
            return new AttrImpl(name, value, this.owner);
        }

        @Override
        public Node getNamedItemNS(String namespaceURI, String localName) {
            return this.getNamedItem(localName);
        }

        @Override
        public Node item(int index) {
            Iterator<Map.Entry<String, String>> it = this.attributes.entrySet().iterator();
            for (int i = 0; i < index; ++i) {
                it.next();
            }
            Map.Entry<String, String> found = it.next();
            return new AttrImpl(found.getKey(), found.getValue(), this.owner);
        }

        @Override
        public Node removeNamedItem(String name) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Node removeNamedItemNS(String namespaceURI, String localName) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Node setNamedItem(Node arg) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Node setNamedItemNS(Node arg) {
            throw new UnsupportedOperationException();
        }
    }

    public static class AttrImpl
    extends AbstractPartialNodeImpl
    implements Attr {
        private final String name;
        private final String value;
        private final Element owner;

        protected AttrImpl(String nam, String val, Element own) {
            this.name = nam;
            this.value = val;
            this.owner = own;
        }

        public String getName() {
            return this.name;
        }

        public Element getOwnerElement() {
            return this.owner;
        }

        public TypeInfo getSchemaTypeInfo() {
            throw new UnsupportedOperationException();
        }

        public boolean getSpecified() {
            throw new UnsupportedOperationException();
        }

        public String getValue() {
            return this.value;
        }

        public final String getNodeValue() {
            return this.value;
        }

        public boolean isId() {
            throw new UnsupportedOperationException();
        }

        public void setValue(String val) {
            throw new UnsupportedOperationException();
        }

        public String getNodeName() {
            return this.name;
        }

        public short getNodeType() {
            return 2;
        }
    }
}

