/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.dom;

import java.util.HashSet;
import java.util.Set;
import net.sourceforge.jeuclid.dom.AbstractPartialElementImpl;
import net.sourceforge.jeuclid.dom.ChangeTrackingInterface;
import net.sourceforge.jeuclid.elements.support.ElementListSupport;
import org.w3c.dom.Node;

public abstract class AbstractChangeTrackingElement
extends AbstractPartialElementImpl
implements ChangeTrackingInterface {
    private final Set<ChangeTrackingInterface> listeners = new HashSet<ChangeTrackingInterface>();

    public final Node appendChild(Node newChild) {
        Node retVal = super.appendChild(newChild);
        this.fireChanged(true);
        return retVal;
    }

    public final void setAttribute(String name, String value) {
        super.setAttribute(name, value);
        this.fireChanged(true);
    }

    public final void setTextContent(String newTextContent) {
        super.setTextContent(newTextContent);
        this.fireChanged(true);
    }

    public final Node replaceChild(Node newChild, Node oldChild) {
        Node retVal = super.replaceChild(newChild, oldChild);
        this.fireChanged(true);
        return retVal;
    }

    public void fireChanged(boolean propagate) {
        this.changeHook();
        if (propagate) {
            Node superNode = this.getParentNode();
            if (superNode instanceof ChangeTrackingInterface) {
                ((ChangeTrackingInterface)((Object)superNode)).fireChanged(propagate);
            }
            for (ChangeTrackingInterface listener : this.listeners) {
                listener.fireChanged(false);
            }
        }
    }

    public void fireChangeForSubTree() {
        this.fireChanged(false);
        ElementListSupport.fireChangeForSubTree(ElementListSupport.createListOfChildren(this));
    }

    protected void changeHook() {
    }

    public void addListener(ChangeTrackingInterface listener) {
        this.listeners.add(listener);
    }
}

