/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.content.semantic;

import net.sourceforge.jeuclid.MathBase;
import net.sourceforge.jeuclid.elements.presentation.general.AbstractRowLike;
import org.w3c.dom.mathml.MathMLElement;
import org.w3c.dom.mathml.MathMLSemanticsElement;

public class Semantics
extends AbstractRowLike
implements MathMLSemanticsElement {
    public static final String ELEMENT = "semantics";

    public Semantics(MathBase base) {
        super(base);
    }

    public String getTagName() {
        return ELEMENT;
    }

    public void deleteAnnotation(int index) {
        this.removeAnnotation(index);
    }

    public MathMLElement getAnnotation(int index) {
        return (MathMLElement)this.getChildNodes().item(index);
    }

    public MathMLElement getBody() {
        return (MathMLElement)this.getFirstChild();
    }

    public int getNAnnotations() {
        return Math.max(0, this.getChildNodes().getLength() - 1);
    }

    public MathMLElement insertAnnotation(MathMLElement newAnnotation, int index) {
        if (index == 0) {
            if (this.getNAnnotations() == 0) {
                this.setAnnotation(newAnnotation, 1);
            } else {
                this.addMathElement(newAnnotation);
            }
        } else {
            MathMLElement oldChild = this.getAnnotation(index);
            if (oldChild != null) {
                this.insertBefore(newAnnotation, oldChild);
            } else {
                this.setAnnotation(newAnnotation, index);
            }
        }
        return newAnnotation;
    }

    public MathMLElement removeAnnotation(int index) {
        MathMLElement oldChild = this.getAnnotation(index);
        return (MathMLElement)this.removeChild(oldChild);
    }

    public MathMLElement setAnnotation(MathMLElement newAnnotation, int index) {
        this.setMathElement(index, newAnnotation);
        return newAnnotation;
    }

    public void setBody(MathMLElement body) {
        this.setMathElement(0, body);
    }
}

