/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.app.support;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.jeuclid.ParameterKey;

public final class CommandLineParser {
    private CommandLineParser() {
    }

    public static ParseResults parseCommandLine(String[] args) {
        File source = null;
        File target = null;
        int count = 0;
        HashMap<ParameterKey, String> params = new HashMap<ParameterKey, String>();
        String option = null;
        for (int i = 0; i < args.length; ++i) {
            String curArg = args[i];
            if (curArg.startsWith("-")) {
                option = curArg.substring(1);
                continue;
            }
            if (option != null) {
                String value = args[i];
                ParameterKey key = ParameterKey.valueOf(option);
                params.put(key, value);
                option = null;
            } else if (count == 0) {
                source = new File(curArg);
            } else if (count == 1) {
                target = new File(curArg);
            } else {
                throw new IllegalArgumentException("To many files given");
            }
            ++count;
        }
        if (option != null) {
            throw new IllegalArgumentException("No value given for " + option);
        }
        return new ParseResults(source, target, params);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ParseResults {
        private final File source;
        private final File target;
        private final Map<ParameterKey, String> params;

        public ParseResults(File s, File t, Map<ParameterKey, String> p) {
            this.source = s;
            this.target = t;
            this.params = p;
        }

        public final Map<ParameterKey, String> getParams() {
            return this.params;
        }

        public final File getSource() {
            return this.source;
        }

        public final File getTarget() {
            return this.target;
        }
    }
}

