/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid;

import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;

public final class MathMLSerializer {
    private static final Log LOGGER = LogFactory.getLog(MathMLSerializer.class);

    private MathMLSerializer() {
    }

    public static String serializeDocument(Document doc, boolean addDoctype, boolean format) {
        StringWriter writer = new StringWriter();
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(writer);
            if (addDoctype) {
                transformer.setOutputProperty("doctype-public", "-//W3C//DTD MathML 2.0//EN");
                transformer.setOutputProperty("doctype-system", "http://www.w3.org/TR/MathML2/dtd/mathml2.dtd");
                transformer.setOutputProperty("media-type", "application/mathml+xml");
            }
            if (format) {
                transformer.setOutputProperty("indent", "yes");
            } else {
                transformer.setOutputProperty("indent", "no");
            }
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            LOGGER.warn((Object)e);
        }
        return writer.toString();
    }
}

