/*
 * Decompiled with CFR 0.152.
 */
package com.inet.beans.gauge;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.JComponent;

public class Gauge
extends JComponent {
    private static final long serialVersionUID = -7178531855362214357L;
    private static int[] BORDER_RGB = new int[]{0, 10, 29, 46, 63, 81, 98, 96, 87, 80, 72, 65, 58, 50, 42, 35, 27, 19, 3, 52};
    private static int[] ALL_RGB = new int[194];
    private int lastWidth = 0;
    private int lastHeigth = 0;
    private BufferedImage bi;
    private boolean update = false;
    private Color scaleLineColor = new Color(142, 142, 142);
    private Color needleCircleColor = new Color(102, 102, 102);
    private Color needleColor = new Color(204, 119, 0);
    private Color backgroundColor = Color.BLACK;
    private Color majorTickColor = Color.WHITE;
    private Color textColor = this.scaleLineColor;
    private int[] backgroundBuffer = new int[ALL_RGB.length];
    private double angleExtend;
    private double angleStart;
    private double value;
    private double minValue;
    private double maxValue;
    private double minorTickStep;
    private double majorTickStep;
    private Color minorTickColor;
    private String text;
    private int decPlaceCount;
    private boolean showValue;
    private NumberFormat format;

    public Gauge() {
        this.reloadBuffer(this.backgroundColor);
        this.angleExtend = 270.0;
        this.angleStart = -45.0;
        this.value = 62.0;
        this.minValue = 0.0;
        this.maxValue = 100.0;
        this.minorTickStep = 2.5;
        this.majorTickStep = 10.0;
        this.minorTickColor = this.scaleLineColor;
        this.text = "i-net software";
        this.decPlaceCount = 0;
        this.showValue = true;
        this.format = NumberFormat.getNumberInstance();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.update || w != this.lastWidth || h != this.lastHeigth) {
            this.update = false;
            this.lastWidth = w;
            this.lastHeigth = h;
            this.conformProperties();
            this.bi = new BufferedImage(w, h, 2);
            Graphics2D g2 = this.bi.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            double r = Math.min(w, h) / 2 - 5;
            Point2D.Double cp = new Point2D.Double(w / 2, h / 2);
            this.drawBackground(r, cp, g2);
            this.drawScale(r, cp, g2);
            this.drawText(r, cp, g2);
            g2.dispose();
        }
        g.drawImage(this.bi, 0, 0, this);
    }

    protected void conformProperties() {
        double min = Math.min(this.minValue, this.maxValue);
        double max = Math.max(this.minValue, this.maxValue);
        this.minValue = min;
        this.maxValue = max;
        if (this.value < this.minValue || this.value > this.maxValue) {
            double d = this.value = this.value < this.minValue ? this.minValue : this.maxValue;
        }
        if (this.majorTickStep >= this.maxValue - this.minValue) {
            this.majorTickStep = (this.maxValue - this.minValue) / 10.0;
        }
        if (this.minorTickStep >= this.majorTickStep) {
            this.minorTickStep = this.majorTickStep / 4.0;
        }
        if (this.angleExtend < 90.0 || this.angleExtend > 270.0) {
            double d = this.angleExtend = this.angleExtend < 90.0 ? 90.0 : 270.0;
        }
        if (this.angleStart < -90.0 || this.angleStart > 90.0) {
            this.angleStart = this.angleStart < -90.0 ? -90.0 : 90.0;
        }
    }

    @Override
    public void paint(Graphics g) {
        this.update = true;
        super.paint(g);
    }

    private void drawBackground(double r, Point2D cp, Graphics2D g2) {
        Ellipse2D.Double ell = new Ellipse2D.Double(cp.getX() - r, cp.getY() - r, 2.0 * r, 2.0 * r);
        int x0 = (int)Math.floor(ell.getMinX());
        int x1 = (int)Math.ceil(ell.getMaxX());
        int y0 = (int)Math.floor(ell.getMinY());
        int y1 = (int)Math.ceil(ell.getMaxY());
        for (int i = x0; i < x1; ++i) {
            for (int j = y0; j < y1; ++j) {
                double distance = (int)cp.distance(i, j);
                if (!(distance < r)) continue;
                double teil = distance / r;
                int index = (int)((double)this.backgroundBuffer.length * teil);
                this.bi.setRGB(i, j, this.backgroundBuffer[index]);
            }
        }
        g2.setColor(new Color(this.backgroundBuffer[this.backgroundBuffer.length - 1], true));
        g2.draw(ell);
    }

    private void drawScale(double r, Point2D cp, Graphics2D g2) {
        double majorTickR;
        double majorTickSize;
        block7: {
            double r0 = this.proz(r, 55.0);
            double r1 = this.proz(r, 58.0);
            Arc2D.Double arc0 = new Arc2D.Double(2);
            arc0.setFrameFromCenter(cp, new Point2D.Double(cp.getX() - r0, cp.getY() - r0));
            ((Arc2D)arc0).setAngleStart(this.angleStart);
            ((Arc2D)arc0).setAngleExtent(this.angleExtend);
            Arc2D.Double arc1 = new Arc2D.Double(2);
            arc1.setFrameFromCenter(cp, new Point2D.Double(cp.getX() - r1, cp.getY() - r1));
            ((Arc2D)arc1).setAngleStart(this.angleStart);
            ((Arc2D)arc1).setAngleExtent(this.angleExtend);
            Area area = new Area(arc1);
            area.subtract(new Area(arc0));
            g2.setColor(this.scaleLineColor);
            g2.fill(area);
            majorTickSize = this.proz(r, 4.0);
            double minorTickSize = this.proz(r, 2.0);
            majorTickR = r1 + 4.0;
            double minorTickR = majorTickR + (majorTickSize - minorTickSize) / 2.0;
            Stroke oldStroke = g2.getStroke();
            Font oldFont = g2.getFont();
            if (this.minorTickStep > 0.0) {
                g2.setColor(this.minorTickColor);
                g2.setStroke(new BasicStroke(1.0f));
                double minorGradSteps = this.angleExtend * this.minorTickStep / (this.maxValue - this.minValue);
                for (double i = this.angleStart; i <= this.angleStart + this.angleExtend; i += minorGradSteps) {
                    Point2D p0 = this.getPoint(cp, minorTickR, i);
                    Point2D p1 = this.getPoint(cp, minorTickR + minorTickSize, i);
                    g2.draw(new Line2D.Double(p0, p1));
                }
            }
            if (!(this.majorTickStep > 0.0)) break block7;
            double markerR = majorTickR + 2.0 * majorTickSize;
            double l = this.valueToString(this.maxValue).length();
            if (l > 3.0 && this.decPlaceCount > 0) {
                l -= 1.0;
            }
            double f = l < 4.0 ? 1.0 : 1.0 - 0.1 * (l - 3.0);
            double majorFontSize = Math.max(6.0, this.proz(r, 9.0) * f);
            Font font = oldFont.deriveFont(majorFontSize < 8.0 ? 0 : 1, (float)majorFontSize);
            g2.setFont(font);
            g2.setColor(this.majorTickColor);
            g2.setStroke(new BasicStroke(2.0f));
            double stepAngle = this.angleExtend * this.majorTickStep / (this.maxValue - this.minValue);
            boolean b = true;
            double v = this.minValue;
            while (b) {
                block10: {
                    block9: {
                        block8: {
                            if (!(v > this.maxValue) && !(Math.abs(this.maxValue - v) <= 1.0E-6)) break block8;
                            v = this.maxValue;
                            b = false;
                            break block9;
                        }
                        if (v + this.minorTickStep >= this.maxValue) break block10;
                    }
                    double currentAngle = this.angleStart + this.angleExtend - stepAngle * (v - this.minValue) / this.majorTickStep;
                    Point2D p0 = this.getPoint(cp, majorTickR, currentAngle);
                    Point2D p1 = this.getPoint(cp, majorTickR + majorTickSize, currentAngle);
                    g2.draw(new Line2D.Double(p0, p1));
                    String s = this.valueToString(v);
                    Dimension size = this.getStringSize(s, g2);
                    double delta = size.getWidth() / 2.0;
                    Point2D mc = this.getPoint(cp, markerR + delta, currentAngle);
                    g2.drawString(s, (float)(mc.getX() - size.getWidth() / 2.0), (float)(mc.getY() + size.getHeight() / 2.0));
                }
                v += this.majorTickStep;
            }
            g2.setStroke(oldStroke);
            g2.setFont(oldFont);
        }
        double needleR = majorTickR + 1.5 * majorTickSize;
        this.drawNeedle(r, needleR, cp, g2);
    }

    private String valueToString(double v) {
        return this.format.format(v);
    }

    private void drawNeedle(double r, double needleR, Point2D cp, Graphics2D g2) {
        double r0 = this.proz(r, 6.0);
        double r1 = this.proz(r, 7.5);
        Ellipse2D.Double ell_0 = new Ellipse2D.Double();
        ell_0.setFrameFromCenter(cp, new Point2D.Double(cp.getX() - r0, cp.getY() - r0));
        Ellipse2D.Double ell_1 = new Ellipse2D.Double();
        ell_1.setFrameFromCenter(cp, new Point2D.Double(cp.getX() - r1, cp.getY() - r1));
        double angleCurrent = this.angleStart + this.angleExtend * (1.0 - (this.value - this.minValue) / (this.maxValue - this.minValue));
        Point2D ap = this.getPoint(cp, needleR, angleCurrent);
        double angleLeft = angleCurrent + 90.0;
        double angleRight = angleCurrent - 90.0;
        if (angleLeft > 360.0) {
            angleLeft -= 360.0;
        }
        if (angleRight < -90.0) {
            angleRight += 360.0;
        }
        Point2D pointLeft = this.getPoint(cp, ((RectangularShape)ell_0).getHeight() / 3.5, angleLeft);
        Point2D pointRight = this.getPoint(cp, ((RectangularShape)ell_0).getHeight() / 3.5, angleRight);
        Polygon pol = new Polygon();
        pol.addPoint((int)Math.round(pointLeft.getX()), (int)Math.round(pointLeft.getY()));
        pol.addPoint((int)Math.round(ap.getX()), (int)Math.round(ap.getY()));
        pol.addPoint((int)Math.round(pointRight.getX()), (int)Math.round(pointRight.getY()));
        g2.setColor(this.needleColor);
        g2.fill(pol);
        g2.setColor(this.needleCircleColor.brighter());
        g2.fill(ell_1);
        g2.setColor(this.needleCircleColor);
        g2.fill(ell_0);
        if (this.showValue) {
            String s = this.valueToString(this.value);
            double rv = this.proz(r, 48.0);
            Point2D p = this.getPoint(cp, rv, this.angleStart + this.angleExtend + (360.0 - this.angleExtend) / 2.0);
            double h = this.proz(r, 16.0);
            g2.setFont(g2.getFont().deriveFont(1, (float)(h * 0.7)));
            Dimension size = this.getStringSize(s, g2);
            int l = s.length();
            double f = l < 3 ? 2.0 : Math.max(2.0 - (double)l * 0.1, 1.1);
            double w = size.getWidth() * f;
            double corner = Math.min(10.0, Math.max(h, w) / 4.0);
            RoundRectangle2D.Double cvArea = new RoundRectangle2D.Double(p.getX() - w / 2.0, p.getY() - h / 2.0, w, h, corner, corner);
            g2.fill(cvArea);
            Stroke old = g2.getStroke();
            g2.setColor(this.scaleLineColor);
            g2.setStroke(new BasicStroke(h < 20.0 ? 1.0f : (h < 40.0 ? 2.0f : 3.0f)));
            g2.draw(cvArea);
            g2.setStroke(old);
            g2.setColor(this.needleColor);
            double x0 = cvArea.getCenterX() - size.getWidth() / 2.0;
            double y0 = cvArea.getCenterY() + size.getHeight() / 2.0;
            g2.drawString(s, (float)x0, (float)y0);
        }
    }

    private void drawText(double r, Point2D cp, Graphics2D g2) {
        if (this.text == null || this.text.length() == 0) {
            return;
        }
        double r0 = this.proz(r, 65.0);
        double r1 = this.proz(r, 72.0);
        Point2D p = this.getPoint(cp, r1, 270.0);
        double h = r1 - r0;
        g2.setFont(g2.getFont().deriveFont(1, (float)h));
        g2.setColor(this.textColor);
        Dimension dim = this.getStringSize(this.text, g2);
        double y0 = cp.getY() + r0 + dim.getHeight();
        g2.drawString(this.text, (float)(p.getX() - dim.getWidth() / 2.0), (float)y0);
    }

    private Dimension getStringSize(String s, Graphics g) {
        FontMetrics fm = g.getFontMetrics();
        int width = fm.stringWidth(s);
        int height = fm.getMaxAscent() - fm.getMaxDescent();
        return new Dimension(width, height);
    }

    private Point2D getPoint(Point2D cp, double r, double alpha) {
        double angle = Math.toRadians(alpha);
        double x = cp.getX() + r * Math.cos(angle);
        double y = cp.getY() - r * Math.sin(angle);
        return new Point2D.Double(x, y);
    }

    private double proz(double v, double proz) {
        return v * proz / 100.0;
    }

    private void reloadBuffer(Color newColor) {
        int r = newColor.getRed();
        int g = newColor.getGreen();
        int b = newColor.getBlue();
        int a = newColor.getAlpha();
        for (int i = 0; i < this.backgroundBuffer.length; ++i) {
            Color c = new Color(ALL_RGB[i]);
            int r1 = Math.min(255, c.getRed() + r);
            int g1 = Math.min(255, c.getGreen() + g);
            int b1 = Math.min(255, c.getBlue() + b);
            this.backgroundBuffer[i] = new Color(r1, g1, b1, a).getRGB();
        }
    }

    public void update() {
        this.update = true;
        this.repaint();
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color bg) {
        if (bg != null) {
            this.backgroundColor = bg;
            this.reloadBuffer(bg);
        }
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public void setMinValue(double minValue) {
        this.minValue = minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
    }

    public double getMinorTickStep() {
        return this.minorTickStep;
    }

    public void setMinorTickStep(double minorTickStep) {
        boolean isLowerThanOneAndPrecisionIsOne;
        Double doubleValueObject = new Double(minorTickStep);
        BigDecimal roundedTickStep = new BigDecimal(doubleValueObject.toString());
        boolean bl = isLowerThanOneAndPrecisionIsOne = minorTickStep < 1.0 && roundedTickStep.precision() == 1;
        if (roundedTickStep.precision() != 0 && !isLowerThanOneAndPrecisionIsOne) {
            int scale = roundedTickStep.precision() + this.decPlaceCount - 1;
            roundedTickStep = roundedTickStep.setScale(scale, RoundingMode.HALF_UP);
        }
        this.minorTickStep = roundedTickStep.doubleValue();
    }

    public double getMajorTickStep() {
        return this.majorTickStep;
    }

    public void setMajorTickStep(double majorTickStep) {
        BigDecimal roundedTickStep = new BigDecimal(majorTickStep);
        roundedTickStep = roundedTickStep.setScale(this.decPlaceCount, RoundingMode.HALF_UP);
        this.majorTickStep = roundedTickStep.doubleValue();
    }

    public int getDecPlaceCount() {
        return this.decPlaceCount;
    }

    public void setDecPlaceCount(int decPlaceCount) {
        if (this.decPlaceCount != decPlaceCount) {
            this.decPlaceCount = Math.max(0, Math.min(decPlaceCount, 3));
            switch (this.decPlaceCount) {
                case 0: {
                    this.format = NumberFormat.getNumberInstance();
                    break;
                }
                case 1: {
                    this.format = new DecimalFormat("#0.0");
                    break;
                }
                case 2: {
                    this.format = new DecimalFormat("#0.00");
                    break;
                }
                default: {
                    this.format = new DecimalFormat("#0.000");
                }
            }
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Color getScaleLineColor() {
        return this.scaleLineColor;
    }

    public void setScaleLineColor(Color scaleLineColor) {
        this.scaleLineColor = scaleLineColor;
    }

    public Color getNeedleCircleColor() {
        return this.needleCircleColor;
    }

    public void setNeedleCircleColor(Color needleCircleColor) {
        this.needleCircleColor = needleCircleColor;
    }

    public Color getNeedleColor() {
        return this.needleColor;
    }

    public void setNeedleColor(Color needleColor) {
        this.needleColor = needleColor;
    }

    public boolean isShowValue() {
        return this.showValue;
    }

    public void setShowValue(boolean showValue) {
        this.showValue = showValue;
    }

    public Color getMajorTickColor() {
        return this.majorTickColor;
    }

    public void setMajorTickColor(Color majorTickColor) {
        this.majorTickColor = majorTickColor;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public double getAngleExtend() {
        return this.angleExtend;
    }

    public void setAngleExtend(double angleExtend) {
        this.angleExtend = angleExtend;
    }

    public double getAngleStart() {
        return this.angleStart;
    }

    public void setAngleStart(double angleStart) {
        this.angleStart = angleStart;
    }

    static {
        for (int i = 0; i < BORDER_RGB.length; ++i) {
            int v = BORDER_RGB[i];
            Gauge.BORDER_RGB[i] = new Color(v, v, v).getRGB();
        }
        int v = 32;
        Gauge.ALL_RGB[0] = new Color(v, v, v).getRGB();
        for (int i = 1; i < ALL_RGB.length; ++i) {
            if (i <= 118) {
                Gauge.ALL_RGB[i] = ALL_RGB[i - 1];
                continue;
            }
            if (i < 166) {
                Gauge.ALL_RGB[i] = new Color(--v, v, v).getRGB();
                Gauge.ALL_RGB[i + 1] = ALL_RGB[i];
                ++i;
                continue;
            }
            if (i < ALL_RGB.length - BORDER_RGB.length) {
                Gauge.ALL_RGB[i] = Color.BLACK.getRGB();
                continue;
            }
            System.arraycopy(BORDER_RGB, 0, ALL_RGB, i, BORDER_RGB.length);
            break;
        }
    }
}

