/*
 * Decompiled with CFR 0.152.
 */
package com.inet.beans.pdf417;

import com.inet.beans.pdf417.Pdf417;
import java.awt.Image;
import java.beans.BeanDescriptor;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.SimpleBeanInfo;
import java.util.Stack;

public class Pdf417BeanInfo
extends SimpleBeanInfo {
    private static Class<Pdf417> beanClass = Pdf417.class;

    @Override
    public BeanDescriptor getBeanDescriptor() {
        BeanDescriptor bd = new BeanDescriptor(beanClass);
        bd.setName(beanClass.getName());
        bd.setDisplayName("2D barcode PDF417 generator");
        return bd;
    }

    @Override
    public PropertyDescriptor[] getPropertyDescriptors() {
        Stack<PropertyDescriptor> stack = new Stack<PropertyDescriptor>();
        try {
            stack.push(this.createDescriptor("codeRows"));
            ((PropertyDescriptor)stack.peek()).setDisplayName("The number of barcode rows. This number may be changed to keep the barcode valid. Range is [3..90]");
            stack.push(this.createDescriptor("codeColumns"));
            ((PropertyDescriptor)stack.peek()).setDisplayName("The number of barcode data columns. This number may be changed to keep the barcode valid. Range is [1..30]");
            stack.push(this.createDescriptor("errorLevel"));
            ((PropertyDescriptor)stack.peek()).setDisplayName("The error level correction for the barcode. Range is [0..8]");
            stack.push(this.createDescriptor("text"));
            ((PropertyDescriptor)stack.peek()).setDisplayName("The text that will form the barcode. \nThis text is converted to bytes using the encoding Cp437");
            stack.push(this.createDescriptor("fixedRectangle"));
            ((PropertyDescriptor)stack.peek()).setDisplayName("The size of the barcode will be at least <codeColumns>*<codeRows>");
            stack.push(this.createDescriptor("fixedColumns"));
            ((PropertyDescriptor)stack.peek()).setDisplayName("The size will be at least <codeColumns> with a variable number of <codeRows>");
            stack.push(this.createDescriptor("fixedRows"));
            ((PropertyDescriptor)stack.peek()).setDisplayName("The size will be at least <codeRows> with a variable number of <codeColumns>");
            stack.push(this.createDescriptor("autoErrorLevel"));
            ((PropertyDescriptor)stack.peek()).setDisplayName("The error level correction is set automatically according to ISO 15438 recomendations");
            stack.push(this.createDescriptor("autoScale"));
            ((PropertyDescriptor)stack.peek()).setDisplayName("The size is automatically scaled");
            return stack.toArray(new PropertyDescriptor[stack.size()]);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
    }

    private PropertyDescriptor createDescriptor(String propertyName) throws IntrospectionException {
        return new PropertyDescriptor(propertyName, beanClass);
    }

    @Override
    public Image getIcon(int iconKind) {
        switch (iconKind) {
            case 1: {
                return this.loadImage("pdf417.gif");
            }
        }
        return null;
    }
}

