/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api;

import com.inet.field.Field;
import com.inet.usersandgroups.api.groups.GroupType;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class FieldAndGroupTypeAssociation {
    private final GroupType a;
    private final Set<String> b;

    public FieldAndGroupTypeAssociation(GroupType groupType, String ... fieldKeys) {
        this(groupType, new HashSet<String>(Arrays.asList(fieldKeys)));
    }

    public FieldAndGroupTypeAssociation(GroupType groupType, Set<String> fieldKeys) {
        if (groupType == null) {
            throw new IllegalArgumentException("group type must not be null");
        }
        if (fieldKeys == null) {
            throw new IllegalArgumentException("list of field keys must not be null");
        }
        fieldKeys.forEach(string -> Field.throwIfInvalidKey(string));
        this.a = groupType;
        this.b = Collections.unmodifiableSet(new HashSet<String>(fieldKeys));
    }

    public GroupType getGroupType() {
        return this.a;
    }

    public Set<String> getFieldKeys() {
        return this.b;
    }
}

