/*
 * Decompiled with CFR 0.152.
 */
package com.inet.shared.servlet;

import com.inet.classloader.BaseLocator;
import com.inet.config.Configuration;
import com.inet.config.ConfigurationManager;
import com.inet.http.error.HttpFailedException;
import com.inet.http.error.ServletErrorHandler;
import com.inet.http.utils.MimeTypes;
import com.inet.lib.util.EncodingFunctions;
import com.inet.lib.util.IOFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.persistence.PersistenceEntry;
import com.inet.plugin.fs.ResourceFile;
import com.inet.shared.servlet.AsyncResponseWriter;
import com.inet.shared.servlet.ProxyHttpServletRequest;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletMapping;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

public class ServletUtils {
    private static final String LAST_MODIFIED = "last-modified";
    private static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    private static final String EXPIRES = "Expires";
    private static ServletContext a;
    private static final ThreadLocal<SimpleDateFormat> b;
    private static final String[] c;
    private static boolean d;

    public static boolean checkLastModified(HttpServletRequest req, HttpServletResponse res, long lastModifiedMillis) {
        return ServletUtils.checkLastModified(req, res, lastModifiedMillis, 600000L);
    }

    public static boolean checkLastModified(HttpServletRequest req, HttpServletResponse res, long lastModifiedMillis, long cacheTime) {
        Object object;
        block7: {
            String string;
            SimpleDateFormat simpleDateFormat = ServletUtils.getFormatter();
            Date date = new Date(lastModifiedMillis);
            res.setHeader(LAST_MODIFIED, simpleDateFormat.format(date));
            if (cacheTime > 0L && !res.containsHeader(EXPIRES)) {
                ServletUtils.setExpirationHeader(res, cacheTime);
            }
            if ((string = req.getHeader(IF_MODIFIED_SINCE)) != null && cacheTime > 1000L) {
                try {
                    object = simpleDateFormat.parse(string);
                    boolean bl = ((Date)object).getTime() / 1000L != date.getTime() / 1000L;
                    if (bl) break block7;
                    try {
                        res.setStatus(304);
                    }
                    catch (IllegalStateException illegalStateException) {
                        LogManager.getConfigLogger().debug(illegalStateException);
                    }
                    return true;
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        if ((object = req.getHeader("If-None-Match")) != null && ((String)object).equals(res.getHeader("ETag"))) {
            res.setStatus(304);
            return true;
        }
        return false;
    }

    public static void sendBinaryData(URLConnection conn, OutputStream out) throws IOException {
        ServletUtils.sendBinaryData(conn.getInputStream(), out);
    }

    public static void sendBinaryData(InputStream input, OutputStream out) throws IOException {
        block8: {
            try (InputStream inputStream = input;){
                IOFunctions.copyData(inputStream, out);
            }
            catch (IOException iOException) {
                if (ServletErrorHandler.isClientAbort(iOException)) break block8;
                throw iOException;
            }
        }
    }

    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="The caller must validate the passed URL.")
    public static void sendStaticContent(URL url, HttpServletRequest req, HttpServletResponse res) throws IOException {
        if (url == null) {
            ServletUtils.sendFileNotExist(req, res);
        } else {
            ServletUtils.sendStaticContent(url.openConnection(), req, res);
        }
    }

    public static void sendStaticContent(ResourceFile file, HttpServletRequest req, HttpServletResponse res) throws IOException {
        if (file == null) {
            ServletUtils.sendFileNotExist(req, res);
            return;
        }
        String string = MimeTypes.getMimeType(file.getName());
        try {
            ServletUtils.sendStaticContent(string, file.lastModified(), file.length(), file.getInputStream(), req, res);
        }
        catch (FileNotFoundException fileNotFoundException) {
            ServletUtils.sendFileNotExist(req, res);
        }
        file.getName();
    }

    public static void sendStaticContent(File file, HttpServletRequest req, HttpServletResponse res) throws IOException {
        if (file == null) {
            ServletUtils.sendFileNotExist(req, res);
            return;
        }
        String string = MimeTypes.getMimeType(file.getName());
        if ("HEAD".equals(req.getMethod())) {
            if (file.exists()) {
                ServletUtils.sendStaticContent(string, file.lastModified(), file.length(), null, req, res);
            } else {
                ServletUtils.sendFileNotExist(req, res);
            }
        } else {
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                ServletUtils.sendStaticContent(string, file.lastModified(), file.length(), fileInputStream, req, res);
            }
            catch (FileNotFoundException fileNotFoundException) {
                ServletUtils.sendFileNotExist(req, res);
            }
        }
    }

    public static void sendStaticContent(PersistenceEntry entry, HttpServletRequest req, HttpServletResponse res) throws IOException {
        if (entry == null) {
            ServletUtils.sendFileNotExist(req, res);
            return;
        }
        String string = MimeTypes.getMimeType(entry.getName());
        try (InputStream inputStream = entry.getInputStream();){
            ServletUtils.sendStaticContent(string, entry.lastModified(), entry.size(), inputStream, req, res);
        }
        catch (FileNotFoundException fileNotFoundException) {
            ServletUtils.sendFileNotExist(req, res);
        }
    }

    public static void sendStaticContent(URLConnection conn, HttpServletRequest req, HttpServletResponse res) throws IOException {
        String string = MimeTypes.getMimeType(conn.getURL().getFile());
        ServletUtils.sendStaticContent(string, conn.getLastModified(), conn.getContentLength(), conn.getInputStream(), req, res);
    }

    public static void sendStaticContent(String mimeType, long lastModifiedMillis, long contentLength, InputStream input, HttpServletRequest req, HttpServletResponse res) throws IOException {
        ServletUtils.sendStaticContent(mimeType, lastModifiedMillis, contentLength, input, req, res, res.getOutputStream());
    }

    public static void sendStaticContent(String mimeType, long lastModifiedMillis, long contentLength, InputStream input, HttpServletRequest req, HttpServletResponse res, OutputStream outputStream) throws IOException {
        if (mimeType != null) {
            res.setCharacterEncoding((String)null);
            res.setContentType(mimeType);
        }
        if (ServletUtils.checkLastModified(req, res, lastModifiedMillis)) {
            return;
        }
        if (contentLength > 0L) {
            res.setContentLengthLong(contentLength);
        }
        if ("HEAD".equals(req.getMethod())) {
            return;
        }
        ServletUtils.sendBinaryData(input, outputStream);
        outputStream.flush();
    }

    public static void sendDynamicContent(String mimeType, long contentLength, InputStream input, HttpServletRequest req, HttpServletResponse res) throws IOException {
        if (mimeType != null) {
            res.setContentType(mimeType);
        }
        ServletUtils.setExpirationHeader(res, 0L);
        if ("HEAD".equals(req.getMethod())) {
            return;
        }
        if (contentLength > 0L) {
            res.setContentLengthLong(contentLength);
        }
        ServletOutputStream servletOutputStream = res.getOutputStream();
        ServletUtils.sendBinaryData(input, (OutputStream)servletOutputStream);
        servletOutputStream.flush();
    }

    public static void sendFileNotExist(HttpServletRequest req, HttpServletResponse res) throws IOException {
        String string = req.getRequestURI();
        string = StringFunctions.encodeHTML(string);
        String string2 = "<html><head><title>File not found: " + string + "</title></head>\n<body><h1>404 File not found: " + string + "</h1></body></html>";
        try {
            res.setContentType("text/html; charset=utf-8");
            res.setStatus(404);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        res.getOutputStream().write(string2.getBytes(StandardCharsets.UTF_8));
    }

    public static ServletContext getServletContext() {
        return a;
    }

    public static void setServletContext(ServletContext servletContext) {
        a = servletContext;
    }

    public static SimpleDateFormat getFormatter() {
        SimpleDateFormat simpleDateFormat = b.get();
        if (simpleDateFormat == null) {
            simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            b.set(simpleDateFormat);
        }
        return simpleDateFormat;
    }

    @Nullable
    public static String getRequestPage(HttpServletRequest request) {
        String string = request.getParameter("RequestPage");
        if (!StringFunctions.isEmpty(string)) {
            String string2;
            String string3 = String.valueOf(ProxyHttpServletRequest.getHttpServerPort(request)) + request.getContextPath();
            try {
                string2 = new URL(new URL(string3), string).toString();
            }
            catch (MalformedURLException malformedURLException) {
                string2 = string;
            }
            if (!string2.startsWith(string3)) {
                if (request.getAttribute("RequestPage") == null) {
                    request.setAttribute("RequestPage", Boolean.TRUE);
                    throw new HttpFailedException(500, "Invalid RequestPage parameter: " + string);
                }
                return string3;
            }
        }
        return string;
    }

    public static String createRedirectURL(@Nonnull HttpServletRequest request, String redirectURL) {
        return ServletUtils.createRedirectURL(request, redirectURL, request.getQueryString());
    }

    public static String createRedirectURL(@Nonnull HttpServletRequest request, String redirectURL, @Nullable String queryString) {
        LinkedHashMap<String, String> linkedHashMap;
        int n2;
        String string;
        try {
            redirectURL = new URL(redirectURL).toString();
        }
        catch (MalformedURLException malformedURLException) {
            try {
                string = request.getRequestURI();
                if (string != null) {
                    n2 = string.lastIndexOf(47);
                    if (n2 >= 0) {
                        string = string.substring(0, n2 + 1);
                    }
                    redirectURL = new URL(new URL(String.valueOf(ProxyHttpServletRequest.getHttpServerPort(request)) + string), redirectURL).toString();
                }
            }
            catch (MalformedURLException malformedURLException2) {
                // empty catch block
            }
        }
        if (queryString != null && (linkedHashMap = ServletUtils.a(queryString)).size() > 0) {
            n2 = redirectURL.indexOf(63);
            if (n2 < 0) {
                string = redirectURL;
            } else {
                string = redirectURL.substring(0, n2);
                linkedHashMap.putAll(ServletUtils.a(redirectURL.substring(n2 + 1)));
            }
            StringBuilder stringBuilder = new StringBuilder(string);
            stringBuilder.append('?');
            for (Map.Entry<String, String> entry : linkedHashMap.entrySet()) {
                stringBuilder.append(entry.getKey()).append('=').append(entry.getValue()).append('&');
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            redirectURL = stringBuilder.toString();
        }
        return redirectURL;
    }

    @Nullable
    public static String getSessionClientCookie(HttpServletRequest req) {
        if (req == null) {
            return null;
        }
        HttpSession httpSession = req.getSession(false);
        if (httpSession == null) {
            return null;
        }
        ServletContext servletContext = req.getServletContext();
        if (servletContext == null) {
            return null;
        }
        String string = servletContext.getSessionCookieConfig().getName();
        if (string == null) {
            string = "JSESSIONID";
        }
        return string + "=" + httpSession.getId();
    }

    private static LinkedHashMap<String, String> a(String string) {
        String[] stringArray = string.split("&");
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        block0: for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string2;
            String string3;
            String string4 = stringArray[i2];
            if (string4.length() == 0) continue;
            int n2 = string4.indexOf(61);
            if (n2 >= 0) {
                string3 = string4.substring(0, n2);
                string2 = string4.substring(n2 + 1);
            } else {
                string3 = string4;
                string2 = "";
            }
            for (int i3 = 0; i3 < c.length; ++i3) {
                if (string3.equals(c[i3])) continue block0;
            }
            linkedHashMap.put(string3, string2);
        }
        return linkedHashMap;
    }

    @Nonnull
    public static Properties getAllParameters(@Nonnull HttpServletRequest req) {
        Logger logger = LogManager.getApplicationLogger();
        Properties properties = new Properties();
        try {
            Enumeration<String> enumeration = req.getParameterNames();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                String string2 = req.getParameter(string);
                if (logger.isDebug()) {
                    logger.debug("Property:" + string + "=" + string2);
                }
                if (string2 == null) continue;
                properties.put(string, string2);
            }
        }
        catch (Throwable throwable) {
            logger.debug(throwable);
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="The loaded config file will not send to any client.")
    public static void loadConfigurationFromWebXml(ServletConfig config) {
        Object object;
        ServletContext servletContext;
        block20: {
            if (d) {
                return;
            }
            d = true;
            servletContext = config.getServletContext();
            String string = servletContext.getInitParameter("clearreports.config");
            if (string != null) {
                try {
                    String string2;
                    Configuration configuration;
                    object = ConfigurationManager.getInstance();
                    int n2 = string.indexOf(47);
                    if (n2 == -1) break block20;
                    String string3 = string.substring(0, n2);
                    int n3 = string3.equalsIgnoreCase("USER") ? 2 : (string3.equalsIgnoreCase("SYSTEM") ? 1 : (ConfigurationManager.isReadable(1) && ConfigurationManager.isWriteable(1) ? 1 : 2));
                    if (!ConfigurationManager.isReadable(n3) && !ConfigurationManager.isWriteable(n3)) {
                        n3 = 4;
                    }
                    if ((configuration = ((ConfigurationManager)object).get(n3, string2 = string.substring(++n2))) == null) {
                        ResourceFile resourceFile = BaseLocator.getBaseDirectory().createChild("initial_configuration.properties");
                        InputStream inputStream = resourceFile.exists() ? resourceFile.getInputStream() : ServletUtils.class.getClassLoader().getResourceAsStream("configuration_" + string2 + ".xml");
                        if (inputStream != null) {
                            Logger logger = LogManager.getConfigLogger();
                            try {
                                logger.info("Import Servlet Configuration: " + string2);
                                if (ConfigurationManager.isWriteable(n3)) {
                                    ((ConfigurationManager)object).importFromStream(n3, string2, inputStream);
                                } else {
                                    logger.error("Could not create specified configuration in non writable scope '" + ConfigurationManager.getScopeName(n3) + "': " + string2);
                                }
                            }
                            catch (Throwable throwable) {
                                logger.error("Could not create specified configuration: " + string2);
                            }
                            finally {
                                inputStream.close();
                            }
                            configuration = ((ConfigurationManager)object).get(n3, string2);
                        }
                        if (configuration == null) {
                            configuration = ((ConfigurationManager)object).create(n3, string2);
                        }
                    }
                    ((ConfigurationManager)object).setCurrent(configuration);
                    LogManager.getConfigLogger().info("Using the configuration :" + ConfigurationManager.getScopeName(configuration.getScope()) + "/" + configuration.getName());
                    return;
                }
                catch (Exception exception) {
                    Logger logger = LogManager.getConfigLogger();
                    logger.error("Problem in setting the configuration.");
                    logger.error(exception);
                }
            }
        }
        if ((object = servletContext.getInitParameter("clearreports.configfile")) != null && ((String)object).length() > 0) {
            LogManager.getConfigLogger().info("Using properties file for the configuration :" + (String)object);
            ConfigurationManager configurationManager = ConfigurationManager.getInstance();
            URL uRL = IOFunctions.getURLFromString((String)object);
            if (uRL != null) {
                try {
                    LogManager.getConfigLogger().info("manually importing " + (String)object + " and using as configuration...");
                    InputStream inputStream = uRL.openStream();
                    String string = "<imported config>";
                    configurationManager.importFromStream(4, "<imported config>", inputStream);
                    Configuration configuration = configurationManager.get(4, "<imported config>");
                    configurationManager.setCurrent(configuration);
                }
                catch (IOException | SecurityException exception) {
                    LogManager.getConfigLogger().error(exception);
                }
            } else {
                LogManager.getConfigLogger().warn("could not find properties file at location given: " + (String)object);
            }
        }
    }

    public static void setContentDisposition(@Nonnull HttpServletResponse response, @Nonnull String fileName, boolean inline) {
        Object object = inline ? "inline" : "attachment";
        String string = EncodingFunctions.encodeHttpHeader(fileName, false);
        object = (String)object + ";filename=\"" + string + "\"";
        String string2 = EncodingFunctions.encodeHttpHeader(fileName, true);
        if (fileName != string2) {
            object = (String)object + ";filename*=UTF-8''" + string2;
        }
        response.setHeader("Content-Disposition", (String)object);
        if (!inline) {
            Cookie cookie = new Cookie("i-net-content-download", "true");
            cookie.setPath("/");
            response.addCookie(cookie);
        }
    }

    public static void asyncSendStaticContent(File file, @Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nullable Runnable onSuccess, @Nullable Consumer<Throwable> onError) throws IOException {
        if (file == null) {
            ServletUtils.sendFileNotExist(request, response);
            if (onSuccess != null) {
                onSuccess.run();
            }
            return;
        }
        String string = MimeTypes.getMimeType(file.getName());
        if ("HEAD".equals(request.getMethod())) {
            if (file.exists()) {
                ServletUtils.sendStaticContent(string, file.lastModified(), file.length(), null, request, response);
            } else {
                ServletUtils.sendFileNotExist(request, response);
            }
            if (onSuccess != null) {
                onSuccess.run();
            }
        } else {
            FileInputStream fileInputStream;
            try {
                fileInputStream = new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                ServletUtils.sendFileNotExist(request, response);
                if (onError != null) {
                    onError.accept(fileNotFoundException);
                }
                return;
            }
            ServletUtils.asyncSendStaticContent(string, file.lastModified(), file.length(), fileInputStream, request, response, onSuccess, onError);
        }
    }

    public static void asyncSendStaticContent(String mimeType, long lastModifiedMillis, long contentLength, @Nonnull InputStream input, @Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nullable Runnable onSuccess, @Nullable Consumer<Throwable> onError) throws IOException {
        if (mimeType != null) {
            response.setContentType(mimeType);
        }
        if (ServletUtils.checkLastModified(request, response, lastModifiedMillis)) {
            if (onSuccess != null) {
                onSuccess.run();
            }
            return;
        }
        if (contentLength > 0L) {
            response.setContentLengthLong(contentLength);
        }
        if ("HEAD".equals(request.getMethod())) {
            if (onSuccess != null) {
                onSuccess.run();
            }
            return;
        }
        new AsyncResponseWriter(input, request, response, onSuccess, onError);
    }

    public static int getContextPathLength(@Nonnull HttpServletRequest request) {
        String string = request.getContextPath();
        int n2 = string.length();
        HttpServletMapping httpServletMapping = request.getHttpServletMapping();
        String string2 = httpServletMapping.getPattern();
        if (string2.endsWith("/*")) {
            n2 += string2.length() - 2;
        }
        return n2;
    }

    public static void setExpirationHeader(HttpServletResponse response, long cacheTime) {
        if (cacheTime == 0L) {
            response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
            response.setHeader("Pragma", "no-cache");
            response.setHeader(EXPIRES, "0");
            return;
        }
        SimpleDateFormat simpleDateFormat = ServletUtils.getFormatter();
        response.setHeader(EXPIRES, simpleDateFormat.format(new Date(System.currentTimeMillis() + cacheTime)));
    }

    static {
        b = new ThreadLocal();
        c = new String[]{"RequestPage", "context", "application_context", "http_server_port", "http_server"};
    }
}

