/*
 * Decompiled with CFR 0.152.
 */
package com.inet.search.command;

import com.inet.annotations.InternalApi;
import com.inet.search.SearchDataType;
import com.inet.search.SearchTag;
import com.inet.search.command.ConditionTokenMatcher;
import com.inet.search.command.JoinSearchCondition;
import com.inet.search.command.PhraseSearchExpression;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.command.TextSearchCommandBuilder;
import com.inet.search.command.TokenMatcher;
import com.inet.search.index.IndexSearchEngine;
import com.inet.search.index.SuggestedTag;
import com.inet.search.index.TagIndex;
import com.inet.search.tokenizers.SearchTokenizer;
import com.inet.search.tokenizers.TextSearchTokenizerWithoutNormalize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class JoinTokenMatcher<ID>
implements ConditionTokenMatcher<ID> {
    private final IndexSearchEngine<ID> a;
    @Nonnull
    private final SearchTag b;
    @Nonnull
    private final SearchTag c;
    private final IndexSearchEngine<ID> d;
    private final boolean e;
    private final int f;

    @Deprecated
    public JoinTokenMatcher(IndexSearchEngine<ID> parentSearchEngine, @Nonnull SearchTag parentSearchTag, IndexSearchEngine<ID> searchEngine, @Nonnull SearchTag searchTag, boolean isUsedForFreeSearch) {
        this(parentSearchEngine, parentSearchTag, searchEngine, searchTag, isUsedForFreeSearch, parentSearchTag.getPriority());
    }

    public JoinTokenMatcher(IndexSearchEngine<ID> parentSearchEngine, @Nonnull SearchTag parentSearchTag, IndexSearchEngine<ID> searchEngine, @Nonnull SearchTag searchTag, boolean isUsedForFreeSearch, int priority) {
        this.a = parentSearchEngine;
        this.b = parentSearchTag;
        this.d = searchEngine;
        this.c = searchTag;
        this.e = isUsedForFreeSearch;
        this.f = priority;
    }

    public static void addToIndex(@Nonnull IndexSearchEngine<?> parentSearchEngine, @Nonnull String parentTag, IndexSearchEngine<?> childSearchEngine, Collection<String> childTags, boolean isUsedForFreeSearch) {
        SearchTag searchTag = Objects.requireNonNull(parentSearchEngine.getTag(parentTag));
        int n2 = Integer.MIN_VALUE;
        int n3 = Integer.MAX_VALUE;
        for (SearchTag object : childSearchEngine.getTags()) {
            if (!childTags.contains(object.getTag())) continue;
            n2 = Math.max(n2, object.getPriority());
            n3 = Math.min(n3, object.getPriority());
        }
        int n4 = Math.max(1, (n2 - n3) / 10);
        for (SearchTag searchTag2 : childSearchEngine.getTags()) {
            if (!childTags.contains(searchTag2.getTag())) continue;
            int n5 = searchTag.getPriority() + (searchTag2.getPriority() - n2) / n4;
            parentSearchEngine.addTokenMatcher(new JoinTokenMatcher(parentSearchEngine, searchTag, childSearchEngine, searchTag2, isUsedForFreeSearch, n5));
        }
    }

    public static <ID> void removeFromIndex(@Nonnull IndexSearchEngine<ID> parentSearchEngine, @Nonnull String parentTag, Collection<String> childTags) {
        List<TokenMatcher<ID>> list = parentSearchEngine.getTokenMatcher();
        if (list == null) {
            return;
        }
        list = new ArrayList<TokenMatcher<ID>>(list);
        block0: for (TokenMatcher<ID> tokenMatcher : list) {
            if (!(tokenMatcher instanceof JoinTokenMatcher)) continue;
            String string = tokenMatcher.getTag();
            for (String string2 : childTags) {
                if (!string.equals(JoinTokenMatcher.a(string2, parentTag))) continue;
                parentSearchEngine.removeTokenMatcher(tokenMatcher);
                continue block0;
            }
        }
    }

    @Nonnull
    private static String a(String string, String string2) {
        return string + "-" + string2;
    }

    @Override
    @Nonnull
    public String getTag() {
        return JoinTokenMatcher.a(this.c.getTag(), this.b.getTag());
    }

    @Override
    public int getPriority() {
        return this.f;
    }

    @Override
    @Nonnull
    public String getDisplayName() {
        return this.c.getDisplayName() + " (" + this.b.getDisplayName() + ")";
    }

    @Override
    @Nonnull
    public SearchExpression createSearchExpression(@Nonnull String searchPhrase, @Nonnull SearchCondition.SearchTermOperator operator, boolean quote, boolean useGenericLocale) {
        return this.a(searchPhrase, operator, quote, this.c, useGenericLocale);
    }

    @Nonnull
    private SearchExpression a(final @Nonnull String string, @Nonnull SearchCondition.SearchTermOperator searchTermOperator, final boolean bl, @Nullable SearchTag searchTag, boolean bl2) {
        String string2;
        SearchCommand searchCommand = new SearchCommand(new SearchExpression[0]);
        String string3 = string2 = searchTag != null ? searchTag.getTag() : null;
        if (bl) {
            SearchDataType searchDataType = searchTag != null ? searchTag.getDataType() : SearchDataType.String;
            switch (searchDataType) {
                case IntegerMap: 
                case StringMap: {
                    searchCommand.getSearchExpression().add(new SearchCondition(string2, searchTermOperator, string, !bl2));
                    break;
                }
                default: {
                    SearchTokenizer searchTokenizer;
                    SearchTokenizer searchTokenizer2 = searchTokenizer = searchTag != null ? searchTag.getTokenizer() : null;
                    if (searchTokenizer == null) {
                        searchTokenizer = TextSearchTokenizerWithoutNormalize.DEFAULT;
                    }
                    HashSet<String> hashSet = new HashSet<String>();
                    for (String string4 : string.split("\\s")) {
                        hashSet.addAll(searchTokenizer.tokens(string4, 1));
                    }
                    try {
                        searchCommand.getSearchExpression().add(new PhraseSearchExpression(string2, searchTermOperator, string, hashSet));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                    break;
                }
            }
        } else {
            try {
                Object object = string;
                if (searchTag != null) {
                    switch (searchTag.getDataType()) {
                        case IntegerMap: 
                        case StringMap: {
                            break;
                        }
                        default: {
                            object = TagIndex.convertToken(object, searchTag);
                        }
                    }
                }
                searchCommand.getSearchExpression().add(new SearchCondition(string2, searchTermOperator, object, !bl2));
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return new JoinSearchCondition(this.b.getTag(), this.d, searchCommand){

            @Override
            public void toPhrase(@Nonnull StringBuilder phraseBuilder, @Nonnull IndexSearchEngine<?> searchEngine, boolean toGenericLocale) {
                String string2 = toGenericLocale ? JoinTokenMatcher.this.getTag() : JoinTokenMatcher.this.getDisplayName();
                phraseBuilder.append(TextSearchCommandBuilder.normalizedTagDisplayName(string2));
                phraseBuilder.append(':');
                if (bl) {
                    char c2 = string.indexOf(34) < 0 ? (char)'\"' : '\'';
                    phraseBuilder.append(c2).append(string).append(c2);
                } else {
                    phraseBuilder.append(string);
                }
            }
        };
    }

    SearchExpression a(@Nonnull String string, @Nonnull SearchCondition.SearchTermOperator searchTermOperator, boolean bl) {
        if (string.isEmpty()) {
            if (bl) {
                return new PhraseSearchExpression(this.b.getTag(), searchTermOperator, "", Collections.emptySet());
            }
            return new SearchCondition(this.b.getTag(), SearchCondition.SearchTermOperator.StartsWith, "", true);
        }
        return this.a(string, searchTermOperator, bl, null, false);
    }

    @Override
    public boolean isSuggestedTag() {
        return this.c.isSuggestedTag();
    }

    @Override
    public boolean isUsedForFreeSearch() {
        return this.e;
    }

    @Override
    @Nonnull
    public Iterator<String> createDisplayValuesIterator(String startsWith, Predicate<ID> filter) {
        if (filter != IndexSearchEngine.MATCH_ALL) {
            HashSet hashSet = new HashSet();
            Iterator iterator = this.a.createEntryIterator(this.b, true);
            block0: while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                for (ID ID : entry.getValue()) {
                    if (!filter.test(ID)) continue;
                    hashSet.add(entry.getKey());
                    continue block0;
                }
            }
            if (hashSet.isEmpty()) {
                return Collections.emptyIterator();
            }
            filter = object -> hashSet.contains(TagIndex.convertToken(object, this.b));
        }
        return this.d.createDisplayValuesIterator(this.c, startsWith, (Predicate<ID>)filter);
    }

    public boolean useTwoStage() {
        return true;
    }

    public SuggestedTag getParentSuggestedTag() {
        return this.b;
    }

    public SuggestedTag getChildSuggestedTag() {
        return this.c;
    }

    @Nonnull
    public IndexSearchEngine<ID> getChildSearchEngine() {
        return this.d;
    }
}

