/*
 * Decompiled with CFR 0.152.
 */
package com.inet.plugin;

import com.inet.annotations.InternalApi;
import com.inet.classloader.I18nMessages;
import com.inet.classloader.LoaderUtils;
import com.inet.config.structure.provider.AbstractStructureProvider;
import com.inet.error.ErrorCode;
import com.inet.lib.io.FastBufferedOutputStream;
import com.inet.lib.util.DebugUtils;
import com.inet.lib.util.IOFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.plugin.DependencyClassLoader;
import com.inet.plugin.PluginInfo;
import com.inet.plugin.ServerPlugin;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.fs.ArchiveFile;
import com.inet.plugin.fs.ResourceFile;
import com.inet.shared.utils.Version;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.ZipEntry;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

@InternalApi
public class ServerPluginDescription {
    public static final I18nMessages PLUGIN_CATEGORIES_MSG = new I18nMessages("com.inet.plugin.i18n.PluginCategories", ServerPluginDescription.class);
    private static final ConcurrentHashMap<String, FileLock> a = new ConcurrentHashMap(200);
    private final Properties b;
    private final ResourceFile c;
    private final String d;
    private final String e;
    private Version f;
    private ClassLoader g;
    private Map<String, String> h;
    private Map<String, String> i;
    private List<String> j;
    private final List<String> k;
    private final String l;
    private String[] m;
    private ServerPlugin n;
    private final File o;
    private URL p;

    public ServerPluginDescription(Properties props, ResourceFile location, File tempDir, @Nonnull Logger logger) throws ClassNotFoundException {
        this(props, location, tempDir, null, logger);
    }

    private ServerPluginDescription(Properties props, ResourceFile location, File tempDir, ClassLoader loader, @Nonnull Logger logger) throws ClassNotFoundException {
        this.b = props;
        this.c = location;
        this.o = tempDir;
        String string = props.getProperty("entrypoint");
        if (string == null) {
            throw new ClassNotFoundException("no entry point class specified");
        }
        this.d = props.getProperty("id");
        if (this.d == null) {
            throw new IllegalArgumentException("no id property!");
        }
        this.e = props.getProperty("version", "0");
        this.h = ServerPluginDescription.a(props, "dependencies");
        this.i = ServerPluginDescription.a(props, "optionalDependencies");
        this.j = new ArrayList<String>(ServerPluginDescription.a(props, "initAfter").keySet());
        this.k = new ArrayList<String>(ServerPluginDescription.a(props, "flags").keySet());
        this.l = props.getProperty("group", "");
        String string2 = props.getProperty("packages", "");
        if (string2.trim().length() > 0) {
            this.m = string2.split("\\s*;\\s*");
        }
        if (loader != null) {
            this.g = "inetcore".equals(this.d) ? new DependencyClassLoader(new URL[0], loader, "inetcore", true) : loader;
            String string3 = props.getProperty("internal");
            if (string3 != null && !string3.isEmpty() && location != null) {
                URL[] uRLArray;
                for (URL uRL : uRLArray = this.c(logger).getURLs()) {
                    String string4 = uRL.getPath();
                    if (string4.contains("/" + this.d + "server")) continue;
                    try {
                        Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                        method.setAccessible(true);
                        method.invoke((Object)loader, uRL);
                        LogManager.getConfigLogger().debug("jar injected: " + String.valueOf(uRL));
                    }
                    catch (Throwable throwable) {
                        LogManager.getConfigLogger().error(throwable);
                    }
                }
            }
        }
    }

    @Nonnull
    private static Map<String, String> a(Properties properties, String string) {
        String string2 = properties.getProperty(string, "");
        if (string2.length() > 0) {
            String[] stringArray = string2.split("\\s*;\\s*");
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String[] stringArray2 = stringArray[i2].split("\\s*,\\s*");
                if (stringArray2.length == 1) {
                    linkedHashMap.put(stringArray2[0], null);
                    continue;
                }
                linkedHashMap.put(stringArray2[0], stringArray2[1]);
            }
            return linkedHashMap;
        }
        return Collections.emptyMap();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static ServerPluginDescription create(ResourceFile location, File tempDir, @Nonnull Logger logger) {
        block11: {
            try (ArchiveFile archiveFile = location.createArchiveFile();){
                ZipEntry zipEntry = archiveFile.getEntry("plugin.properties");
                if (zipEntry == null) break block11;
                Properties properties = new Properties();
                try {
                    properties.load(archiveFile.getInputStream(zipEntry));
                    ServerPluginDescription serverPluginDescription = new ServerPluginDescription(properties, location, tempDir, logger);
                    logger.info("Found plugin file: " + archiveFile.getName() + " with version " + serverPluginDescription.getVersionString());
                    ServerPluginDescription serverPluginDescription2 = serverPluginDescription;
                    return serverPluginDescription2;
                }
                catch (Throwable throwable) {
                    logger.error("Failed to load plugin file: " + archiveFile.getName());
                    logger.error(throwable);
                }
            }
            catch (IOException iOException) {
                logger.error(iOException);
            }
        }
        return null;
    }

    public static ServerPluginDescription create(ServerPlugin serverPlugin, ClassLoader loader) throws Exception {
        return ServerPluginDescription.create(serverPlugin, null, null, loader, LogManager.getConfigLogger());
    }

    public static ServerPluginDescription create(ServerPlugin serverPlugin, ResourceFile location, File tempDir, ClassLoader loader, @Nonnull Logger logger) throws Exception {
        Method[] methodArray;
        Properties properties = new Properties();
        Class<?> clazz = serverPlugin.getClass();
        PluginInfo pluginInfo = clazz.getAnnotation(PluginInfo.class);
        if (pluginInfo == null) {
            throw new IllegalStateException("The Class '" + String.valueOf(clazz) + "' has no PluginInfo annoation!");
        }
        for (Method method : methodArray = PluginInfo.class.getDeclaredMethods()) {
            Object object = method.invoke((Object)pluginInfo, new Object[0]);
            if (object == null) continue;
            properties.put(method.getName(), object);
        }
        properties.put("entrypoint", clazz.getName());
        if (loader == null) {
            loader = clazz.getClassLoader();
        }
        ServerPluginDescription serverPluginDescription = new ServerPluginDescription(properties, location, tempDir, loader, logger);
        serverPluginDescription.n = serverPlugin;
        return serverPluginDescription;
    }

    @Nonnull
    public static ServerPluginDescription create(@Nonnull ServerPluginDescription original, @Nonnull String version) {
        try {
            Properties properties = new Properties(original.b);
            properties.put("version", version);
            ServerPluginDescription serverPluginDescription = new ServerPluginDescription(properties, original.c, original.o, null, LogManager.getConfigLogger());
            serverPluginDescription.g = original.g;
            return serverPluginDescription;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw (RuntimeException)ErrorCode.throwAny(classNotFoundException);
        }
    }

    @Nonnull
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="No user input is used")
    List<URL> a(@Nonnull Logger logger) throws IOException {
        String[] stringArray;
        Object object;
        Object object2;
        ArrayList<URL> arrayList = new ArrayList<URL>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        String string = System.getProperty(this.d + ".classpath");
        if (string != null) {
            string = string.replace('\\', '/');
            object2 = new StringTokenizer(string, ";");
            while (((StringTokenizer)object2).hasMoreElements()) {
                object = ((StringTokenizer)object2).nextToken();
                if (!((String)object).endsWith("/") && !((String)object).endsWith(".jar")) {
                    object = (String)object + "/";
                }
                arrayList.add(IOFunctions.getFileURL((String)object));
            }
            arrayList2.add("    ");
        } else {
            arrayList2.add(this.d + ".jar");
            arrayList2.add("server.jar");
        }
        object2 = this.b.getProperty("internal");
        if (object2 != null) {
            object = ((String)object2).split(";");
            stringArray = object;
            int n2 = stringArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                String string2 = stringArray[i2];
                if ((string2 = string2.trim()).isEmpty()) continue;
                arrayList2.add(string2);
                arrayList3.add(string2);
            }
        }
        if (new HashSet(arrayList2).size() != arrayList2.size()) {
            logger.warn("plugin " + this.d + ": jar dependencies contain duplicates!");
        }
        this.a(arrayList2, arrayList);
        object = this.b.getProperty("external");
        if (object != null) {
            for (String string3 : stringArray = ((String)object).split(";")) {
                if ((string3 = string3.trim()).isEmpty()) continue;
                File file = new File(string3);
                if (!file.exists()) {
                    logger.error("warning: external jar file could not be found: " + string3 + " for plugin " + this.d);
                    continue;
                }
                arrayList.add(file.toURI().toURL());
                arrayList3.add(file.getName());
            }
        }
        if (logger.isDebug() && arrayList3.size() > 0) {
            logger.debug("  Additional Jars for '" + this.d + "': " + Arrays.toString(arrayList3.toArray(new String[0])));
        }
        return arrayList;
    }

    private DependencyClassLoader c(@Nonnull Logger logger) throws ClassNotFoundException {
        try {
            List<URL> list = this.a(logger);
            DependencyClassLoader dependencyClassLoader = new DependencyClassLoader(list.toArray(new URL[list.size()]), this.d, true);
            ClassLoader classLoader = this.getClass().getClassLoader();
            if (classLoader == null) {
                classLoader = ClassLoader.getSystemClassLoader();
            }
            dependencyClassLoader.addClassLoader("com.inet.annotations", classLoader);
            dependencyClassLoader.addClassLoader("com.inet.authentication", classLoader);
            dependencyClassLoader.addClassLoader("com.inet.cache", classLoader);
            dependencyClassLoader.addClassLoader("com.inet.classloader", classLoader);
            dependencyClassLoader.addClassLoader("com.inet.config", classLoader);
            dependencyClassLoader.addClassLoader("com.inet.error", classLoader);
            dependencyClassLoader.addClassLoader("com.inet.field", classLoader);
            dependencyClassLoader.addClassLoader("com.inet.file", classLoader);
            dependencyClassLoader.addClassLoader("com.inet.font", classLoader);
            dependencyClassLoader.addClassLoader("com.inet.globalbanner", classLoader);
            dependencyClassLoader.addClassLoader("com.inet.graphics", classLoader);
            dependencyClassLoader.addClassLoader("com.inet.http", classLoader);
            dependencyClassLoader.addClassLoader("com.inet.id", classLoader);
            dependencyClassLoader.addClassLoader("com.inet.lib", classLoader);
            dependencyClassLoader.addClassLoader("com.inet.logging", classLoader);
            dependencyClassLoader.addClassLoader("com.inet.mail", classLoader);
            dependencyClassLoader.addClassLoader("com.inet.mdns", classLoader);
            dependencyClassLoader.addClassLoader("com.inet.notification", classLoader);
            dependencyClassLoader.addClassLoader("com.inet.permissions", classLoader);
            dependencyClassLoader.addClassLoader("com.inet.persistence", classLoader);
            dependencyClassLoader.addClassLoader("com.inet.plugin", classLoader);
            dependencyClassLoader.addClassLoader("com.inet.process", classLoader);
            dependencyClassLoader.addClassLoader("com.inet.search", classLoader);
            dependencyClassLoader.addClassLoader("com.inet.shared", classLoader);
            dependencyClassLoader.addClassLoader("com.inet.thread", classLoader);
            dependencyClassLoader.addClassLoader("com.inet.usersandgroups", classLoader);
            if (System.getProperty("DEBUG_LOCAL_CLASSPATH") != null) {
                dependencyClassLoader.addClassLoader("com", classLoader);
            }
            dependencyClassLoader.addClassLoader("jakarta.servlet", classLoader);
            dependencyClassLoader.addClassLoader("jakarta.websocket", classLoader);
            dependencyClassLoader.addClassLoader("org.apache.commons.logging", classLoader);
            dependencyClassLoader.addClassLoader("org.slf4j", classLoader);
            dependencyClassLoader.addClassLoader("org.slf4j.spi", classLoader);
            dependencyClassLoader.addClassLoader("net.sourceforge.cobertura", classLoader);
            dependencyClassLoader.addClassLoader("com.vladium", classLoader);
            dependencyClassLoader.addClassLoader("com.vladium.emma.rt", classLoader);
            dependencyClassLoader.addClassLoader("com.vladium.emma", classLoader);
            if (this.k.contains("rootAccess")) {
                dependencyClassLoader.addClassLoader("", classLoader);
            }
            if (this.m != null) {
                for (String string : this.m) {
                    dependencyClassLoader.addClassLoader(string, dependencyClassLoader);
                }
            }
            return dependencyClassLoader;
        }
        catch (IOException iOException) {
            ClassNotFoundException classNotFoundException = new ClassNotFoundException("Classloader couldn't be created", iOException);
            throw classNotFoundException;
        }
    }

    private void a(ArrayList<String> arrayList, ArrayList<URL> arrayList2) throws IOException {
        try (ArchiveFile archiveFile = this.c.createArchiveFile();){
            while (arrayList.size() > 1) {
                ZipEntry zipEntry = archiveFile.getNextEntry();
                if (zipEntry == null) {
                    throw new IOException("no " + String.valueOf(arrayList) + " in " + this.c.getPath());
                }
                String string = zipEntry.getName();
                if (!arrayList.remove(string)) continue;
                arrayList2.add(this.a(archiveFile, zipEntry));
            }
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="No user input is used")
    private URL a(ArchiveFile archiveFile, ZipEntry zipEntry) throws IOException {
        String string2;
        String string3 = string2 = zipEntry.getName();
        if (string2.toLowerCase().endsWith(".jar")) {
            string3 = string2.substring(0, string2.length() - 4);
        }
        File file = this.o != null ? this.o : new File(System.getProperty("java.io.tmpdir"));
        String string4 = string3 + "-" + zipEntry.getTime() + "-" + zipEntry.getSize() + ".jar";
        File file2 = new File(file, string4);
        try {
            if (file2.exists() && file2.length() == zipEntry.getSize()) {
                file2.setLastModified(System.currentTimeMillis());
            } else {
                InputStream inputStream = archiveFile.getInputStream(zipEntry);
                FastBufferedOutputStream fastBufferedOutputStream = new FastBufferedOutputStream(new FileOutputStream(file2), 32768);
                IOFunctions.copyData(inputStream, fastBufferedOutputStream);
                fastBufferedOutputStream.close();
            }
            a.computeIfAbsent(string4, string -> {
                try {
                    FileChannel fileChannel = new RandomAccessFile(file2, "rw").getChannel();
                    return fileChannel.lock(0L, 0L, true);
                }
                catch (IOException iOException) {
                    throw (RuntimeException)ErrorCode.throwAny(iOException);
                }
            });
            return file2.toURI().toURL();
        }
        catch (IOException iOException) {
            iOException.addSuppressed(new IOException(String.valueOf(file2) + ", exists: " + file2.exists() + ", length: " + file2.length()));
            throw iOException;
        }
    }

    public String getId() {
        return this.d;
    }

    @Nonnull
    public Version getVersion() {
        if (this.f == null) {
            this.f = new Version(this.e);
        }
        return this.f;
    }

    protected void loadServerPlugin() throws ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalStateException {
        if (this.n == null) {
            String string = this.b.getProperty("entrypoint");
            Class<?> clazz = this.getClassLoader().loadClass(string);
            Object obj = clazz.newInstance();
            PluginInfo pluginInfo = obj.getClass().getAnnotation(PluginInfo.class);
            if (DebugUtils.DEBUG && pluginInfo != null) {
                Version version = this.getVersion();
                Version version2 = new Version(pluginInfo.version());
                if (version.getMajor() != version2.getMajor() || version.getMinor() != version2.getMinor()) {
                    throw new IllegalStateException("Plugin declaration '" + pluginInfo.id() + "' version (" + this.getVersionString() + ") is different to its implemented version (" + pluginInfo.version() + ")");
                }
            }
            this.n = (ServerPlugin)obj;
        }
    }

    public ServerPlugin getServerPlugin() {
        return this.n;
    }

    @Nonnull
    public Set<String> getDependencyIds() {
        return this.h.keySet();
    }

    @Nullable
    public String getDependencyVersion(String dependency) {
        return this.h.get(dependency);
    }

    @Nonnull
    public Set<String> getOptionalDependencyIds() {
        return this.i.keySet();
    }

    public List<String> getPreInitIds() {
        return this.j;
    }

    @Nonnull
    public List<String> getFlags() {
        return this.k;
    }

    @Nonnull
    public String getGroup() {
        return this.l;
    }

    public String getDisplayName(String key, Locale locale) {
        ResourceBundle resourceBundle = null;
        try {
            Object object = this.b.getProperty("entrypoint");
            int n2 = ((String)object).lastIndexOf(46);
            object = ((String)object).substring(0, n2 + 1) + "structure.i18n.ConfigStructure";
            resourceBundle = LoaderUtils.getBundle((String)object, locale, this.getClassLoader());
            return resourceBundle.getString("plugin." + key);
        }
        catch (MissingResourceException missingResourceException) {
            String string;
            switch (key) {
                case "group": {
                    string = this.l;
                    break;
                }
                case "id": {
                    string = this.d;
                    break;
                }
                case "description": {
                    String string2 = this.b.getProperty("description_" + locale.getLanguage());
                    if (string2 == null) {
                        string2 = this.b.getProperty("description");
                    }
                    return string2;
                }
                default: {
                    return null;
                }
            }
            if (StringFunctions.isEmpty(string)) {
                return string;
            }
            return Character.toUpperCase(string.charAt(0)) + string.substring(1);
        }
    }

    public URL getIcon() {
        Object object;
        URL uRL = this.p;
        if (uRL != null) {
            return uRL;
        }
        if ("inetcore".equals(this.d)) {
            if (!AbstractStructureProvider.isDesigner()) {
                this.p = LoaderUtils.getResource("com/inet/plugin/image/enterprise.svg", this.getClassLoader());
            }
            if (this.p == null) {
                this.p = LoaderUtils.getResource("com/inet/plugin/image/enterprise_48.png", this.getClassLoader());
            }
            if (this.p != null) {
                return this.p;
            }
        }
        try {
            if (!AbstractStructureProvider.isDesigner() && (object = ServerPluginManager.getInstance().getPluginFile(this.d, "plugin.properties.d/icon.svg")) != null) {
                InputStream inputStream = object.getInputStream();
                this.p = IOFunctions.getDataUrl("image/svg+xml", IOFunctions.readBytes(inputStream));
                return this.p;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        object = this.b.getProperty("icon");
        if (object != null && ((String)object).length() > 0) {
            uRL = LoaderUtils.getResource((String)object, this.getClassLoader());
        }
        if (uRL == null) {
            uRL = LoaderUtils.getResource("icon.png", this.getClassLoader());
        }
        this.p = uRL;
        return this.p;
    }

    public ClassLoader getClassLoader() {
        if (this.g == null) {
            this.b(LogManager.getConfigLogger());
        }
        return this.g;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void b(@Nonnull Logger logger) {
        ServerPluginDescription serverPluginDescription = this;
        synchronized (serverPluginDescription) {
            if (this.g == null) {
                try {
                    this.g = this.c(logger);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.g = ClassLoader.getSystemClassLoader();
                    logger.error(classNotFoundException);
                }
            }
        }
    }

    public void addDependency(String packageName, ClassLoader cl) {
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader instanceof DependencyClassLoader) {
            ((DependencyClassLoader)classLoader).addClassLoader(packageName, cl);
        }
    }

    public String[] getPackages() {
        return this.m;
    }

    public ResourceFile getLocation() {
        return this.c;
    }

    public void setServerPlugin(ServerPlugin serverPlugin) {
        this.n = serverPlugin;
    }

    @Nonnull
    public String getDescription(Locale locale) {
        return this.getDisplayName("description", locale);
    }

    @Nonnull
    public String getVersionString() {
        return this.e;
    }
}

