/*
 * Decompiled with CFR 0.152.
 */
package com.inet.field.fieldtypes;

import com.inet.field.fieldtypes.FieldOperator;
import com.inet.field.fieldtypes.FieldType;
import com.inet.field.fieldtypes.FieldTypeFactory;
import com.inet.lib.util.StringFunctions;
import com.inet.search.SearchDataType;
import com.inet.search.SearchTag;
import com.inet.search.tokenizers.TextSearchTokenizer;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FieldTypeTime
extends FieldType<String> {
    public FieldTypeTime(String key, Supplier<String> displayname) {
        super(key, displayname);
    }

    @Override
    @Nullable
    public String getDisplayValue(@Nullable String value) {
        return StringFunctions.stringValueOf(value);
    }

    @Override
    public SearchTag createSearchTag(Supplier<String> labelProvider, @Nonnull FieldTypeFactory fieldTypeFactory) {
        return fieldTypeFactory.applyConfiguredChangesToSearchTag(new SearchTag(this.getKey(), SearchDataType.String, true, TextSearchTokenizer.DEFAULT, 100, labelProvider, true));
    }

    public static String fromDurationMs(long millis) {
        if (millis >= 86400000L || millis < 0L) {
            throw new IllegalArgumentException(String.valueOf(millis) + " seems to represent a date, can only pass time duration from 0 to 24h.");
        }
        long l2 = millis / 3600000L;
        long l3 = millis % 3600000L / 60000L;
        return new DecimalFormat("00").format(l2) + ":" + new DecimalFormat("00").format(l3);
    }

    public static String fromMillisSince1970(long millis) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm");
        Date date = new Date(millis);
        return simpleDateFormat.format(date);
    }

    public static FieldTypeTime withoutSearchtag(String key) {
        return new FieldTypeTime(key, () -> null){

            @Override
            public SearchTag createSearchTag(Supplier<String> displayname, FieldTypeFactory fieldTypeFactory) {
                return null;
            }
        };
    }

    @Override
    @Nullable
    public String valueOf(@Nullable String value) {
        return value;
    }

    @Override
    public Set<FieldOperator> getSupportedOperators() {
        return Set.of(FieldOperator.EQUALS, FieldOperator.EQUALS_NOT, FieldOperator.LESS_THAN, FieldOperator.GREATER_THAN, FieldOperator.GREATER_OR_EQUAL, FieldOperator.LESS_OR_EQUAL, FieldOperator.IS_NOT_EMPTY);
    }
}

