/*
 * Decompiled with CFR 0.152.
 */
package com.inet.config.migrator;

import com.inet.config.ConfigKey;
import com.inet.config.Configuration;
import com.inet.config.ConfigurationMigrator;
import com.inet.lib.json.Json;
import com.inet.logging.LogManager;
import java.util.HashMap;
import java.util.Map;

public class SchedulerConfigurationMigrator
implements ConfigurationMigrator {
    @Override
    public void migrate(Configuration config) {
        String string = config.get(ConfigKey.PLUGINS_ACTIVATED.getKey());
        if (string != null && string.contains("scheduler") && !string.contains("taskplanner")) {
            Map<String, Boolean> map;
            try {
                map = new Json().fromJson(string, Map.class);
            }
            catch (RuntimeException runtimeException) {
                map = new HashMap();
                LogManager.getConfigLogger().error(runtimeException);
            }
            if (!Boolean.TRUE.equals(map.get("scheduler")) || map.get("taskplanner") != null) {
                return;
            }
            map.put("taskplanner", Boolean.TRUE);
            map.put("taskplanner.reporting", Boolean.TRUE);
            string = new Json().toJson(map);
            config.put(ConfigKey.PLUGINS_ACTIVATED.getKey(), string);
            LogManager.getConfigLogger().info("Migrate scheduler plugin: " + string);
        }
    }
}

