/*
 * Decompiled with CFR 0.152.
 */
package com.inet.odbc;

import com.inet.odbc.AbstractOdbcResultSet;
import com.inet.odbc.ColumnDescription;
import com.inet.odbc.OdbcLibrary;
import com.inet.odbc.OdbcStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;

class OdbcResultSet
extends AbstractOdbcResultSet
implements ResultSet {
    private int row;
    private Object[] rowDataCache;
    private boolean closeStmtOnClose;

    OdbcResultSet(OdbcStatement stmt, int columnCount) {
        super(stmt, columnCount);
        this.rowDataCache = new Object[columnCount];
    }

    OdbcResultSet(OdbcStatement stmt) throws SQLException {
        this(stmt, stmt.getColumnCount());
        this.closeStmtOnClose = true;
    }

    @Override
    public void close() throws SQLException {
        super.close();
        if (this.closeStmtOnClose) {
            this.getStatement().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean next() throws SQLException {
        this.checkOpen();
        Object object = this.getStatement().getConnection().getLock();
        synchronized (object) {
            this.clearWarnings();
            Arrays.fill(this.rowDataCache, this);
            short ret = OdbcLibrary.ODBC.SQLFetch(this.getStatement().getHStmt());
            switch (ret) {
                case 0: {
                    ++this.row;
                    return true;
                }
                case 100: {
                    this.row = 0;
                    return false;
                }
            }
            this.checkSqlReturn(ret);
            return false;
        }
    }

    @Override
    public int getRow() throws SQLException {
        return this.row;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.checkOpen();
        ColumnDescription column = this.getMetaData().getColumn(columnIndex);
        if (this.rowDataCache[columnIndex - 1] != this) {
            return this.rowDataCache[columnIndex - 1];
        }
        Object object = this.getData(column);
        this.rowDataCache[columnIndex - 1] = object;
        return object;
    }
}

