/*
 * Decompiled with CFR 0.152.
 */
package com.inet.odbc;

import com.inet.odbc.BytesByReference;
import com.inet.odbc.OdbcUtils;
import com.sun.jna.Library;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.Structure;
import com.sun.jna.ptr.ByReference;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.NativeLongByReference;
import com.sun.jna.ptr.PointerByReference;
import com.sun.jna.ptr.ShortByReference;
import java.io.PrintWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.sql.DriverManager;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;

public interface OdbcLibrary {
    public static final Library.Handler HANDLER = new Library.Handler(OdbcUtils.getLibraryName(), OdbcLibrary.class, OdbcUtils.OPTIONS){

        public Object invoke(Object proxy, Method method, Object[] inArgs) throws Throwable {
            PrintWriter writer = DriverManager.getLogWriter();
            if (writer != null) {
                writer.println(method.getName());
                writer.flush();
            }
            return super.invoke(proxy, method, inArgs);
        }
    };
    public static final OdbcLibrary ODBC = (OdbcLibrary)Proxy.newProxyInstance(OdbcLibrary.class.getClassLoader(), new Class[]{OdbcLibrary.class}, (InvocationHandler)HANDLER);
    public static final boolean UNICODE = OdbcUtils.isUnicode(HANDLER.getNativeLibrary());
    public static final int FACTOR = UNICODE ? 2 : 1;
    public static final Charset CHARSET = UNICODE ? Charset.forName("UTF-16LE") : Charset.defaultCharset();
    public static final short SQL_HANDLE_ENV = 1;
    public static final short SQL_HANDLE_DBC = 2;
    public static final short SQL_HANDLE_STMT = 3;
    public static final short SQL_HANDLE_DESC = 4;
    public static final short SQL_SUCCESS = 0;
    public static final short SQL_SUCCESS_WITH_INFO = 1;
    public static final short SQL_ERROR = -1;
    public static final short SQL_INVALID_HANDLE = -2;
    public static final short SQL_NEED_DATA = 99;
    public static final short SQL_NO_DATA = 100;
    public static final short SQL_NULL_DATA = -1;
    public static final short SQL_NO_TOTAL = -4;
    public static final short SQL_NTS = -3;
    public static final short SQL_MAX_MESSAGE_LENGTH = 512;
    public static final short SQL_DRIVER_NOPROMPT = 0;
    public static final short SQL_DRIVER_COMPLETE = 1;
    public static final short SQL_DRIVER_PROMPT = 2;
    public static final short SQL_DRIVER_COMPLETE_REQUIRED = 3;
    public static final short SQL_CLOSE = 0;
    public static final short SQL_DROP = 1;
    public static final short SQL_UNBIND = 2;
    public static final short SQL_RESET_PARAMS = 3;
    public static final short SQL_DESC_DISPLAY_SIZE = 6;
    public static final short SQL_DESC_UNSIGNED = 8;
    public static final short SQL_DESC_FIXED_PREC_SCALE = 9;
    public static final short SQL_DESC_UPDATABLE = 10;
    public static final short SQL_DESC_AUTO_UNIQUE_VALUE = 11;
    public static final short SQL_DESC_CASE_SENSITIVE = 12;
    public static final short SQL_DESC_SEARCHABLE = 13;
    public static final short SQL_DESC_TYPE_NAME = 14;
    public static final short SQL_DESC_TABLE_NAME = 15;
    public static final short SQL_DESC_SCHEMA_NAME = 16;
    public static final short SQL_DESC_CATALOG_NAME = 17;
    public static final short SQL_DESC_LABEL = 18;
    public static final short SQL_DESC_COUNT = 1001;
    public static final short SQL_DESC_TYPE = 1002;
    public static final short SQL_DESC_LENGTH = 1003;
    public static final short SQL_DESC_OCTET_LENGTH_PTR = 1004;
    public static final short SQL_DESC_PRECISION = 1005;
    public static final short SQL_DESC_SCALE = 1006;
    public static final short SQL_DESC_DATETIME_INTERVAL_CODE = 1007;
    public static final short SQL_DESC_NULLABLE = 1008;
    public static final short SQL_DESC_INDICATOR_PTR = 1009;
    public static final short SQL_DESC_DATA_PTR = 1010;
    public static final short SQL_DESC_NAME = 1011;
    public static final short SQL_DESC_UNNAMED = 1012;
    public static final short SQL_DESC_OCTET_LENGTH = 1013;
    public static final short SQL_DESC_ALLOC_TYPE = 1099;
    public static final short SQL_ATTR_READONLY = 0;
    public static final short SQL_ATTR_WRITE = 1;
    public static final short SQL_ATTR_READWRITE_UNKNOWN = 2;
    public static final short SQL_ATTR_ODBC_VERSION = 200;
    public static final short SQL_ATTR_CONNECTION_POOLING = 201;
    public static final short SQL_ATTR_CP_MATCH = 202;
    public static final short SQL_DATETIME = 9;
    public static final short SQL_TIME = 10;
    public static final short SQL_TIMESTAMP = 11;
    public static final short SQL_WCHAR = -8;
    public static final short SQL_WVARCHAR = -9;
    public static final short SQL_WLONGVARCHAR = -10;
    public static final short SQL_MAX_DRIVER_CONNECTIONS = 0;
    public static final short SQL_MAX_CONCURRENT_ACTIVITIES = 1;
    public static final short SQL_DATA_SOURCE_NAME = 2;
    public static final short SQL_DRIVER_HDBC = 3;
    public static final short SQL_DRIVER_HENV = 4;
    public static final short SQL_DRIVER_HSTMT = 5;
    public static final short SQL_DRIVER_NAME = 6;
    public static final short SQL_DRIVER_VER = 7;
    public static final short SQL_FETCH_DIRECTION = 8;
    public static final short SQL_SERVER_NAME = 13;
    public static final short SQL_SEARCH_PATTERN_ESCAPE = 14;
    public static final short SQL_DBMS_NAME = 17;
    public static final short SQL_DBMS_VER = 18;
    public static final short SQL_ACCESSIBLE_TABLES = 19;
    public static final short SQL_ACCESSIBLE_PROCEDURES = 20;
    public static final short SQL_CURSOR_COMMIT_BEHAVIOR = 23;
    public static final short SQL_DATA_SOURCE_READ_ONLY = 25;
    public static final short SQL_DEFAULT_TXN_ISOLATION = 26;
    public static final short SQL_IDENTIFIER_CASE = 28;
    public static final short SQL_IDENTIFIER_QUOTE_CHAR = 29;
    public static final short SQL_MAX_COLUMN_NAME_LEN = 30;
    public static final short SQL_MAX_CURSOR_NAME_LEN = 31;
    public static final short SQL_MAX_SCHEMA_NAME_LEN = 32;
    public static final short SQL_MAX_CATALOG_NAME_LEN = 34;
    public static final short SQL_MAX_TABLE_NAME_LEN = 35;
    public static final short SQL_SCROLL_CONCURRENCY = 43;
    public static final short SQL_TXN_CAPABLE = 46;
    public static final short SQL_USER_NAME = 47;
    public static final short SQL_TXN_ISOLATION_OPTION = 72;
    public static final short SQL_INTEGRITY = 73;
    public static final short SQL_GETDATA_EXTENSIONS = 81;
    public static final short SQL_BOOKMARK_PERSISTENCE = 82;
    public static final short SQL_STATIC_SENSITIVITY = 83;
    public static final short SQL_FILE_USAGE = 84;
    public static final short SQL_NULL_COLLATION = 85;
    public static final short SQL_ALTER_TABLE = 86;
    public static final short SQL_COLUMN_ALIAS = 87;
    public static final short SQL_GROUP_BY = 88;
    public static final short SQL_KEYWORDS = 89;
    public static final short SQL_ORDER_BY_COLUMNS_IN_SELECT = 90;
    public static final short SQL_OWNER_USAGE = 91;
    public static final short SQL_QUALIFIER_USAGE = 92;
    public static final short SQL_QUOTED_IDENTIFIER_CASE = 93;
    public static final short SQL_SPECIAL_CHARACTERS = 94;
    public static final short SQL_MAX_COLUMNS_IN_GROUP_BY = 97;
    public static final short SQL_MAX_COLUMNS_IN_INDEX = 98;
    public static final short SQL_MAX_COLUMNS_IN_ORDER_BY = 99;
    public static final short SQL_MAX_COLUMNS_IN_SELECT = 100;
    public static final short SQL_MAX_COLUMNS_IN_TABLE = 101;
    public static final short SQL_MAX_INDEX_SIZE = 102;
    public static final short SQL_MAX_ROW_SIZE = 104;
    public static final short SQL_MAX_STATEMENT_LEN = 105;
    public static final short SQL_MAX_TABLES_IN_SELECT = 106;
    public static final short SQL_MAX_USER_NAME_LEN = 107;
    public static final short SQL_OJ_CAPABILITIES = 115;
    public static final short SQL_XOPEN_CLI_YEAR = 10000;
    public static final short SQL_CURSOR_SENSITIVITY = 10001;
    public static final short SQL_DESCRIBE_PARAMETER = 10002;
    public static final short SQL_CATALOG_NAME = 10003;
    public static final short SQL_COLLATION_SEQ = 10004;
    public static final short SQL_MAX_IDENTIFIER_LEN = 10005;
    public static final short SQL_FILE_NOT_SUPPORTED = 0;
    public static final short SQL_FILE_TABLE = 1;
    public static final short SQL_FILE_QUALIFIER = 2;
    public static final short SQL_PARAM_TYPE_UNKNOWN = 0;
    public static final short SQL_PARAM_INPUT = 1;
    public static final short SQL_PARAM_INPUT_OUTPUT = 2;
    public static final short SQL_RESULT_COL = 3;
    public static final short SQL_PARAM_OUTPUT = 4;
    public static final short SQL_RETURN_VALUE = 5;
    public static final short SQL_ATTR_ACCESS_MODE = 101;
    public static final short SQL_ATTR_AUTOCOMMIT = 102;
    public static final short SQL_ATTR_CONNECTION_TIMEOUT = 113;
    public static final short SQL_ATTR_CURRENT_CATALOG = 109;
    public static final short SQL_ATTR_DISCONNECT_BEHAVIOR = 114;
    public static final short SQL_ATTR_ENLIST_IN_DTC = 1207;
    public static final short SQL_ATTR_ENLIST_IN_XA = 1208;
    public static final short SQL_ATTR_LOGIN_TIMEOUT = 103;
    public static final short SQL_ATTR_ODBC_CURSORS = 110;
    public static final short SQL_ATTR_PACKET_SIZE = 112;
    public static final short SQL_ATTR_QUIET_MODE = 111;
    public static final short SQL_ATTR_TRACE = 104;
    public static final short SQL_ATTR_TRACEFILE = 105;
    public static final short SQL_ATTR_TRANSLATE_LIB = 106;
    public static final short SQL_ATTR_TRANSLATE_OPTION = 107;
    public static final short SQL_ATTR_TXN_ISOLATION = 108;

    public short SQLDriverConnect(Pointer var1, Pointer var2, byte[] var3, short var4, byte[] var5, short var6, ShortByReference var7, short var8);

    public short SQLAllocConnect(Pointer var1, PointerByReference var2);

    public short SQLAllocEnv(PointerByReference var1);

    public short SQLAllocHandle(short var1, Pointer var2, PointerByReference var3);

    public short SQLAllocStmt(Pointer var1, PointerByReference var2);

    public short SQLBindCol(Pointer var1, SQLUSMALLINT var2, short var3, Pointer var4, int var5, int var6);

    public short SQLBindParameter(Pointer var1, short var2, short var3, short var4, short var5, NativeLong var6, short var7, ByReference var8, NativeLong var9, NativeLongByReference var10);

    public short SQLBindParameter(Pointer var1, short var2, short var3, short var4, short var5, NativeLong var6, short var7, Structure var8, NativeLong var9, NativeLongByReference var10);

    public short SQLCancel(Pointer var1);

    public short SQLCloseCursor(Pointer var1);

    public short SQLColAttribute(Pointer var1, short var2, short var3, BytesByReference var4, short var5, ShortByReference var6, IntByReference var7);

    public short SQLColumns(Pointer var1, ByteBuffer var2, short var3, ByteBuffer var4, short var5, ByteBuffer var6, short var7, ByteBuffer var8, short var9);

    public short SQLConnect(Pointer var1, ByteBuffer var2, short var3, ByteBuffer var4, short var5, ByteBuffer var6, short var7);

    public short SQLCopyDesc(Pointer var1, Pointer var2);

    public short SQLDataSources(Pointer var1, SQLUSMALLINT var2, ByteBuffer var3, short var4, short var5, ByteBuffer var6, short var7, short var8);

    public short SQLDescribeCol(Pointer var1, SQLUSMALLINT var2, ByteBuffer var3, short var4, short var5, short var6, NativeLongByReference var7, short var8, short var9);

    public short SQLDisconnect(Pointer var1);

    public short SQLEndTran(short var1, Pointer var2, short var3);

    public short SQLError(Pointer var1, Pointer var2, Pointer var3, byte[] var4, IntByReference var5, byte[] var6, short var7, ShortByReference var8);

    public short SQLExecDirect(Pointer var1, byte[] var2, int var3);

    public short SQLExecute(Pointer var1);

    public short SQLFetch(Pointer var1);

    public short SQLFetchScroll(Pointer var1, short var2, int var3);

    public short SQLFreeConnect(Pointer var1);

    public short SQLFreeEnv(Pointer var1);

    public short SQLFreeHandle(short var1, Pointer var2);

    public short SQLFreeStmt(Pointer var1, short var2);

    public short SQLGetConnectAttr(Pointer var1, int var2, BytesByReference var3, int var4, IntByReference var5);

    public short SQLGetCursorName(Pointer var1, ByteBuffer var2, short var3, short var4);

    public short SQLGetData(Pointer var1, short var2, short var3, ByReference var4, int var5, IntByReference var6);

    public short SQLGetDescField(Pointer var1, short var2, short var3, Pointer var4, int var5, int var6);

    public short SQLGetDescRec(Pointer var1, short var2, ByteBuffer var3, short var4, short var5, short var6, short var7, int var8, short var9, short var10, short var11);

    public short SQLGetDiagField(short var1, Pointer var2, short var3, short var4, Pointer var5, short var6, short var7);

    public short SQLGetDiagRec(short var1, Pointer var2, short var3, ByteBuffer var4, int var5, ByteBuffer var6, short var7, short var8);

    public short SQLGetEnvAttr(Pointer var1, int var2, Pointer var3, int var4, int var5);

    public short SQLGetFunctions(Pointer var1, SQLUSMALLINT var2, SQLUSMALLINT var3);

    public short SQLGetInfo(Pointer var1, short var2, ByReference var3, short var4, ShortByReference var5);

    public short SQLGetStmtAttr(Pointer var1, int var2, Pointer var3, int var4, int var5);

    public short SQLGetStmtOption(Pointer var1, SQLUSMALLINT var2, Pointer var3);

    public short SQLGetTypeInfo(Pointer var1, short var2);

    public short SQLNumResultCols(Pointer var1, ShortByReference var2);

    public short SQLParamData(Pointer var1, ShortByReference var2);

    public short SQLPrepare(Pointer var1, byte[] var2, int var3);

    public short SQLPutData(Pointer var1, Pointer var2, int var3);

    public short SQLRowCount(Pointer var1, int var2);

    public short SQLSetConnectAttr(Pointer var1, int var2, byte[] var3, int var4);

    public short SQLSetCursorName(Pointer var1, ByteBuffer var2, short var3);

    public short SQLSetDescField(Pointer var1, short var2, short var3, Pointer var4, int var5);

    public short SQLSetDescRec(Pointer var1, short var2, short var3, short var4, int var5, short var6, short var7, Pointer var8, int var9, int var10);

    public short SQLSetEnvAttr(Pointer var1, int var2, int var3, int var4);

    public short SQLSetParam(Pointer var1, SQLUSMALLINT var2, short var3, short var4, NativeLong var5, short var6, Pointer var7, int var8);

    public short SQLSetStmtAttr(Pointer var1, int var2, Pointer var3, int var4);

    public short SQLSetStmtOption(Pointer var1, SQLUSMALLINT var2, NativeLong var3);

    public short SQLSpecialColumns(Pointer var1, SQLUSMALLINT var2, ByteBuffer var3, short var4, ByteBuffer var5, short var6, ByteBuffer var7, short var8, SQLUSMALLINT var9, SQLUSMALLINT var10);

    public short SQLStatistics(Pointer var1, ByteBuffer var2, short var3, ByteBuffer var4, short var5, ByteBuffer var6, short var7, SQLUSMALLINT var8, SQLUSMALLINT var9);

    public short SQLTables(Pointer var1, byte[] var2, short var3, byte[] var4, short var5, byte[] var6, short var7, byte[] var8, short var9);

    public short SQLTransact(Pointer var1, Pointer var2, SQLUSMALLINT var3);

    public short SQLProcedures(Pointer var1, byte[] var2, short var3, byte[] var4, short var5, byte[] var6, short var7);

    public short SQLProcedureColumns(Pointer var1, byte[] var2, short var3, byte[] var4, short var5, byte[] var6, short var7, byte[] var8, short var9);

    public short SQLNumParams(Pointer var1, ShortByReference var2);

    public static class SQLUSMALLINT
    extends PointerType {
        public SQLUSMALLINT(Pointer address) {
            super(address);
        }

        public SQLUSMALLINT() {
        }
    }

    public static class TimestampStructure
    extends Structure {
        public short year;
        public short month;
        public short day;
        public short hour;
        public short minute;
        public short second;
        public int fraction;
        private static final List FIELD_ORDER = Arrays.asList("year", "month", "day", "hour", "minute", "second", "fraction");

        public TimestampStructure() {
        }

        public TimestampStructure(Timestamp ts) {
            this.year = (short)(ts.getYear() + 1900);
            this.month = (short)(ts.getMonth() + 1);
            this.day = (short)ts.getDate();
            this.hour = (short)ts.getHours();
            this.minute = (short)ts.getMinutes();
            this.second = (short)ts.getSeconds();
            this.fraction = ts.getNanos();
        }

        protected List getFieldOrder() {
            return FIELD_ORDER;
        }
    }

    public static interface SQLINTERVAL {
        public static final int SQL_IS_YEAR = 1;
        public static final int SQL_IS_MONTH = 2;
        public static final int SQL_IS_DAY = 3;
        public static final int SQL_IS_HOUR = 4;
        public static final int SQL_IS_MINUTE = 5;
        public static final int SQL_IS_SECOND = 6;
        public static final int SQL_IS_YEAR_TO_MONTH = 7;
        public static final int SQL_IS_DAY_TO_HOUR = 8;
        public static final int SQL_IS_DAY_TO_MINUTE = 9;
        public static final int SQL_IS_DAY_TO_SECOND = 10;
        public static final int SQL_IS_HOUR_TO_MINUTE = 11;
        public static final int SQL_IS_HOUR_TO_SECOND = 12;
        public static final int SQL_IS_MINUTE_TO_SECOND = 13;
    }
}

