/*
 * Decompiled with CFR 0.152.
 */
package com.inet.persistence.dynamodb;

import com.inet.cache.shutdown.ShutdownFinalizer;
import com.inet.cache.shutdown.ShutdownManager;
import com.inet.id.GUID;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.persistence.EventLogPersistence;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceEntry;
import com.inet.persistence.PersistenceListener;
import com.inet.persistence.SearchIndexPersistence;
import com.inet.persistence.dynamodb.DynamoDbEventLogPersistence;
import com.inet.persistence.dynamodb.DynamoDbLocks;
import com.inet.persistence.dynamodb.DynamoDbPersistenceEntry;
import com.inet.persistence.dynamodb.DynamoDbPublishSubscribe;
import com.inet.persistence.dynamodb.DynamoDbSearchIndexPersistence;
import com.inet.persistence.spi.PersistenceLogger;
import com.inet.persistence.spi.events.NodeCounter;
import com.inet.persistence.spi.events.PersistenceListenerContainer;
import com.inet.persistence.spi.searchlistener.SearchListenerManager;
import com.inet.thread.ServerLock;
import java.net.URI;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClientBuilder;
import software.amazon.awssdk.services.dynamodb.streams.DynamoDbStreamsClient;
import software.amazon.awssdk.services.dynamodb.streams.DynamoDbStreamsClientBuilder;

class DynamoDbPersistence
implements Persistence {
    private static DynamoDbClient client;
    private static DynamoDbStreamsClient streamsClient;
    private static DynamoDbPublishSubscribe pubsub;
    private static NodeCounter nodeCounter;
    @Nonnull
    private static String CLIENT_ID;
    private final PersistenceListenerContainer listeners = new PersistenceListenerContainer();
    private final DynamoDbLocks locks = new DynamoDbLocks();
    private static SearchListenerManager searchListenerManager;
    @Nonnull
    private static String tablePrefix;

    private static void cleanup() {
        if (client == null) {
            return;
        }
        if (pubsub != null) {
            pubsub.stop();
            pubsub = null;
        }
        if (nodeCounter != null) {
            nodeCounter.onShutdown();
            nodeCounter = null;
        }
        client.close();
        client = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DynamoDbPersistence(@Nonnull String uri) {
        int logLevel = PersistenceLogger.LOGGER.getLogLevel();
        PersistenceLogger.LOGGER.setLogLevel(4);
        Logger dynamoDbLogger = LogManager.getLogger((String)"DynamoDB");
        int dynamoDbLogLevel = dynamoDbLogger.getLogLevel();
        dynamoDbLogger.setLogLevel(4);
        try {
            String[] keyValues;
            DynamoDbPersistence.cleanup();
            PersistenceLogger.LOGGER.debug((Object)"Connect to DynamoDB");
            DynamoDbClientBuilder builder = DynamoDbClient.builder();
            DynamoDbStreamsClientBuilder streamBuilder = DynamoDbStreamsClient.builder();
            tablePrefix = "";
            String accessKeyId = null;
            String secretAccessKey = null;
            block17: for (String keyVal : keyValues = uri.split(";")) {
                int idx = keyVal.indexOf(61);
                if (idx <= 0) continue;
                String key = keyVal.substring(0, idx).toLowerCase();
                String val = keyVal.substring(idx + 1);
                switch (key) {
                    case "region": {
                        StringBuilder b = new StringBuilder();
                        for (Region region : Region.regions()) {
                            if (region.id().equals(val)) {
                                builder.region(region);
                                streamBuilder.region(region);
                                continue block17;
                            }
                            if (b.length() > 0) {
                                b.append(", ");
                            }
                            b.append(region.id());
                        }
                        throw new IllegalArgumentException("Invalid 'region' value: " + val + "\nPossible values for 'region' are: " + String.valueOf(b));
                    }
                    case "endpoint": {
                        URI endpoint = URI.create(val);
                        builder.endpointOverride(endpoint);
                        streamBuilder.endpointOverride(endpoint);
                        continue block17;
                    }
                    case "accesskeyid": {
                        accessKeyId = val;
                        continue block17;
                    }
                    case "secretaccesskey": {
                        secretAccessKey = val;
                        continue block17;
                    }
                    case "tableprefix": {
                        tablePrefix = Objects.requireNonNull(val);
                    }
                }
            }
            if (accessKeyId != null && secretAccessKey != null) {
                AwsBasicCredentials credentials = AwsBasicCredentials.create(accessKeyId, secretAccessKey);
                StaticCredentialsProvider provider = StaticCredentialsProvider.create((AwsCredentials)credentials);
                builder.credentialsProvider((AwsCredentialsProvider)provider);
                streamBuilder.credentialsProvider((AwsCredentialsProvider)provider);
            }
            client = (DynamoDbClient)builder.build();
            streamsClient = (DynamoDbStreamsClient)streamBuilder.build();
            DynamoDbPersistenceEntry.createTable(client);
            DynamoDbEventLogPersistence.createTable(client);
            DynamoDbLocks.createTable(client);
            DynamoDbSearchIndexPersistence.createMainTable(client, this);
            pubsub = new DynamoDbPublishSubscribe(this.listeners);
            pubsub.start(CLIENT_ID);
            nodeCounter = new NodeCounter(this);
            this.registerListener(nodeCounter);
            searchListenerManager = new SearchListenerManager(this);
        }
        finally {
            PersistenceLogger.LOGGER.setLogLevel(logLevel);
            dynamoDbLogger.setLogLevel(dynamoDbLogLevel);
        }
    }

    @Nonnull
    static DynamoDbClient getClient() {
        return client;
    }

    @Nonnull
    static DynamoDbStreamsClient getStreamsClient() {
        return streamsClient;
    }

    static SearchListenerManager getSearchListenerManager() {
        return searchListenerManager;
    }

    static String getTablePrefix() {
        return tablePrefix;
    }

    @Nonnull
    public PersistenceEntry resolve(@Nonnull String path) throws NullPointerException, IllegalArgumentException {
        return new DynamoDbPersistenceEntry(path);
    }

    @Nonnull
    public EventLogPersistence getEventLogPersistence(String name) {
        return new DynamoDbEventLogPersistence(name);
    }

    public <T> void registerListener(@Nonnull PersistenceListener<T> listener) {
        this.listeners.addListener(listener);
    }

    public <T> void sendEvent(@Nonnull T event) {
        DynamoDbPublishSubscribe pubsub = DynamoDbPersistence.pubsub;
        if (pubsub != null) {
            pubsub.send(event, CLIENT_ID);
        }
    }

    public int getNodeCount() {
        return nodeCounter.getNodeCount();
    }

    public void registerNodeListener(@Nonnull PersistenceListener<Boolean> listener) {
        nodeCounter.addListener(listener);
    }

    public <ID> SearchIndexPersistence<ID> getSearchIndexPersistence(@Nonnull String name) {
        return new DynamoDbSearchIndexPersistence(name);
    }

    @Nullable
    public ServerLock tryLock(@Nonnull String key) {
        return this.locks.tryLock(key);
    }

    @Nullable
    public ServerLock tryReadLock(@Nonnull String key) {
        return this.locks.tryReadWriteLock(key, false);
    }

    @Nullable
    public ServerLock tryWriteLock(@Nonnull String key) {
        return this.locks.tryReadWriteLock(key, true);
    }

    @Nonnull
    public ServerLock getReadLock(@Nonnull String key, long timeout) {
        return this.locks.getReadWriteLock(key, false, timeout);
    }

    @Nonnull
    public ServerLock getWriteLock(@Nonnull String key, long timeout) {
        return this.locks.getReadWriteLock(key, true, timeout);
    }

    static {
        CLIENT_ID = GUID.generateNew().toString();
        ShutdownManager.add((ShutdownFinalizer)new ShutdownFinalizer(){

            public void onShutdown() {
                DynamoDbPersistence.cleanup();
            }

            public int order() {
                return 1000001;
            }
        });
    }
}

