/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.swing;

import java.awt.Image;
import java.beans.BeanDescriptor;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.SimpleBeanInfo;
import javax.swing.ImageIcon;
import net.sourceforge.jeuclid.swing.JMathComponent;

public class JMathComponentBeanInfo
extends SimpleBeanInfo {
    private static final Class<JMathComponent> BEANCLASS = JMathComponent.class;
    private final Image icoColor16 = new ImageIcon(BEANCLASS.getResource("/icons/jeuclid_16x16.png")).getImage();
    private final Image icoColor32 = new ImageIcon(BEANCLASS.getResource("/icons/jeuclid_32x32.png")).getImage();
    private final Image icoBw16 = new ImageIcon(BEANCLASS.getResource("/icons/jeuclid_16x16_bw.png")).getImage();
    private final Image icoBw32 = new ImageIcon(BEANCLASS.getResource("/icons/jeuclid_32x32_bw.png")).getImage();

    public Image getIcon(int iconKind) {
        Image retVal;
        switch (iconKind) {
            case 1: {
                retVal = this.icoColor16;
                break;
            }
            case 2: {
                retVal = this.icoColor32;
                break;
            }
            case 3: {
                retVal = this.icoBw16;
                break;
            }
            case 4: {
                retVal = this.icoBw32;
                break;
            }
            default: {
                return this.icoColor32;
            }
        }
        return retVal;
    }

    public BeanDescriptor getBeanDescriptor() {
        BeanDescriptor beanDescriptor = new BeanDescriptor(BEANCLASS);
        beanDescriptor.setName("JEuclid");
        beanDescriptor.setDisplayName("JEuclid Bean");
        beanDescriptor.setShortDescription("The JEuclid project creates the possibility to display MathML content. This Bean supports rendering MathML content as a Swing component.");
        return beanDescriptor;
    }

    public PropertyDescriptor[] getPropertyDescriptors() {
        try {
            PropertyDescriptor propertyFontSize = this.createPropertyDescriptor("fontSize", "Font size", "This will modify the font size of the displayed MathML elements");
            PropertyDescriptor propertyContent = this.createPropertyDescriptor("content", "Content", "The XML content for the JEuclid Bean");
            PropertyDescriptor fgContent = this.createPropertyDescriptor("foreground", "Foreground Color", "Foreground color if not specified within the document");
            PropertyDescriptor bgContent = this.createPropertyDescriptor("background", "Background Color", "Background color for this component");
            PropertyDescriptor opaqueContent = this.createPropertyDescriptor("opaque", "Opaque", "If true, will always overpaint the background");
            PropertyDescriptor fontsContent1 = this.createPropertyDescriptor("fontsSerif", "Serif Fonts", "Fonts to use for Serif characters (the default font)");
            PropertyDescriptor fontsContent2 = this.createPropertyDescriptor("fontsSanserif", "Sans-Serif Fonts", "Fonts to use for Sans-Serif characters");
            PropertyDescriptor fontsContent3 = this.createPropertyDescriptor("fontsMonospaced", "Monospaced Fonts", "Fonts to use for Monospaced characters");
            PropertyDescriptor fontsContent4 = this.createPropertyDescriptor("fontsScript", "Script Fonts", "Fonts to use for Script characters");
            PropertyDescriptor fontsContent5 = this.createPropertyDescriptor("fontsFraktur", "Fraktur Fonts", "Fonts to use for Fraktur characters");
            PropertyDescriptor fontsContent6 = this.createPropertyDescriptor("fontsDoublestruck", "Double-Struck Fonts", "Fonts to use for Double-Struck characters");
            PropertyDescriptor vAlign = this.createPropertyDescriptor("verticalAlignment", "Vertical Alignment", "Vertical alignment, as defined by javax.swing.JLabel#getHorizontalAlignment");
            PropertyDescriptor hAlign = this.createPropertyDescriptor("horizontalAlignment", "Horizontal Alignment", "Horizontal alignment, as defined by javax.swing.JLabel#getHorizontalAlignment");
            PropertyDescriptor border = this.createPropertyDescriptor("border", "Border", "Swing Border Property");
            return new PropertyDescriptor[]{propertyContent, propertyFontSize, fgContent, bgContent, opaqueContent, fontsContent1, fontsContent2, fontsContent3, fontsContent4, fontsContent5, fontsContent6, vAlign, hAlign, border};
        }
        catch (IntrospectionException ex) {
            return super.getPropertyDescriptors();
        }
    }

    private PropertyDescriptor createPropertyDescriptor(String attribute, String displayName, String description) throws IntrospectionException {
        PropertyDescriptor propertyFontSize = new PropertyDescriptor(attribute, BEANCLASS);
        propertyFontSize.setDisplayName(displayName);
        propertyFontSize.setShortDescription(description);
        return propertyFontSize;
    }
}

