/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.elements.presentation.general;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import net.sourceforge.jeuclid.MathBase;
import net.sourceforge.jeuclid.elements.AbstractJEuclidElement;
import net.sourceforge.jeuclid.elements.JEuclidElement;
import net.sourceforge.jeuclid.elements.support.GraphicsSupport;
import net.sourceforge.jeuclid.elements.support.attributes.AttributesHelper;
import org.w3c.dom.mathml.MathMLElement;
import org.w3c.dom.mathml.MathMLFractionElement;

public class Mfrac
extends AbstractJEuclidElement
implements MathMLFractionElement {
    public static final String ELEMENT = "mfrac";
    public static final float FRAC_TILT_ANGLE = 0.577f;
    public static final String ATTR_LINETHICKNESS = "linethickness";
    public static final String ATTR_BEVELLED = "bevelled";
    public static final String ATTR_NUMALIGN = "numalign";
    public static final String ATTR_DENOMALIGN = "denomalign";
    private static final String EXTRA_SPACE_AROUND = "0.1em";

    public Mfrac(MathBase base) {
        super(base);
        this.setDefaultMathAttribute(ATTR_LINETHICKNESS, "1");
        this.setDefaultMathAttribute(ATTR_BEVELLED, MathBase.FALSE);
        this.setDefaultMathAttribute(ATTR_NUMALIGN, "center");
        this.setDefaultMathAttribute(ATTR_DENOMALIGN, "center");
    }

    public boolean isChildBlock(JEuclidElement child) {
        return false;
    }

    public void setLinethickness(String linethickness) {
        this.setAttribute(ATTR_LINETHICKNESS, linethickness);
    }

    public float getLinethickness(Graphics2D g) {
        float thickness;
        String sThickness = this.getLinethickness();
        try {
            thickness = Float.parseFloat(sThickness);
            thickness *= GraphicsSupport.lineWidth(this);
        }
        catch (NumberFormatException nfe) {
            thickness = AttributesHelper.convertSizeToPt(sThickness, this, "pt");
        }
        return thickness;
    }

    public void setBevelled(String bevelled) {
        this.setAttribute(ATTR_BEVELLED, bevelled);
    }

    public String getBevelled() {
        return this.getMathAttribute(ATTR_BEVELLED);
    }

    public void paint(Graphics2D g, float posX, float posY) {
        super.paint(g, posX, posY);
        JEuclidElement e1 = this.getMathElement(0);
        JEuclidElement e2 = this.getMathElement(1);
        float middle = posY - this.getMiddleShift(g);
        float dist = AttributesHelper.convertSizeToPt(EXTRA_SPACE_AROUND, this, "");
        if (Boolean.parseBoolean(this.getBevelled())) {
            float w1 = Math.max(e2.getHeight(g) * 0.577f, e1.getWidth(g) + dist);
            e1.paint(g, posX + w1 - e1.getWidth(g), middle - e1.getDescentHeight(g));
            float linef = this.getLinethickness(g);
            e2.paint(g, posX + w1 + dist + linef, posY - this.getAscentHeight(g) + e1.getHeight(g) + e2.getAscentHeight(g));
            Stroke oldStroke = g.getStroke();
            g.setStroke(new BasicStroke(linef));
            g.draw(new Line2D.Float(posX + w1 + linef / 2.0f - e2.getHeight(g) * 0.577f, middle + e2.getHeight(g), posX + w1 + linef / 2.0f + e1.getHeight(g) * 0.577f, middle - e1.getHeight(g)));
            g.setStroke(oldStroke);
        } else {
            float width = this.getWidth(g);
            float startX = posX + dist;
            float linef = this.getLinethickness(g);
            e1.paint(g, startX + (width - 2.0f * dist - e1.getWidth(g)) / 2.0f, middle - e1.getDescentHeight(g) - 2.0f - this.getLinethickness(g) / 2.0f);
            Stroke oldStroke = g.getStroke();
            g.setStroke(new BasicStroke(linef));
            g.draw(new Line2D.Float(startX, middle, startX + width - dist * 2.0f, middle));
            g.setStroke(oldStroke);
            e2.paint(g, startX + (width - 2.0f * dist - e2.getWidth(g)) / 2.0f, middle + e2.getAscentHeight(g) + 2.0f + this.getLinethickness(g) / 2.0f);
        }
    }

    public float calculateWidth(Graphics2D g) {
        JEuclidElement e1 = this.getMathElement(0);
        JEuclidElement e2 = this.getMathElement(1);
        float dist = AttributesHelper.convertSizeToPt(EXTRA_SPACE_AROUND, this, "");
        if (Boolean.parseBoolean(this.getBevelled())) {
            float w1 = Math.max(e2.getHeight(g) * 0.577f, e1.getWidth(g) + dist);
            float w2 = Math.max(e1.getHeight(g) * 0.577f, e2.getWidth(g) + dist);
            return w1 + w2 + this.getLinethickness(g);
        }
        return Math.max(e1.getWidth(g), e2.getWidth(g)) + dist * 2.0f;
    }

    public float calculateAscentHeight(Graphics2D g) {
        if (Boolean.parseBoolean(this.getBevelled())) {
            return this.getMathElement(0).getHeight(g) + this.getMiddleShift(g);
        }
        return this.getMathElement(0).getHeight(g) + 2.0f + this.getLinethickness(g) / 2.0f + this.getMiddleShift(g);
    }

    public float calculateDescentHeight(Graphics2D g) {
        if (Boolean.parseBoolean(this.getBevelled())) {
            return Math.max(0.0f, this.getMathElement(1).getHeight(g) - this.getMiddleShift(g));
        }
        return Math.max(0.0f, this.getMathElement(1).getHeight(g) + 2.0f + this.getLinethickness(g) / 2.0f - this.getMiddleShift(g));
    }

    public String getTagName() {
        return ELEMENT;
    }

    public MathMLElement getDenominator() {
        return this.getMathElement(1);
    }

    public String getLinethickness() {
        return this.getMathAttribute(ATTR_LINETHICKNESS);
    }

    public MathMLElement getNumerator() {
        return this.getMathElement(0);
    }

    public void setDenominator(MathMLElement denominator) {
        this.setMathElement(1, denominator);
    }

    public void setNumerator(MathMLElement numerator) {
        this.setMathElement(0, numerator);
    }

    public String getDenomalign() {
        return this.getMathAttribute(ATTR_DENOMALIGN);
    }

    public String getNumalign() {
        return this.getMathAttribute(ATTR_NUMALIGN);
    }

    public void setDenomalign(String denomalign) {
        this.setAttribute(ATTR_DENOMALIGN, denomalign);
    }

    public void setNumalign(String numalign) {
        this.setAttribute(ATTR_NUMALIGN, numalign);
    }
}

