/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.converter;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.jeuclid.converter.ConverterRegistry;
import net.sourceforge.jeuclid.converter.FreeHepConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.freehep.util.export.ExportFileType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FreeHepInternalDetector {
    private static final Log LOGGER = LogFactory.getLog(FreeHepInternalDetector.class);
    private static final Map<String, String> PLUGINS_CLASSES = new HashMap<String, String>();

    private FreeHepInternalDetector() {
    }

    public static void actuallyDetectConversionPlugins(ConverterRegistry registry) {
        for (Map.Entry<String, String> e : PLUGINS_CLASSES.entrySet()) {
            try {
                Class<?> infoClass = Thread.currentThread().getContextClassLoader().loadClass(e.getKey());
                ExportFileType fileType = (ExportFileType)infoClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                Class<?> graphicsClass = Thread.currentThread().getContextClassLoader().loadClass(e.getValue());
                FreeHepInternalDetector.actuallyRegister(registry, fileType, graphicsClass);
            }
            catch (NoSuchMethodException ex) {
                LOGGER.debug((Object)ex);
            }
            catch (ClassNotFoundException ex) {
                LOGGER.debug((Object)ex);
            }
            catch (IllegalArgumentException ex) {
                LOGGER.debug((Object)ex);
            }
            catch (SecurityException ex) {
                LOGGER.debug((Object)ex);
            }
            catch (InstantiationException ex) {
                LOGGER.debug((Object)ex);
            }
            catch (IllegalAccessException ex) {
                LOGGER.debug((Object)ex);
            }
            catch (InvocationTargetException ex) {
                LOGGER.debug((Object)ex);
            }
        }
    }

    private static void actuallyRegister(ConverterRegistry registry, ExportFileType fileType, Class<?> graphicsClass) throws NoSuchMethodException {
        for (String mimeType : fileType.getMIMETypes()) {
            for (String suffix : fileType.getExtensions()) {
                registry.registerMimeTypeAndSuffix(mimeType, suffix, false);
            }
            registry.registerConverter(mimeType, new FreeHepConverter(graphicsClass), false);
        }
    }

    static {
        PLUGINS_CLASSES.put("org.freehep.graphicsio.emf.EMFExportFileType", "org.freehep.graphicsio.emf.EMFGraphics2D");
        PLUGINS_CLASSES.put("org.freehep.graphicsio.gif.GIFExportFileType", "org.freehep.graphicsio.gif.GIFGraphics2D");
        PLUGINS_CLASSES.put("org.freehep.graphicsio.pdf.PDFExportFileType", "org.freehep.graphicsio.pdf.PDFGraphics2D");
        PLUGINS_CLASSES.put("org.freehep.graphicsio.ps.PSExportFileType", "org.freehep.graphicsio.ps.PSGraphics2D");
        PLUGINS_CLASSES.put("org.freehep.graphicsio.svg.SVGExportFileType", "org.freehep.graphicsio.svg.SVGGraphics2D");
        PLUGINS_CLASSES.put("org.freehep.graphicsio.swf.SWFExportFileType", "org.freehep.graphicsio.swf.SWFGraphics2D");
    }
}

