/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.converter;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import net.sourceforge.jeuclid.MathBase;
import net.sourceforge.jeuclid.converter.ConverterPlugin;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class BatikConverter
implements ConverterPlugin {
    BatikConverter() {
    }

    public Dimension convert(MathBase base, OutputStream outStream) throws IOException {
        DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
        Document document = domImpl.createDocument(null, "svg", null);
        SVGGeneratorContext svgContext = SVGGeneratorContext.createDefault((Document)document);
        svgContext.setComment("Converted from MathML using JEuclid");
        SVGGraphics2D svgGenerator = new SVGGraphics2D(svgContext, true);
        Dimension size = new Dimension((int)Math.ceil(base.getWidth((Graphics2D)svgGenerator)), (int)Math.ceil(base.getHeight((Graphics2D)svgGenerator)));
        svgGenerator.setSVGCanvasSize(size);
        base.paint((Graphics2D)svgGenerator);
        svgGenerator.stream((Writer)new OutputStreamWriter(outStream));
        return size;
    }
}

