/*
 * Decompiled with CFR 0.152.
 */
package com.inet.persistence.dynamodb;

import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.logging.LogID;
import com.inet.persistence.PersistenceListener;
import com.inet.persistence.dynamodb.DynamoDbPersistence;
import com.inet.persistence.dynamodb.DynamoDbUtils;
import com.inet.persistence.spi.PersistenceLogger;
import com.inet.persistence.spi.events.PersistenceListenerContainer;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.BillingMode;
import software.amazon.awssdk.services.dynamodb.model.CreateTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeStreamRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeStreamResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableResponse;
import software.amazon.awssdk.services.dynamodb.model.GetRecordsRequest;
import software.amazon.awssdk.services.dynamodb.model.GetRecordsResponse;
import software.amazon.awssdk.services.dynamodb.model.GetShardIteratorRequest;
import software.amazon.awssdk.services.dynamodb.model.GetShardIteratorResponse;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.KeyType;
import software.amazon.awssdk.services.dynamodb.model.Record;
import software.amazon.awssdk.services.dynamodb.model.ResourceInUseException;
import software.amazon.awssdk.services.dynamodb.model.ScalarAttributeType;
import software.amazon.awssdk.services.dynamodb.model.Shard;
import software.amazon.awssdk.services.dynamodb.model.ShardIteratorType;
import software.amazon.awssdk.services.dynamodb.model.StreamDescription;
import software.amazon.awssdk.services.dynamodb.model.StreamSpecification;
import software.amazon.awssdk.services.dynamodb.model.StreamViewType;
import software.amazon.awssdk.services.dynamodb.model.TimeToLiveSpecification;
import software.amazon.awssdk.services.dynamodb.model.UpdateTimeToLiveRequest;
import software.amazon.awssdk.services.dynamodb.streams.DynamoDbStreamsClient;
import software.amazon.awssdk.services.dynamodb.waiters.DynamoDbWaiter;

class DynamoDbPublishSubscribe {
    private static final String TABLE_NAME = "inet-events";
    private static final String ID = "id";
    private static final String TTL = "ttl";
    private static final String CLIENT = "client";
    private static final String TYPE = "type";
    private static final String MESSAGE = "message";
    private final PersistenceListenerContainer listeners;
    private String streamArn;
    private boolean stopped;
    @Nonnull
    private String tableName;

    DynamoDbPublishSubscribe(PersistenceListenerContainer listeners) {
        this.listeners = listeners;
        this.createTable(DynamoDbPersistence.getClient());
    }

    private void createTable(DynamoDbClient client) {
        try {
            this.tableName = DynamoDbPersistence.getTablePrefix() + TABLE_NAME;
            AttributeDefinition[] attrs = new AttributeDefinition[]{(AttributeDefinition)AttributeDefinition.builder().attributeName(ID).attributeType(ScalarAttributeType.S).build()};
            KeySchemaElement id = (KeySchemaElement)KeySchemaElement.builder().attributeName(ID).keyType(KeyType.HASH).build();
            StreamSpecification stream = (StreamSpecification)StreamSpecification.builder().streamEnabled(Boolean.valueOf(true)).streamViewType(StreamViewType.NEW_IMAGE).build();
            CreateTableRequest tableRequest = (CreateTableRequest)CreateTableRequest.builder().attributeDefinitions(attrs).keySchema(new KeySchemaElement[]{id}).streamSpecification(stream).billingMode(BillingMode.PAY_PER_REQUEST).tableName(this.tableName).build();
            client.createTable(tableRequest);
            DynamoDbWaiter dbWaiter = client.waiter();
            dbWaiter.waitUntilTableExists((DescribeTableRequest)DescribeTableRequest.builder().tableName(this.tableName).build());
            TimeToLiveSpecification timeSpec = (TimeToLiveSpecification)TimeToLiveSpecification.builder().enabled(Boolean.valueOf(true)).attributeName(TTL).build();
            UpdateTimeToLiveRequest timeToLiveRequest = (UpdateTimeToLiveRequest)UpdateTimeToLiveRequest.builder().tableName(this.tableName).timeToLiveSpecification(timeSpec).build();
            client.updateTimeToLive(timeToLiveRequest);
            PersistenceLogger.LOGGER.debug((Object)("Table '" + this.tableName + "' created"));
        }
        catch (ResourceInUseException ex) {
            PersistenceLogger.LOGGER.debug((Object)("Table '" + this.tableName + "' already exists"));
        }
        DescribeTableResponse describeTable = client.describeTable((DescribeTableRequest)DescribeTableRequest.builder().tableName(this.tableName).build());
        this.streamArn = describeTable.table().latestStreamArn();
    }

    void start(@Nonnull String clientID) {
        Thread thread = new Thread(() -> {
            block11: {
                try {
                    LogID.setID((String)"pubsub");
                    DynamoDbStreamsClient streamsClient = DynamoDbPersistence.getStreamsClient();
                    ArrayDeque<String> sharedIterators = new ArrayDeque<String>();
                    block5: do {
                        String lastEvaluatedShardId = null;
                        do {
                            DescribeStreamRequest streamRequest = (DescribeStreamRequest)DescribeStreamRequest.builder().streamArn(this.streamArn).exclusiveStartShardId(lastEvaluatedShardId).build();
                            DescribeStreamResponse describeStreamResponse = streamsClient.describeStream(streamRequest);
                            StreamDescription description = describeStreamResponse.streamDescription();
                            for (Shard shard : description.shards()) {
                                if (shard.sequenceNumberRange().endingSequenceNumber() != null) continue;
                                GetShardIteratorRequest request = (GetShardIteratorRequest)GetShardIteratorRequest.builder().streamArn(this.streamArn).shardId(shard.shardId()).shardIteratorType(ShardIteratorType.LATEST).build();
                                GetShardIteratorResponse itResponse = streamsClient.getShardIterator(request);
                                sharedIterators.add(itResponse.shardIterator());
                            }
                            lastEvaluatedShardId = description.lastEvaluatedShardId();
                        } while (!this.stopped && lastEvaluatedShardId != null);
                        while (!this.stopped && !sharedIterators.isEmpty()) {
                            String sharedIterator = (String)sharedIterators.pop();
                            GetRecordsRequest recordsRequest = (GetRecordsRequest)GetRecordsRequest.builder().shardIterator(sharedIterator).build();
                            GetRecordsResponse recordsResponse = streamsClient.getRecords(recordsRequest);
                            List records = recordsResponse.records();
                            for (Record record : records) {
                                switch (record.eventName()) {
                                    case INSERT: 
                                    case MODIFY: {
                                        Map item = record.dynamodb().newImage();
                                        String client = DynamoDbUtils.getS(item, CLIENT);
                                        if (Objects.equals(client, clientID)) break;
                                        this.onMessage(item);
                                    }
                                }
                            }
                            sharedIterator = recordsResponse.nextShardIterator();
                            if (sharedIterator != null) {
                                sharedIterators.add(sharedIterator);
                            }
                            if (sharedIterators.isEmpty()) continue block5;
                            int delay = Math.max(1, 1000 / sharedIterators.size());
                            Thread.sleep(delay);
                        }
                    } while (!this.stopped);
                }
                catch (Throwable th) {
                    if (this.stopped) break block11;
                    PersistenceLogger.LOGGER.error(th);
                }
            }
        }, this.tableName);
        thread.setDaemon(true);
        thread.start();
    }

    void stop() {
        this.stopped = true;
    }

    private void onMessage(Map<String, AttributeValue> item) {
        try {
            String type = DynamoDbUtils.getS(item, TYPE);
            if (type == null) {
                return;
            }
            PersistenceListenerContainer.ListenerDescription desc = this.listeners.get(type);
            if (desc == null) {
                return;
            }
            String message = DynamoDbUtils.getS(item, MESSAGE);
            if (message == null) {
                return;
            }
            Object event = new Json().fromJson(message, desc.getType());
            for (PersistenceListener listener : desc) {
                listener.eventReceived(event);
            }
        }
        catch (Throwable th) {
            PersistenceLogger.LOGGER.error(th);
        }
    }

    <T> void send(T event, String clientID) {
        String type = event.getClass().getName();
        String message = new Json().toJson(event);
        HashMap<String, AttributeValue> item = new HashMap<String, AttributeValue>();
        item.put(ID, AttributeValue.fromS((String)GUID.generateNew().toString()));
        item.put(CLIENT, AttributeValue.fromS((String)clientID));
        item.put(TYPE, AttributeValue.fromS((String)type));
        item.put(MESSAGE, AttributeValue.fromS((String)message));
        item.put(TTL, AttributeValue.fromN((String)String.valueOf(System.currentTimeMillis() / 1000L + 60L)));
        DynamoDbUtils.putItem(this.tableName, item);
    }
}

