/*
 * Decompiled with CFR 0.152.
 */
package com.inet.excel.parser;

public class SheetDimension {
    private final int firstColumnIndex;
    private final int lastColumnIndex;

    public SheetDimension(int firstColumnIndex, int lastColumnIndex) {
        if (firstColumnIndex < 1) {
            throw new IllegalArgumentException("firstColumnIndex must be greater than zero");
        }
        if (lastColumnIndex < 1) {
            throw new IllegalArgumentException("lastColumnIndex must be greater than zero");
        }
        if (firstColumnIndex > lastColumnIndex) {
            throw new IllegalArgumentException("firstColumnIndex  must be smaller than or equal to lastColumnIndex");
        }
        this.firstColumnIndex = firstColumnIndex;
        this.lastColumnIndex = lastColumnIndex;
    }

    public static SheetDimension parse(String ref) {
        if (ref == null) {
            return null;
        }
        try {
            String[] range = ref.split(":");
            if (range.length == 1 && !ref.contains(":")) {
                int index = SheetDimension.getColumnIndexFromCellRef(range[0]);
                if (index == 0) {
                    return null;
                }
                return new SheetDimension(index, index);
            }
            if (range.length == 2) {
                int first = SheetDimension.getColumnIndexFromCellRef(range[0]);
                int last = SheetDimension.getColumnIndexFromCellRef(range[1]);
                if (first == 0 || last == 0) {
                    return null;
                }
                return new SheetDimension(first, last);
            }
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static int getColumnIndexFromCellRef(String cellRef) {
        int result = 0;
        if (cellRef != null) {
            for (int index = 0; index < cellRef.length(); ++index) {
                char c = cellRef.charAt(index);
                if (c < 'A' || c > 'Z') {
                    return result;
                }
                result = result * 26 + (c - 65 + 1);
            }
        }
        return result;
    }

    public int getFirstColumnIndex() {
        return this.firstColumnIndex;
    }

    public int getLastColumnIndex() {
        return this.lastColumnIndex;
    }
}

