/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api.groups;

import com.inet.annotations.InternalApi;
import com.inet.config.ConfigurationManager;
import com.inet.id.GUID;
import com.inet.permissions.Permission;
import com.inet.plugin.ServerPluginManager;
import com.inet.search.SearchResult;
import com.inet.search.SearchTag;
import com.inet.search.command.SearchExpression;
import com.inet.search.command.SearchID;
import com.inet.search.command.TokenMatcher;
import com.inet.search.index.IndexSearchEngine;
import com.inet.search.veto.SearchIndexVeto;
import com.inet.search.veto.UserSearchIndexVetoPower;
import com.inet.usersandgroups.api.BaseUserGroupManagerFactory;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.UserGroupManagerFactory;
import com.inet.usersandgroups.api.UserManagerFactory;
import com.inet.usersandgroups.api.groups.GroupType;
import com.inet.usersandgroups.api.groups.MembershipType;
import com.inet.usersandgroups.api.groups.MutableUserGroupData;
import com.inet.usersandgroups.api.groups.UserGroupEventListener;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupKey;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public abstract class UserGroupManager {
    private static boolean a;
    private static SearchIndexVeto b;
    private static UserSearchIndexVetoPower c;

    public static UserSearchIndexVetoPower getVetoPower() {
        return c;
    }

    private static void a() {
        if (a) {
            return;
        }
        ServerPluginManager.getInstance().getOptionalInstance(UserManagerFactory.class);
        a = true;
    }

    public static UserGroupManager getInstance() {
        UserGroupManager.a();
        return com.inet.usersandgroups.api.groups.UserGroupManager$a.a;
    }

    public static UserGroupManager getRecoveryEnabledInstance() {
        UserGroupManager.a();
        return com.inet.usersandgroups.api.groups.UserGroupManager$a.b;
    }

    public abstract GUID createGroup(String var1, GroupType var2, MutableUserGroupData var3);

    public abstract GUID createGroup(@Nullable GUID var1, String var2, GroupType var3, MutableUserGroupData var4);

    public abstract void setParentGroup(@Nonnull GUID var1, @Nullable GUID var2);

    public abstract void deleteGroup(GUID var1);

    public abstract void deactivateGroup(GUID var1, boolean var2);

    public abstract void renameGroup(GUID var1, String var2);

    public abstract void addUserToGroup(GUID var1, GUID var2, MembershipType ... var3);

    public abstract void removeUserFromGroup(GUID var1, GUID var2, MembershipType ... var3);

    public abstract void updateGroupData(GUID var1, MutableUserGroupData var2);

    public abstract void updateGroupMembers(GUID var1, Map<GUID, Set<MembershipType>> var2, Map<GUID, Set<MembershipType>> var3);

    public abstract void updateUserGroupMembership(GUID var1, Map<GUID, Set<MembershipType>> var2, Map<GUID, Set<MembershipType>> var3);

    public abstract void updateGroupPermissions(GUID var1, Set<Permission> var2, Set<Permission> var3);

    public abstract void removeUserFromAllGroups(GUID var1);

    @Nonnull
    public abstract Map<String, String> getAllGroupDisplayNames();

    public abstract Set<UserGroupInfo> getAllGroups();

    public abstract Set<UserGroupInfo> getAllGroupsIncludingDeactivated();

    public abstract Set<UserGroupInfo> getGroups(GroupType var1);

    public abstract Set<UserGroupInfo> getGroupsIncludingDeactivated(GroupType var1);

    public Set<UserGroupInfo> getGroupsForUser(GUID userAccountID) {
        return this.getGroupsForUser(userAccountID, false, true);
    }

    public Set<UserGroupInfo> getGroupsForUserIncludingDeactivated(GUID userAccountID) {
        return this.getGroupsForUser(userAccountID, true, true);
    }

    public abstract Set<UserGroupInfo> getGroupsForUser(GUID var1, boolean var2, boolean var3);

    public abstract UserGroupInfo getGroup(GUID var1);

    public abstract UserGroupInfo getGroup(String var1, GroupType var2);

    public UserGroupInfo getGroup(@Nonnull UserGroupKey groupKey) {
        return this.getGroup(groupKey.getName(), groupKey.getType());
    }

    public abstract void registerListener(UserGroupEventListener var1);

    public abstract void unregisterListener(UserGroupEventListener var1);

    public abstract List<UserGroupField<?>> getAllFields();

    public abstract <T> UserGroupField<T> getField(String var1);

    public abstract SearchResult<GUID> search(String var1, List<SearchExpression> var2, List<SearchExpression> var3, int var4, SearchID var5, @Nonnull Set<SearchTag> var6, @Nullable List<TokenMatcher<GUID>> var7);

    public abstract SearchResult<GUID> search(String var1, List<SearchExpression> var2, List<SearchExpression> var3, int var4, SearchID var5);

    public abstract IndexSearchEngine<GUID> getSearchEngine();

    public int getIndexCount() {
        IndexSearchEngine<GUID> indexSearchEngine = this.getSearchEngine();
        return indexSearchEngine.getIndexCountOfIDs();
    }

    public void hardReset() throws IOException {
        throw new UnsupportedOperationException();
    }

    public String getFullDisplayName(@Nonnull UserGroupInfo groupInfo) {
        UserGroupInfo userGroupInfo;
        GUID gUID = groupInfo.getParentID();
        UserGroupInfo userGroupInfo2 = userGroupInfo = gUID == null ? null : this.getGroup(gUID);
        if (userGroupInfo == null) {
            return groupInfo.getDisplayName();
        }
        return this.getFullDisplayName(userGroupInfo) + " \\ " + groupInfo.getDisplayName();
    }

    static {
        b = new SearchIndexVeto("User Group Search Index");
        c = new UserSearchIndexVetoPower(b, () -> {
            UserGroupManager.getInstance();
            UserGroupManager.getRecoveryEnabledInstance();
        });
    }

    private static class a {
        private static UserGroupManager a = com.inet.usersandgroups.api.groups.UserGroupManager$a.a(false);
        private static UserGroupManager b = com.inet.usersandgroups.api.groups.UserGroupManager$a.a(true);

        private static UserGroupManager a(boolean bl) {
            if (ConfigurationManager.isHelpCenterMode()) {
                return bl ? a : com.inet.usersandgroups.api.groups.UserGroupManager$a.a();
            }
            if (ConfigurationManager.isRecoveryMode()) {
                if (bl) {
                    return com.inet.usersandgroups.api.groups.UserGroupManager$a.b(bl);
                }
                return com.inet.usersandgroups.api.groups.UserGroupManager$a.a();
            }
            return bl ? a : com.inet.usersandgroups.api.groups.UserGroupManager$a.b(bl);
        }

        private static UserGroupManager a() {
            return new BaseUserGroupManagerFactory().createManager(false, null);
        }

        private static UserGroupManager b(boolean bl) {
            UserGroupManagerFactory userGroupManagerFactory = ServerPluginManager.getInstance().getOptionalInstance(UserGroupManagerFactory.class);
            if (userGroupManagerFactory == null) {
                userGroupManagerFactory = new BaseUserGroupManagerFactory();
            }
            return userGroupManagerFactory.createManager(bl, b);
        }
    }
}

