/*
 * Decompiled with CFR 0.152.
 */
package com.inet.shared.utils;

import com.inet.shared.utils.BlendComposite;
import com.inet.shared.utils.GraphicLayer;
import com.inet.shared.utils.GraphicLayerNormal;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.DataBufferInt;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.LinkedList;
import java.util.Map;

public class LayerGraphics2D
extends Graphics2D {
    private Graphics2D a;
    private Rectangle2D b;
    private BufferedImage c;
    private Graphics2D d;
    private AffineTransform e = new AffineTransform();
    private LinkedList<GraphicLayer> f = new LinkedList();
    private boolean g = false;
    public static int MAXSIZE = 2024;

    private Graphics2D a(boolean bl) throws UnsupportedOperationException {
        if (this.f.isEmpty()) {
            if (this.a == null) {
                throw new UnsupportedOperationException("Target graphic not set!");
            }
            return this.a;
        }
        return this.f.peekLast().a(bl);
    }

    public boolean hasGraphics() {
        return this.a != null;
    }

    public void setGraphics(Graphics2D graphics2D) {
        this.a = graphics2D;
        if (this.d != null) {
            LayerGraphics2D.copyGraphicSettings(graphics2D, this.d);
        }
    }

    public Graphics2D getRootGraphics() {
        return this.a;
    }

    public void setInitialInformation(Rectangle2D imgBound, AffineTransform initialTransformation) throws UnsupportedOperationException {
        if (this.g) {
            throw new UnsupportedOperationException("Layergraphic can only on time initalize");
        }
        if (imgBound == null) {
            throw new UnsupportedOperationException("Image size can not be null!");
        }
        if (this.a != null && !(this.a.getTransform().getScaleX() < 1.0) && !(this.a.getTransform().getScaleY() < 1.0)) {
            imgBound = new Rectangle2D.Double(imgBound.getX(), imgBound.getY(), Math.min((double)MAXSIZE, Math.abs(imgBound.getWidth() * this.a.getTransform().getScaleX())), Math.min((double)MAXSIZE, Math.abs(imgBound.getHeight() * this.a.getTransform().getScaleY())));
        }
        this.b = imgBound;
        this.e = initialTransformation;
        this.c = this.b();
        this.g = true;
        this.d = this.c.createGraphics();
        if (this.a != null) {
            LayerGraphics2D.copyGraphicSettings(this.a, this.d);
        }
    }

    public int getNumOfLayers() {
        return this.f.size();
    }

    public void addLayer(boolean knockout, boolean isolate, BlendComposite composite) throws UnsupportedOperationException {
        if (!this.g) {
            throw new UnsupportedOperationException("Layergraphic must correct initialize for work with more layers.");
        }
        GraphicLayer graphicLayer = null;
        if (composite.getMode() == BlendComposite.BlendingMode.NORMAL && composite.getAlpha() >= 1.0f && composite.getMask() == null && !isolate && !knockout) {
            GraphicLayerNormal graphicLayerNormal;
            Graphics2D graphics2D = (Graphics2D)this.a(true).create();
            if (this.f.isEmpty()) {
                graphicLayer = new GraphicLayerNormal(graphics2D, (Graphics2D)this.d.create());
            } else if (this.f.getLast() instanceof GraphicLayerNormal && (graphicLayerNormal = (GraphicLayerNormal)this.f.getLast()).getBackdropGraphics() != null) {
                graphicLayer = new GraphicLayerNormal(graphics2D, (Graphics2D)graphicLayerNormal.getBackdropGraphics().create());
            }
            if (graphicLayer == null) {
                graphicLayer = new GraphicLayerNormal(graphics2D);
            }
        } else {
            BufferedImage bufferedImage;
            if (isolate) {
                bufferedImage = new BufferedImage(this.c.getWidth(), this.c.getHeight(), 2);
            } else {
                bufferedImage = null;
                for (int i2 = this.f.size() - 1; i2 >= 0; --i2) {
                    GraphicLayer graphicLayer2 = this.f.get(i2);
                    if (graphicLayer2 instanceof GraphicLayerNormal) continue;
                    bufferedImage = graphicLayer2.b();
                    break;
                }
                if (bufferedImage == null) {
                    bufferedImage = this.c;
                }
            }
            graphicLayer = new GraphicLayer(bufferedImage, composite, this.a(true), new Rectangle2D.Double(0.0, 0.0, this.c.getWidth(), this.c.getHeight()), knockout, isolate, this.e);
        }
        this.f.add(graphicLayer);
    }

    public void paintLastLayer() throws IllegalStateException, UnsupportedOperationException {
        if (!this.g) {
            throw new UnsupportedOperationException("Layergraphic must correct initialize for work with more layers.");
        }
        if (this.f.isEmpty()) {
            throw new IllegalStateException("No more layer exist!");
        }
        GraphicLayer graphicLayer = this.f.pollLast();
        if (graphicLayer instanceof GraphicLayerNormal) {
            return;
        }
        if (this.f.isEmpty()) {
            BufferedImage bufferedImage = graphicLayer.a();
            graphicLayer.getComposite().setBackdrop(this.c);
            this.a(this.a, bufferedImage, graphicLayer.getComposite());
            this.a(this.d, bufferedImage, graphicLayer.getComposite());
        } else {
            this.f.peekLast().a(graphicLayer);
        }
    }

    private void a(Graphics2D graphics2D, BufferedImage bufferedImage, BlendComposite blendComposite) throws IllegalStateException {
        graphics2D = (Graphics2D)graphics2D.create();
        try {
            graphics2D.transform(graphics2D.getTransform().createInverse());
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        graphics2D.setComposite(blendComposite);
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.dispose();
    }

    public BufferedImage getBaseLayer() {
        return this.c;
    }

    public BufferedImage getCurrentState() {
        BufferedImage bufferedImage = new BufferedImage(this.c.getWidth(), this.c.getHeight(), 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage((Image)this.c, 0, 0, null);
        for (GraphicLayer graphicLayer : this.f) {
            if (graphicLayer instanceof GraphicLayerNormal) continue;
            graphics2D.setComposite(graphicLayer.getComposite());
            graphics2D.drawImage((Image)graphicLayer.a(), 0, 0, null);
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    @Override
    public void draw(Shape s) {
        AffineTransform affineTransform = this.getTransform();
        if (s instanceof Path2D) {
            Stroke stroke;
            boolean bl = false;
            if (this.getRenderingHint(RenderingHints.KEY_ANTIALIASING) != RenderingHints.VALUE_ANTIALIAS_OFF) {
                if (affineTransform.getShearX() != 0.0 || affineTransform.getShearY() != 0.0) {
                    bl = true;
                } else {
                    double d2;
                    double d3 = affineTransform.getScaleX();
                    if (d3 != (d2 = affineTransform.getScaleY()) && Math.abs(d3) != Math.abs(d2)) {
                        if (Math.abs(Math.abs(d3) - Math.abs(d2)) < 0.005) {
                            double d4 = Math.signum(d3);
                            double d5 = Math.signum(d2);
                            double d6 = (Math.abs(d3) + Math.abs(d2)) / 2.0;
                            d3 = d4 > 0.0 ? d6 : -d6;
                            d2 = d5 > 0.0 ? d6 : -d6;
                            affineTransform = new AffineTransform(d3, 0.0, 0.0, d2, affineTransform.getTranslateX(), affineTransform.getTranslateY());
                            this.setTransform(affineTransform);
                        } else {
                            bl = true;
                        }
                    }
                }
            }
            if (bl && (stroke = this.getStroke()) != null) {
                this.fill(stroke.createStrokedShape(s));
                return;
            }
        }
        if (this.f.isEmpty() && this.d != null) {
            this.d.draw(s);
        }
        this.a(true).draw(s);
    }

    @Override
    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        if (this.f.isEmpty() && this.d != null) {
            this.d.drawImage(this.a(img, this.d), xform, obs);
        }
        return this.a(true).drawImage(this.a(img, this.a(true)), xform, obs);
    }

    private Image a(Image image, Graphics2D graphics2D) {
        try {
            if (graphics2D.getDeviceConfiguration().getDevice().getType() != 2) {
                return image;
            }
        }
        catch (Exception exception) {
            return image;
        }
        if (image instanceof BufferedImage && ((BufferedImage)image).getType() == 0) {
            return Toolkit.getDefaultToolkit().createImage(image.getSource());
        }
        return image;
    }

    @Override
    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        if (this.f.isEmpty() && this.d != null) {
            this.d.drawImage(img, op, x, y);
        }
        this.a(true).drawImage(img, op, x, y);
    }

    @Override
    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        if (this.f.isEmpty() && this.d != null) {
            this.d.drawRenderedImage(img, xform);
        }
        this.a(true).drawRenderedImage(img, xform);
    }

    @Override
    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        if (this.f.isEmpty() && this.d != null) {
            this.d.drawRenderableImage(img, xform);
        }
        this.a(true).drawRenderableImage(img, xform);
    }

    @Override
    public void drawString(String str, int x, int y) {
        if (this.f.isEmpty() && this.d != null) {
            this.d.drawString(str, x, y);
        }
        this.a(true).drawString(str, x, y);
    }

    @Override
    public void drawString(String str, float x, float y) {
        if (this.f.isEmpty() && this.d != null) {
            this.d.drawString(str, x, y);
        }
        this.a(true).drawString(str, x, y);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        if (this.f.isEmpty() && this.d != null) {
            this.d.drawString(iterator, x, y);
        }
        this.a(true).drawString(iterator, x, y);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        if (this.f.isEmpty() && this.d != null) {
            this.d.drawImage(this.a(img, this.d), x, y, observer);
        }
        return this.a(true).drawImage(this.a(img, this.a(true)), x, y, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        if (this.f.isEmpty() && this.d != null) {
            this.d.drawImage(this.a(img, this.d), x, y, width, height, observer);
        }
        return this.a(true).drawImage(this.a(img, this.a(true)), x, y, width, height, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        if (this.f.isEmpty() && this.d != null) {
            this.d.drawImage(this.a(img, this.d), x, y, bgcolor, observer);
        }
        return this.a(true).drawImage(this.a(img, this.a(true)), x, y, bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        if (this.f.isEmpty() && this.d != null) {
            this.d.drawImage(this.a(img, this.d), x, y, width, height, bgcolor, observer);
        }
        return this.a(true).drawImage(this.a(img, this.a(true)), x, y, width, height, bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        if (this.f.isEmpty() && this.d != null) {
            this.d.drawImage(this.a(img, this.d), dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
        }
        return this.a(true).drawImage(this.a(img, this.a(true)), dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        if (this.f.isEmpty() && this.d != null) {
            this.d.drawImage(this.a(img, this.d), dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, bgcolor, observer);
        }
        return this.a(true).drawImage(this.a(img, this.a(true)), dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, bgcolor, observer);
    }

    @Override
    public void dispose() {
        if (this.f.isEmpty() && this.d != null) {
            this.d.dispose();
        }
        this.a(false).dispose();
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        if (this.f.isEmpty() && this.d != null) {
            this.d.drawString(iterator, x, y);
        }
        this.a(true).drawString(iterator, x, y);
    }

    @Override
    public void drawGlyphVector(GlyphVector g2, float x, float y) {
        if (this.f.isEmpty() && this.d != null) {
            this.d.drawGlyphVector(g2, x, y);
        }
        this.a(true).drawGlyphVector(g2, x, y);
    }

    @Override
    public void fill(Shape s) {
        if (this.f.isEmpty() && this.d != null) {
            this.d.fill(s);
        }
        Composite composite = this.a(false).getComposite();
        this.a();
        this.a(true).fill(s);
        this.a(false).setComposite(composite);
    }

    private void a() {
        BlendComposite blendComposite;
        Composite composite = this.a(false).getComposite();
        if (composite instanceof BlendComposite && this.b != null && (blendComposite = (BlendComposite)composite).getMask() != null) {
            BufferedImage bufferedImage = new BufferedImage((int)Math.round(this.b.getWidth()), (int)Math.round(this.b.getHeight()), 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            LayerGraphics2D.copyGraphicSettings(this.a(false), graphics2D);
            graphics2D.transform(this.e);
            graphics2D.drawImage((Image)blendComposite.getMask(), 0, 0, null);
            graphics2D.dispose();
            int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
            int n2 = Color.BLACK.getRGB();
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                if (nArray[i2] != 0) continue;
                nArray[i2] = n2;
            }
            BlendComposite blendComposite2 = new BlendComposite(blendComposite.getMode(), blendComposite.getAlpha(), bufferedImage);
            blendComposite2.setBackdrop(blendComposite.getBackdrop());
            this.a(false).setComposite(blendComposite2);
        }
    }

    @Override
    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        if (this.f.isEmpty() && this.d != null) {
            this.d.hit(rect, s, onStroke);
        }
        return this.a(false).hit(rect, s, onStroke);
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return this.a(false).getDeviceConfiguration();
    }

    @Override
    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        if (this.f.isEmpty() && this.d != null) {
            this.d.setRenderingHint(hintKey, hintValue);
        }
        this.a(false).setRenderingHint(hintKey, hintValue);
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return this.a(false).getRenderingHint(hintKey);
    }

    @Override
    public void addRenderingHints(Map<?, ?> hints) {
        if (this.f.isEmpty() && this.d != null) {
            this.d.addRenderingHints(hints);
        }
        this.a(false).addRenderingHints(hints);
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.a(false).getRenderingHints();
    }

    @Override
    public void setRenderingHints(Map<?, ?> hints) {
        if (this.f.isEmpty() && this.d != null) {
            this.d.setRenderingHints(hints);
        }
        this.a(false).setRenderingHints(hints);
    }

    @Override
    public Graphics create() {
        LayerGraphics2D layerGraphics2D = new LayerGraphics2D();
        layerGraphics2D.a = (Graphics2D)this.a.create();
        layerGraphics2D.b = this.b;
        layerGraphics2D.e = this.e;
        for (GraphicLayer graphicLayer : this.f) {
            layerGraphics2D.f.add(graphicLayer.c());
        }
        for (GraphicLayer graphicLayer : layerGraphics2D.f) {
            graphicLayer.d();
        }
        layerGraphics2D.c = this.c;
        if (this.d != null) {
            layerGraphics2D.d = (Graphics2D)this.d.create();
        }
        layerGraphics2D.g = this.g;
        return layerGraphics2D;
    }

    @Override
    public void translate(int x, int y) {
        if (this.f.isEmpty() && this.d != null) {
            this.d.translate(x, y);
        }
        this.a(false).translate(x, y);
    }

    @Override
    public Color getColor() {
        return this.a(false).getColor();
    }

    @Override
    public void setColor(Color c2) {
        if (this.f.isEmpty() && this.d != null) {
            this.d.setColor(c2);
        }
        this.a(false).setColor(c2);
    }

    @Override
    public void setPaintMode() {
        if (this.f.isEmpty() && this.d != null) {
            this.d.setPaintMode();
        }
        this.a(false).setPaintMode();
    }

    @Override
    public void setXORMode(Color c1) {
        if (this.f.isEmpty() && this.d != null) {
            this.d.setXORMode(c1);
        }
        this.a(false).setXORMode(c1);
    }

    @Override
    public Font getFont() {
        return this.a(false).getFont();
    }

    @Override
    public void setFont(Font font) {
        if (this.f.isEmpty() && this.d != null) {
            this.d.setFont(font);
        }
        this.a(false).setFont(font);
    }

    @Override
    public FontMetrics getFontMetrics(Font f2) {
        return this.a(false).getFontMetrics();
    }

    @Override
    public Rectangle getClipBounds() {
        return this.a(false).getClipBounds();
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
        this.a(false).clipRect(x, y, width, height);
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        this.a(false).clipRect(x, y, width, height);
    }

    @Override
    public Shape getClip() {
        return this.a(false).getClip();
    }

    @Override
    public void setClip(Shape clip) {
        this.a(false).setClip(clip);
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        if (this.f.isEmpty() && this.d != null) {
            this.d.copyArea(x, y, width, height, dx, dy);
        }
        this.a(false).copyArea(x, y, width, height, dx, dy);
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        if (this.f.isEmpty() && this.d != null) {
            this.d.drawLine(x1, y1, x2, y2);
        }
        this.a(true).drawLine(x1, y1, x2, y2);
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        if (this.f.isEmpty() && this.d != null) {
            this.d.fillRect(x, y, width, height);
        }
        this.a(true).fillRect(x, y, width, height);
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        if (this.f.isEmpty() && this.d != null) {
            this.d.clearRect(x, y, width, height);
        }
        this.a(true).clearRect(x, y, width, height);
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (this.f.isEmpty() && this.d != null) {
            this.d.drawRoundRect(x, y, width, height, arcWidth, arcHeight);
        }
        this.a(true).drawRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (this.f.isEmpty() && this.d != null) {
            this.d.fillRoundRect(x, y, width, height, arcWidth, arcHeight);
        }
        this.a(true).fillRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        if (this.f.isEmpty() && this.d != null) {
            this.d.drawOval(x, y, width, height);
        }
        this.a(true).drawOval(x, y, width, height);
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        if (this.f.isEmpty() && this.d != null) {
            this.d.fillOval(x, y, width, height);
        }
        this.a(true).fillOval(x, y, width, height);
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        if (this.f.isEmpty() && this.d != null) {
            this.d.drawArc(x, y, width, height, startAngle, arcAngle);
        }
        this.a(true).drawArc(x, y, width, height, startAngle, arcAngle);
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        if (this.f.isEmpty() && this.d != null) {
            this.d.fillArc(x, y, width, height, startAngle, arcAngle);
        }
        this.a(true).fillArc(x, y, width, height, startAngle, arcAngle);
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        if (this.f.isEmpty() && this.d != null) {
            this.d.drawPolyline(xPoints, yPoints, nPoints);
        }
        this.a(true).drawPolyline(xPoints, yPoints, nPoints);
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        if (this.f.isEmpty() && this.d != null) {
            this.d.drawPolygon(xPoints, yPoints, nPoints);
        }
        this.a(true).drawPolygon(xPoints, yPoints, nPoints);
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        if (this.f.isEmpty() && this.d != null) {
            this.d.fillPolygon(xPoints, yPoints, nPoints);
        }
        this.a(true).fillPolygon(xPoints, yPoints, nPoints);
    }

    @Override
    public void translate(double tx, double ty) {
        if (this.f.isEmpty() && this.d != null) {
            this.d.translate(tx, ty);
        }
        this.a(false).translate(tx, ty);
    }

    @Override
    public void rotate(double theta) {
        if (this.f.isEmpty() && this.d != null) {
            this.d.rotate(theta);
        }
        this.a(false).rotate(theta);
    }

    @Override
    public void rotate(double theta, double x, double y) {
        if (this.f.isEmpty() && this.d != null) {
            this.d.rotate(theta, x, y);
        }
        this.a(false).rotate(theta, x, y);
    }

    @Override
    public void scale(double sx, double sy) {
        if (this.f.isEmpty() && this.d != null) {
            this.d.scale(sx, sy);
        }
        this.a(false).scale(sx, sy);
    }

    @Override
    public void shear(double shx, double shy) {
        if (this.f.isEmpty() && this.d != null) {
            this.d.shear(shx, shy);
        }
        this.a(false).shear(shx, shy);
    }

    @Override
    public void transform(AffineTransform Tx) {
        if (this.f.isEmpty() && this.d != null) {
            this.d.transform(Tx);
        }
        this.a(false).transform(Tx);
    }

    @Override
    public AffineTransform getTransform() {
        AffineTransform affineTransform = this.a(false).getTransform();
        if (!this.f.isEmpty()) {
            AffineTransform affineTransform2 = this.f.peekLast().getPreviousLayerTransformation();
            try {
                affineTransform.concatenate(affineTransform2.createInverse());
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                // empty catch block
            }
        }
        return affineTransform;
    }

    @Override
    public void setTransform(AffineTransform Tx) {
        if (this.f.isEmpty() && this.d != null) {
            this.d.setTransform(Tx);
        }
        if (this.f.isEmpty()) {
            this.a(false).setTransform(Tx);
        } else {
            AffineTransform affineTransform = this.f.peekLast().getPreviousLayerTransformation();
            affineTransform.concatenate(Tx);
            this.a(false).setTransform(affineTransform);
        }
    }

    @Override
    public Paint getPaint() {
        return this.a(false).getPaint();
    }

    @Override
    public void setPaint(Paint paint) {
        if (this.f.isEmpty() && this.d != null) {
            this.d.setPaint(paint);
        }
        this.a(false).setPaint(paint);
    }

    @Override
    public Composite getComposite() {
        return this.a(true).getComposite();
    }

    @Override
    public void setComposite(Composite comp) {
        GraphicLayer graphicLayer;
        BlendComposite blendComposite;
        if (comp instanceof BlendComposite && (blendComposite = (BlendComposite)comp).getMode() == BlendComposite.BlendingMode.NORMAL && blendComposite.getBackdrop() == null && blendComposite.getMask() == null && ((graphicLayer = this.f.peekLast()) == null || graphicLayer.getClass() == GraphicLayerNormal.class)) {
            comp = AlphaComposite.getInstance(3, blendComposite.getAlpha());
        }
        if (this.f.isEmpty() && this.d != null) {
            this.d.setComposite(comp);
        }
        if (this.f.peekLast() == null) {
            this.a(false).setComposite(comp);
        } else {
            this.f.peekLast().a(comp);
        }
    }

    @Override
    public Color getBackground() {
        return this.a(false).getBackground();
    }

    @Override
    public void setBackground(Color color) {
        if (this.f.isEmpty() && this.d != null) {
            this.d.setBackground(color);
        }
        this.a(false).setBackground(color);
    }

    @Override
    public Stroke getStroke() {
        return this.a(false).getStroke();
    }

    @Override
    public void setStroke(Stroke s) {
        if (this.f.isEmpty() && this.d != null) {
            this.d.setStroke(s);
        }
        this.a(false).setStroke(s);
    }

    @Override
    public void clip(Shape s) {
        this.a(false).clip(s);
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.a(false).getFontRenderContext();
    }

    private BufferedImage b() {
        return new BufferedImage((int)Math.ceil(this.b.getWidth()), (int)Math.ceil(this.b.getHeight()), 2);
    }

    public static void copyGraphicSettings(Graphics2D from, Graphics2D to) {
        to.setTransform(from.getTransform());
        to.setFont(from.getFont());
        to.setColor(from.getColor());
        to.setPaint(from.getPaint());
        if (from.getBackground() != null) {
            to.setBackground(from.getBackground());
        }
        to.setStroke(from.getStroke());
        to.setRenderingHints(from.getRenderingHints());
    }
}

