/*
 * Decompiled with CFR 0.152.
 */
package com.inet.search.tokenizers;

import com.inet.annotations.InternalApi;
import com.inet.lib.util.StringFunctions;
import com.inet.search.tokenizers.TextSearchTokenizer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;

@InternalApi
public class HtmlSearchTokenizer
extends TextSearchTokenizer {
    private static final Set<String> a = new HashSet<String>(Arrays.asList("head", "script", "title", "applet"));

    @Override
    public Set<String> tokens(@Nullable Object value, int type) {
        if (value == null) {
            return Collections.emptySet();
        }
        HashSet<String> hashSet = new HashSet<String>();
        String string = value.toString();
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        int n5 = string.length();
        block4: for (int i2 = 0; i2 < n5; ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '<': {
                    if (n4 > 0) {
                        --n4;
                    } else if (i2 > n3) {
                        this.addTo(hashSet, StringFunctions.decodeHTML(string.substring(n3, i2)), type);
                    }
                    n2 = i2;
                    continue block4;
                }
                case '>': {
                    if (n2 < 0) continue block4;
                    String string2 = string.substring(n2 + 1, i2);
                    String[] stringArray = string2.split(" ");
                    if (stringArray.length > 0) {
                        String string3 = stringArray[0].toLowerCase();
                        if (a.contains(string3)) {
                            ++n4;
                        } else if ("body".equals(string3)) {
                            n4 = 0;
                        }
                    }
                    n3 = i2 + 1;
                    n2 = -1;
                    continue block4;
                }
            }
        }
        if (n5 > n3) {
            this.addTo(hashSet, StringFunctions.decodeHTML(string.substring(n3, n5)), type);
        }
        return this.normalize(hashSet);
    }
}

