/*
 * Decompiled with CFR 0.152.
 */
package com.inet.http.websocket;

import com.inet.annotations.InternalApi;
import com.inet.http.OriginChecker;
import com.inet.http.servlet.ClientLocale;
import com.inet.http.servlet.ClientTimezone;
import com.inet.plugin.ServerPluginManager;
import jakarta.servlet.http.HttpSession;
import jakarta.websocket.Extension;
import jakarta.websocket.HandshakeResponse;
import jakarta.websocket.server.HandshakeRequest;
import jakarta.websocket.server.ServerEndpointConfig;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

@InternalApi
public class GetHttpSessionConfigurator
extends ServerEndpointConfig.Configurator {
    private boolean a;
    private OriginChecker b;

    @Override
    public void modifyHandshake(ServerEndpointConfig config, HandshakeRequest request, HandshakeResponse response) {
        super.modifyHandshake(config, request, response);
        HttpSession httpSession = (HttpSession)request.getHttpSession();
        Map map = config.getUserProperties();
        map.put(HttpSession.class.getName(), httpSession);
        Locale locale = (Locale)httpSession.getAttribute(Locale.class.getName());
        if (locale == null) {
            locale = Locale.getDefault();
        }
        map.put(Locale.class.getName(), locale);
        ClientLocale.setThreadLocale(locale);
        TimeZone timeZone = (TimeZone)httpSession.getAttribute(TimeZone.class.getName());
        if (timeZone == null) {
            timeZone = TimeZone.getDefault();
        }
        map.put(TimeZone.class.getName(), timeZone);
        ClientTimezone.setTimeZone(timeZone);
    }

    @Override
    public boolean checkOrigin(String originHeaderValue) {
        OriginChecker originChecker = this.b;
        if (originChecker != null) {
            return originChecker.checkOrigin(originHeaderValue);
        }
        if (this.a) {
            return super.checkOrigin(originHeaderValue);
        }
        this.b = ServerPluginManager.getInstance().getOptionalInstance(OriginChecker.class);
        this.a = true;
        return this.checkOrigin(originHeaderValue);
    }

    @Override
    public <T> T getEndpointInstance(Class<T> endpointClass) throws InstantiationException {
        try {
            return endpointClass.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            InstantiationException instantiationException = new InstantiationException(illegalAccessException.getMessage());
            instantiationException.initCause(illegalAccessException);
            throw instantiationException;
        }
    }

    @Override
    public List<Extension> getNegotiatedExtensions(List<Extension> installed, List<Extension> requested) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public String getNegotiatedSubprotocol(List<String> supported, List<String> requested) {
        return "";
    }
}

