/*
 * Decompiled with CFR 0.152.
 */
package com.inet.field.fieldtypes;

import com.inet.field.fieldtypes.FieldOperator;
import com.inet.field.fieldtypes.FieldType;
import com.inet.field.fieldtypes.FieldTypeFactory;
import com.inet.http.servlet.ClientLocale;
import com.inet.search.SearchDataType;
import com.inet.search.SearchTag;
import com.inet.search.tokenizers.TextSearchTokenizer;
import java.text.NumberFormat;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FieldTypeDouble
extends FieldType<Double> {
    public FieldTypeDouble(String key, Supplier<String> displayname) {
        super(key, displayname);
    }

    @Override
    @Nullable
    public String getDisplayValue(@Nullable Double value) {
        if (value == null) {
            return null;
        }
        return NumberFormat.getNumberInstance(ClientLocale.getThreadLocale()).format(value);
    }

    @Override
    public SearchTag createSearchTag(Supplier<String> labelProvider, @Nonnull FieldTypeFactory fieldTypeFactory) {
        return fieldTypeFactory.applyConfiguredChangesToSearchTag(new SearchTag(this.getKey(), SearchDataType.Double, true, TextSearchTokenizer.DEFAULT, 100, labelProvider, true));
    }

    public static FieldTypeDouble withoutSearchtag(String key) {
        return new FieldTypeDouble(key, () -> null){

            @Override
            public SearchTag createSearchTag(Supplier<String> displayname, @Nonnull FieldTypeFactory fieldTypeFactory) {
                return null;
            }
        };
    }

    @Override
    @Nullable
    public Double valueOf(@Nullable String stringRepresentation) {
        if (stringRepresentation == null || stringRepresentation.isEmpty()) {
            return null;
        }
        return Double.valueOf(stringRepresentation);
    }

    @Override
    public Set<FieldOperator> getSupportedOperators() {
        return Set.of(FieldOperator.EQUALS, FieldOperator.EQUALS_NOT, FieldOperator.LESS_THAN, FieldOperator.GREATER_THAN, FieldOperator.GREATER_OR_EQUAL, FieldOperator.LESS_OR_EQUAL, FieldOperator.IS_NOT_EMPTY);
    }
}

