/*
 * Decompiled with CFR 0.152.
 */
package com.inet.classloader;

import com.inet.annotations.InternalApi;
import com.inet.classloader.LoaderUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@InternalApi
public abstract class ObjectStreams {
    private static final ConcurrentMap<String, Class<?>> a = new ConcurrentHashMap();

    private ObjectStreams() {
    }

    public static class CacheObjectInputStream
    extends ObjectInputStream {
        private Class<?> a;

        public CacheObjectInputStream(InputStream in) throws IOException {
            super(in);
        }

        @Override
        protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
            ObjectStreamClass objectStreamClass;
            ObjectStreamClass objectStreamClass2 = super.readClassDescriptor();
            Class<?> clazz = this.resolveClass(objectStreamClass2);
            if (clazz != null && (objectStreamClass = ObjectStreamClass.lookup(clazz)) != null) {
                objectStreamClass2 = objectStreamClass;
            }
            return objectStreamClass2;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            Class<?> clazz = (Class<?>)a.get(desc.getName());
            if (clazz != null) {
                this.a = clazz;
                return this.a;
            }
            try {
                this.a = super.resolveClass(desc);
                return this.a;
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    String string = desc.getName();
                    clazz = LoaderUtils.classForName(string, null);
                    a.put(string, clazz);
                    this.a = clazz;
                    return this.a;
                }
                catch (Throwable throwable) {
                    throw classNotFoundException;
                }
            }
        }

        public Class<?> lastResolvedClass() {
            return this.a;
        }
    }

    public static class CacheObjectOutputStream
    extends ObjectOutputStream {
        public CacheObjectOutputStream(OutputStream out) throws IOException {
            super(out);
        }

        @Override
        protected void writeClassDescriptor(ObjectStreamClass desc) throws IOException {
            Class<?> clazz = desc.forClass();
            if (clazz.getClassLoader() != null) {
                a.putIfAbsent(clazz.getName(), clazz);
            }
            super.writeClassDescriptor(desc);
        }
    }
}

