/*
 * Decompiled with CFR 0.152.
 */
package com.inet.cache.internal;

import com.inet.cache.CacheStrategy;
import com.inet.cache.DataMapEntry;
import com.inet.cache.MemorySize;
import com.inet.cache.internal.ExternalData;
import com.inet.cache.internal.ExternalDataMap;
import com.inet.cache.internal.MemoryObserver;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ExternalDataMapEntry<K, V>
implements DataMapEntry<K, V> {
    private final K a;
    private V b;
    @Nonnull
    private final ExternalDataMap<K, V> c;
    private ExternalData<K, V> d;
    private long e;
    private ExternalDataMapEntry<K, V> f = this;
    private ExternalDataMapEntry<K, V> g = this;
    private ExternalDataMapEntry<K, V> h = null;

    ExternalDataMapEntry() {
        this(null, null, null, null, 0);
    }

    public ExternalDataMapEntry(@Nonnull K key, @Nonnull V value, @Nonnull ExternalDataMap<K, V> map, int timeout) {
        this(key, value, null, map, timeout);
        if (key == null) {
            throw new NullPointerException("key is null for value: " + String.valueOf(value));
        }
        if (value == null) {
            throw new NullPointerException("value is null for key: " + String.valueOf(key));
        }
    }

    public ExternalDataMapEntry(@Nonnull K key, @Nonnull ExternalData<K, V> data, @Nonnull ExternalDataMap<K, V> map, int timeout) {
        this(key, null, data, map, timeout);
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        if (data == null) {
            throw new NullPointerException("data is null for key: " + String.valueOf(key));
        }
    }

    private ExternalDataMapEntry(K key, V value, ExternalData<K, V> data, ExternalDataMap<K, V> map, int timeout) {
        this.a = key;
        this.b = value;
        this.d = data;
        this.c = map;
        this.e = timeout <= 0 ? Long.MAX_VALUE : System.currentTimeMillis() + (long)(timeout * 1000);
    }

    @Override
    public K getKey() {
        return this.a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V getValue() {
        V v = this.b;
        if (v == null) {
            ExternalDataMapEntry externalDataMapEntry = this;
            synchronized (externalDataMapEntry) {
                if (this.d == null) {
                    return null;
                }
                this.b = v = this.d.load(this);
                MemoryObserver.add(this);
            }
        }
        return v;
    }

    @Nullable
    V a() {
        return this.b;
    }

    public long getMemorySize() {
        return MemorySize.getSizeOfObject(this.b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V setValue(V newValue) {
        if (newValue == null) {
            throw new NullPointerException("value is null for key: " + String.valueOf(this.a));
        }
        V v = this.b;
        this.b = newValue;
        ExternalDataMapEntry externalDataMapEntry = this;
        synchronized (externalDataMapEntry) {
            if (this.d != null) {
                this.d.b();
                this.d = null;
            }
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void b() throws Exception {
        if (this.d == null && this.b != null) {
            ExternalDataMapEntry externalDataMapEntry = this;
            synchronized (externalDataMapEntry) {
                if (this.d == null && this.b != null) {
                    this.d = this.c.a(this.a, this.b);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long c() throws Exception {
        if (this.b == null) {
            return 0L;
        }
        ExternalData<K, V> externalData = this.d;
        if (externalData == null) {
            ExternalDataMapEntry externalDataMapEntry = this;
            synchronized (externalDataMapEntry) {
                externalData = this.d;
                if (externalData == null && this.b != null) {
                    externalData = this.c.a(this.a, this.b);
                    this.d = externalData;
                }
            }
        }
        if (externalData == null) {
            return 0L;
        }
        this.b = null;
        return externalData.a();
    }

    long d() {
        ExternalData<K, V> externalData = this.d;
        if (externalData == null) {
            return 0L;
        }
        return externalData.a();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void a(boolean bl, boolean bl2) {
        if (bl) {
            MemoryObserver.remove(this);
        }
        ExternalDataMapEntry externalDataMapEntry = this;
        synchronized (externalDataMapEntry) {
            if (this.d != null && bl2) {
                this.d.b();
            }
            this.d = null;
            this.b = null;
        }
    }

    boolean e() {
        return this.d == null && this.b == null;
    }

    boolean f() {
        return this.e == Long.MAX_VALUE && this.c.b();
    }

    boolean a(long l2) {
        return this.e != Long.MAX_VALUE && this.e < l2 && (this.c.a() == null || this.c.a().test(this));
    }

    public boolean isExpired() {
        return this.e != Long.MAX_VALUE && this.e < System.currentTimeMillis() && (this.c.a() == null || this.c.a().test(this));
    }

    public void resetExpired(int newTimeout) {
        this.e = newTimeout <= 0 ? Long.MAX_VALUE : System.currentTimeMillis() + (long)(newTimeout * 1000);
    }

    public boolean isExpired(int newTimeout) {
        if (this.e == Long.MAX_VALUE) {
            return false;
        }
        long l2 = System.currentTimeMillis();
        if (this.e < l2 && (this.c.a() == null || this.c.a().test(this))) {
            return true;
        }
        this.e = l2 + (long)(newTimeout * 1000);
        return false;
    }

    @Override
    public long timeout() {
        return this.e;
    }

    @Nonnull
    CacheStrategy g() {
        return this.c.getStrategy();
    }

    ExternalDataMap<K, V> h() {
        return this.c;
    }

    boolean i() {
        if (this.g == this && this.f == this) {
            return false;
        }
        this.f.g = this.g;
        this.g.f = this.f;
        this.g = this;
        this.f = this;
        this.h = null;
        return true;
    }

    boolean a(ExternalDataMapEntry<K, V> externalDataMapEntry) {
        return this.h == externalDataMapEntry;
    }

    void b(ExternalDataMapEntry<K, V> externalDataMapEntry) throws IllegalStateException {
        if (this.g != this && this.f != this) {
            throw new IllegalStateException("Duplicate addBefore");
        }
        this.h = externalDataMapEntry;
        this.g = externalDataMapEntry;
        this.f = externalDataMapEntry.f;
        this.f.g = this;
        this.g.f = this;
    }

    ExternalDataMapEntry<K, V> j() {
        return this.g;
    }

    @Override
    public int hashCode() {
        return this.a.hashCode();
    }
}

