/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setuplauncher;

import com.inet.setuplauncher.TrustAllTrustManager;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class SetupLauncher {
    private static final String WEB_CONFIG = "webconfig.txt";
    private static final String KEY_PROTOCOL = "PROTOCOL";
    private static final String KEY_ADDRESS = "ADDRESS";
    private static final String KEY_PORT = "PORT";
    private static final String KEY_URL = "URL";
    private static final String KEY_UUID = "UUID";
    private static final int LINUX = 0;
    private static final int WINDOWS = 1;
    private static final int MAC = 2;
    private static boolean isHeadless;
    private static boolean SKIP_SETUP_FROM_CLI;

    public static void main(String[] args) throws Exception {
        if (SKIP_SETUP_FROM_CLI) {
            System.exit(0);
        }
        isHeadless = GraphicsEnvironment.isHeadless();
        try {
            if (!isHeadless) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Exception ex = null;
        URL url = null;
        Window waitFrame = null;
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
        try {
            for (int size : new int[]{16, 24, 32, 48, 64, 96}) {
                BufferedImage img = ImageIO.read(SetupLauncher.class.getResource("images/i-net-logo-" + size + ".png"));
                if (img == null) continue;
                images.add(img);
            }
        }
        catch (Throwable th) {
            isHeadless = true;
            System.out.println("Fallback to headless because: " + th);
        }
        long time = System.currentTimeMillis() + 90000L;
        for (int i = 0; i < 10 || time > System.currentTimeMillis(); ++i) {
            try {
                HttpURLConnection conn;
                int responseCode;
                try {
                    if (waitFrame == null && i > 0 && !isHeadless) {
                        waitFrame = new JFrame("Setup Waiting");
                        ((Frame)waitFrame).setUndecorated(true);
                        waitFrame.setIconImages(images);
                        Container content = ((JFrame)waitFrame).getContentPane();
                        JComponent comp = new JPanel();
                        comp.setBorder(BorderFactory.createEtchedBorder());
                        content.add(comp);
                        content = comp;
                        comp = new JLabel("Waiting for server to start.");
                        comp.setBorder(BorderFactory.createEmptyBorder(50, 100, 50, 100));
                        content.add(comp);
                        waitFrame.pack();
                        waitFrame.setAlwaysOnTop(true);
                        waitFrame.setVisible(true);
                        waitFrame.setLocationRelativeTo(null);
                    }
                }
                catch (Throwable content) {
                    // empty catch block
                }
                Thread.sleep(100L);
                url = null;
                String path = "setup/";
                int port = 80;
                String protocol = "http";
                String address = "localhost";
                File configFile = new File(WEB_CONFIG);
                if (!configFile.exists() || configFile.length() == 0L) {
                    throw new IOException("Unable to start the server. See service log and server log for details in the install directory: " + configFile.getAbsoluteFile().getParent());
                }
                List<String> lines = Files.readAllLines(configFile.toPath(), StandardCharsets.ISO_8859_1);
                for (String line : lines) {
                    int idx = line.indexOf(32);
                    if (idx < 0) continue;
                    String key = line.substring(0, idx);
                    String value = line.substring(idx + 1);
                    switch (key) {
                        case "PROTOCOL": {
                            protocol = value;
                            break;
                        }
                        case "ADDRESS": {
                            address = value;
                            break;
                        }
                        case "PORT": {
                            port = Integer.parseInt(value);
                            break;
                        }
                        case "URL": {
                            if (!value.endsWith("/")) {
                                value = value + "/";
                            }
                            url = new URL(value);
                            break;
                        }
                        case "UUID": {
                            path = "setup/" + value;
                            break;
                        }
                    }
                }
                if (url == null) {
                    url = new URL(protocol, address, port, "/");
                }
                if ((responseCode = (conn = (HttpURLConnection)SetupLauncher.openConnectionSupportingRedirect(url, 5000)).getResponseCode()) != 200 && responseCode != 401) {
                    ex = new IOException("HTTP response: " + responseCode);
                    continue;
                }
                url = new URL(url, path);
                if (waitFrame != null) {
                    waitFrame.dispose();
                }
                SetupLauncher.showURL(url.toURI());
                Thread.sleep(100L);
                System.exit(0);
                continue;
            }
            catch (Exception e) {
                System.out.print(".");
                ex = e;
            }
        }
        if (waitFrame != null) {
            waitFrame.dispose();
        }
        if (url != null) {
            SetupLauncher.showURL(url.toURI());
        }
        if (!isHeadless) {
            try {
                JFrame frame = new JFrame("Setup Error");
                frame.setIconImages(images);
                frame.setUndecorated(true);
                frame.setAlwaysOnTop(true);
                frame.setVisible(true);
                frame.setLocationRelativeTo(null);
                StringBuilder msg = new StringBuilder();
                if (url != null) {
                    msg.append(url).append(" --> ");
                }
                if (ex instanceof IOException && ex.getMessage() != null) {
                    msg.append(ex.getMessage());
                } else {
                    msg.append(ex.toString());
                }
                JOptionPane.showMessageDialog(frame, msg.toString(), "Setup Error", 0);
                frame.dispose();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        System.out.println();
        throw ex;
    }

    private static URLConnection openConnectionSupportingRedirect(URL url, int timeout) throws Exception {
        URLConnection conn = url.openConnection();
        if (conn instanceof HttpURLConnection) {
            HttpURLConnection urlConnection = (HttpURLConnection)conn;
            int redirectCount = 0;
            while (true) {
                urlConnection.setConnectTimeout(timeout);
                urlConnection.setReadTimeout(timeout);
                urlConnection.setInstanceFollowRedirects(true);
                if (urlConnection instanceof HttpsURLConnection) {
                    HttpsURLConnection https = (HttpsURLConnection)conn;
                    https.setSSLSocketFactory(TrustAllTrustManager.getSSLSocketFactory());
                    https.setHostnameVerifier(new HostnameVerifier(){

                        @Override
                        public boolean verify(String paramString, SSLSession paramSSLSession) {
                            return true;
                        }
                    });
                }
                urlConnection.connect();
                int code = urlConnection.getResponseCode();
                if (code <= 300 || code >= 400 || code == 304 || redirectCount >= 5) break;
                String newlocation = urlConnection.getHeaderField("Location");
                urlConnection = (HttpURLConnection)new URL(newlocation).openConnection();
                conn = urlConnection;
                ++redirectCount;
            }
        }
        return conn;
    }

    private static void showURL(URI uri) {
        try {
            if (!isHeadless) {
                Desktop.getDesktop().browse(uri);
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        SetupLauncher.showDocumentOldMethod(uri);
        SetupLauncher.printConsoleInstructions(uri);
    }

    private static void printConsoleInstructions(Object uri) {
        System.out.println("\n" + new String(new char[80]).replace("\u0000", "#"));
        System.out.println("#\n#");
        System.out.println("#\tContinue setup using the following URL in a browser: ");
        System.out.println("#\t" + uri);
        System.out.println("#\n#");
        System.out.println(new String(new char[80]).replace("\u0000", "#"));
        System.out.println("\n");
    }

    private static void showDocumentOldMethod(Object url) throws RuntimeException {
        int os = SetupLauncher.getOperatingSystem();
        String urlStr = url.toString();
        try {
            switch (os) {
                case 1: {
                    String cmd = "cmd.exe /C start \"Open file\" \"" + urlStr + "\"";
                    Runtime.getRuntime().exec(cmd);
                    break;
                }
                case 2: {
                    Process processMac = Runtime.getRuntime().exec(new String[]{"open", urlStr});
                    int exitCode = processMac.waitFor();
                    if (exitCode != 0) {
                        Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                        Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                        openURL.invoke(null, url);
                    }
                    break;
                }
                default: {
                    String su_user = System.getenv("SUDO_USER");
                    String errorMessages = "";
                    String[] browserprocesses = new String[]{"su " + su_user + " -c xdg-open", "su " + su_user + " -c gnome-open", "su " + su_user + " -c kfmclient exec", "su " + su_user + " -c sensible-browser", "su " + su_user + " -c x-www-browser", "su " + su_user + " -c firefox", "xdg-open", "gnome-open", "kfmclient exec", "sensible-browser", "x-www-browser", "firefox", "google-chrome", "opera", "konqueror", "epiphany", "netscape", "mozilla"};
                    for (int p = 0; p < browserprocesses.length; ++p) {
                        try {
                            Process processLinux;
                            if (p > 0) {
                                String[] exec = browserprocesses[p].split("\\s+");
                                String[] command = new String[exec.length + 1];
                                System.arraycopy(exec, 0, command, 0, exec.length);
                                if (command[0].equals("su")) {
                                    command[command.length - 2] = command[command.length - 2] + " " + urlStr;
                                    command[command.length - 1] = "";
                                } else {
                                    command[command.length - 1] = urlStr;
                                }
                                processLinux = Runtime.getRuntime().exec(command);
                            } else {
                                processLinux = Runtime.getRuntime().exec(browserprocesses[p] + " " + urlStr);
                            }
                            processLinux.waitFor(15L, TimeUnit.SECONDS);
                            if (!processLinux.isAlive() && processLinux.exitValue() != 0) continue;
                            break;
                        }
                        catch (Exception exception) {
                            errorMessages = errorMessages + exception.getMessage() + "\n\n";
                        }
                    }
                    if (errorMessages.length() > 0) {
                        try {
                            JOptionPane.showMessageDialog(null, errorMessages);
                        }
                        catch (Throwable throwable) {}
                    }
                    break;
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("The using the os specific fallback failed: ", ex);
        }
    }

    private static int getOperatingSystem() {
        int os = 0;
        try {
            String osName = System.getProperty("os.name");
            if (osName.indexOf("Win") != -1) {
                os = 1;
            } else if (osName.indexOf("Mac") != -1) {
                os = 2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return os;
    }

    static {
        SKIP_SETUP_FROM_CLI = false;
        try {
            SKIP_SETUP_FROM_CLI = Boolean.valueOf(System.getenv("SKIP_SETUP_FROM_CLI"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            AccessController.doPrivileged(() -> {
                String str = System.getProperty("java.vm.specification.version");
                double version = Double.parseDouble(str);
                String msg = version < 17.0 ? "Your Java version " + str + " is too old. Please try a newer version of Java. The minimum version is " + 17 + "\nCurrent Java installation directory: " + System.getProperty("java.home") : (version >= 26.0 ? "Your Java version " + str + " is too new and has never been tested with this software. Please update to the latest version of the product or switch to Java version " + 25 + "\nCurrent Java installation directory: " + System.getProperty("java.home") : null);
                if (msg != null) {
                    if (GraphicsEnvironment.isHeadless()) {
                        System.err.println(msg);
                    } else {
                        JOptionPane.showMessageDialog(null, msg, "Setup Error", 0);
                    }
                }
                return null;
            });
        }
        catch (Throwable th) {
            th.printStackTrace(System.err);
        }
    }
}

