/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.parser;

import java.io.IOException;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import net.sourceforge.jeuclid.DOMBuilder;
import net.sourceforge.jeuclid.MathBase;
import net.sourceforge.jeuclid.ParameterKey;
import net.sourceforge.jeuclid.parser.Parser;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MathBaseFactory {
    private static MathBaseFactory mathBaseFactory;
    private final Parser parser = Parser.getParser();

    private MathBaseFactory() throws ParserConfigurationException {
    }

    public static synchronized MathBaseFactory getMathBaseFactory() throws ParserConfigurationException {
        if (mathBaseFactory == null) {
            mathBaseFactory = new MathBaseFactory();
        }
        return mathBaseFactory;
    }

    public MathBase createMathBase(Source source, Map<ParameterKey, String> params) throws IOException {
        try {
            Node node = this.parser.parse(source);
            MathBase base = new MathBase(params);
            new DOMBuilder(node, base);
            return base;
        }
        catch (SAXException e) {
            throw new IOException("Parse Error: " + e.getMessage());
        }
    }
}

