/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.elements.presentation.table;

import java.util.List;
import java.util.Vector;
import net.sourceforge.jeuclid.MathBase;
import net.sourceforge.jeuclid.elements.presentation.general.AbstractRowLike;
import net.sourceforge.jeuclid.elements.presentation.table.Maligngroup;
import net.sourceforge.jeuclid.elements.presentation.table.Malignmark;
import org.w3c.dom.mathml.MathMLTableCellElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mtd
extends AbstractRowLike
implements MathMLTableCellElement {
    public static final String ELEMENT = "mtd";
    public static final String ATTR_ROWSPAN = "rowspan";
    public static final String ATTR_COLUMNSPAN = "columnspan";
    private static final String VALUE_ONE = "1";
    private final List<Maligngroup> groups = new Vector<Maligngroup>();

    public Mtd(MathBase base) {
        super(base);
        this.setDefaultMathAttribute(ATTR_ROWSPAN, VALUE_ONE);
        this.setDefaultMathAttribute(ATTR_COLUMNSPAN, VALUE_ONE);
    }

    public void addAlignGroupElement(Maligngroup element) {
        this.groups.add(element);
    }

    public List<Maligngroup> getAlignGroups() {
        return this.groups;
    }

    public void addAlignMarkElement(Malignmark mark) {
        if (this.groups == null || this.groups.size() == 0) {
            return;
        }
        this.groups.get(this.groups.size() - 1).setMark(mark);
    }

    @Override
    public String getRowspan() {
        return this.getMathAttribute(ATTR_ROWSPAN);
    }

    @Override
    public void setRowspan(String rowspan) {
        this.setAttribute(ATTR_ROWSPAN, rowspan);
    }

    @Override
    public String getColumnspan() {
        return this.getMathAttribute(ATTR_COLUMNSPAN);
    }

    @Override
    public void setColumnspan(String columnspan) {
        this.setAttribute(ATTR_COLUMNSPAN, columnspan);
    }

    @Override
    public String getRowalign() {
        return this.getMathAttribute("rowalign");
    }

    @Override
    public void setRowalign(String rowalign) {
        this.setAttribute("rowalign", rowalign);
    }

    @Override
    public String getColumnalign() {
        return this.getMathAttribute("columnalign");
    }

    @Override
    public void setColumnalign(String columnalign) {
        this.setAttribute("columnalign", columnalign);
    }

    @Override
    public String getGroupalign() {
        return this.getMathAttribute("groupalign");
    }

    @Override
    public void setGroupalign(String groupalign) {
        this.setAttribute("groupalign", groupalign);
    }

    @Override
    public String getTagName() {
        return ELEMENT;
    }

    @Override
    public String getCellindex() {
        return Integer.toString(this.getParent().getIndexOfMathElement(this));
    }

    @Override
    public boolean getHasaligngroups() {
        return this.getGroupalign() != null;
    }
}

