/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.elements.presentation.general;

import java.util.List;
import java.util.Vector;
import net.sourceforge.jeuclid.MathBase;
import net.sourceforge.jeuclid.elements.AbstractElementWithDelegates;
import net.sourceforge.jeuclid.elements.JEuclidElement;
import net.sourceforge.jeuclid.elements.presentation.token.Mo;
import org.w3c.dom.mathml.MathMLFencedElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mfenced
extends AbstractElementWithDelegates
implements MathMLFencedElement {
    public static final String ATTR_SEPARATORS = "separators";
    public static final String ATTR_CLOSE = "close";
    public static final String ATTR_OPEN = "open";
    public static final String ELEMENT = "mfenced";
    private static final String FENCE_SPACE = "0.2em";

    public Mfenced(MathBase base) {
        super(base);
        this.setDefaultMathAttribute(ATTR_OPEN, "(");
        this.setDefaultMathAttribute(ATTR_CLOSE, ")");
        this.setDefaultMathAttribute(ATTR_SEPARATORS, ",");
    }

    @Override
    public String getOpen() {
        return this.getMathAttribute(ATTR_OPEN);
    }

    @Override
    public void setOpen(String open) {
        this.setAttribute(ATTR_OPEN, open);
    }

    @Override
    public String getClose() {
        return this.getMathAttribute(ATTR_CLOSE);
    }

    @Override
    public void setClose(String close) {
        this.setAttribute(ATTR_CLOSE, close);
    }

    @Override
    public String getSeparators() {
        StringBuilder retVal = new StringBuilder();
        String attValue = this.getMathAttribute(ATTR_SEPARATORS);
        if (attValue != null) {
            for (int i = 0; i < attValue.length(); ++i) {
                char c = attValue.charAt(i);
                if (c < ' ') continue;
                retVal.append(c);
            }
        }
        return retVal.toString();
    }

    @Override
    public void setSeparators(String separators) {
        this.setAttribute(ATTR_SEPARATORS, separators);
    }

    @Override
    protected List<JEuclidElement> createDelegates() {
        Vector<JEuclidElement> retVal = new Vector<JEuclidElement>();
        Mo opOpen = new Mo(this.getMathBase());
        opOpen.setFence(MathBase.TRUE);
        opOpen.setStretchy(MathBase.TRUE);
        opOpen.setRspace(FENCE_SPACE);
        opOpen.setLspace(FENCE_SPACE);
        opOpen.setSymmetric(MathBase.FALSE);
        opOpen.setForm("prefix");
        opOpen.addText(this.getOpen());
        retVal.add(opOpen);
        String sep = this.getSeparators();
        for (int i = 0; i < this.getMathElementCount(); ++i) {
            retVal.add(this.getMathElement(i));
            if (sep.length() <= 0 || i >= this.getMathElementCount() - 1) continue;
            Mo opSep = new Mo(this.getMathBase());
            opSep.setSeparator(MathBase.TRUE);
            if (i < sep.length()) {
                opSep.addText(String.valueOf(sep.charAt(i)));
            } else {
                opSep.addText(String.valueOf(sep.charAt(sep.length() - 1)));
            }
            retVal.add(opSep);
        }
        Mo opClose = new Mo(this.getMathBase());
        opClose.setFence(MathBase.TRUE);
        opClose.setRspace(FENCE_SPACE);
        opClose.setLspace(FENCE_SPACE);
        opClose.setStretchy(MathBase.TRUE);
        opClose.setSymmetric(MathBase.FALSE);
        opClose.setForm("postfix");
        opClose.addText(this.getClose());
        retVal.add(opClose);
        return retVal;
    }

    @Override
    public String getTagName() {
        return ELEMENT;
    }
}

